/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModularRingFactory;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class HenselUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)HenselUtilTest.suite());
        ComputerThreads.terminate();
    }

    public HenselUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(HenselUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static java.math.BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 93L));
    }

    protected static java.math.BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new java.math.BigInteger("" + (l -= 35L));
    }

    public void testHenselLifting() {
        BigInteger bigInteger;
        java.math.BigInteger bigInteger2 = HenselUtilTest.getPrime1();
        BigInteger bigInteger3 = bigInteger = new BigInteger(bigInteger2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger2, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, 1, this.to);
        for (int i = 1; i < 3; ++i) {
            BigInteger bigInteger4;
            GenPolynomial<ModInteger> genPolynomial;
            GenPolynomial<ModInteger> genPolynomial2;
            GenPolynomial<ModInteger>[] genPolynomialArray;
            this.a = this.dfac.random(this.kl + 70 * i, this.ll, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) < 1L || this.b.degree(0) < 2L) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial3.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial4.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial5.degreeVector()) || !(genPolynomialArray = (genPolynomial2 = genPolynomial3).egcd(genPolynomial = genPolynomial4))[0].isONE()) continue;
            GenPolynomial<ModInteger> genPolynomial6 = genPolynomialArray[1];
            GenPolynomial<ModInteger> genPolynomial7 = genPolynomialArray[2];
            BigInteger bigInteger5 = this.a.maxNorm();
            bigInteger3 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger6 = this.c.maxNorm();
            if (bigInteger6.compareTo(bigInteger3) > 0) {
                bigInteger3 = bigInteger6;
            }
            try {
                HenselApprox<ModInteger> henselApprox = HenselUtil.liftHensel(this.c, bigInteger3, genPolynomial3, genPolynomial4, genPolynomial6, genPolynomial7);
                GenPolynomial<BigInteger> genPolynomial8 = henselApprox.A;
                GenPolynomial<BigInteger> genPolynomial9 = henselApprox.B;
                GenPolynomial<GenPolynomial<BigInteger>> genPolynomial10 = genPolynomial8.multiply((BigInteger)((Object)genPolynomial9));
                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, genPolynomial10);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselUtilTest.fail((String)("" + noLiftingException));
            }
        }
    }

    public void testHenselLiftingGcd() {
        BigInteger bigInteger;
        java.math.BigInteger bigInteger2 = new java.math.BigInteger("19");
        BigInteger bigInteger3 = bigInteger = new BigInteger(bigInteger2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger2, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, 1, this.to);
        for (int i = 1; i < 3; ++i) {
            BigInteger bigInteger4;
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) < 1L || this.b.degree(0) < 2L) continue;
            GenPolynomial<ModInteger> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial3.degreeVector())) continue;
            BigInteger bigInteger5 = this.a.maxNorm();
            bigInteger3 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger6 = this.c.maxNorm();
            if (bigInteger6.compareTo(bigInteger3) > 0) {
                bigInteger3 = bigInteger6;
            }
            long l = System.currentTimeMillis();
            try {
                HenselApprox<ModInteger> henselApprox = HenselUtil.liftHensel(this.c, bigInteger3, genPolynomial, genPolynomial2);
                l = System.currentTimeMillis() - l;
                GenPolynomial<BigInteger> genPolynomial4 = henselApprox.A;
                GenPolynomial<BigInteger> genPolynomial5 = henselApprox.B;
                GenPolynomial<GenPolynomial<BigInteger>> genPolynomial6 = genPolynomial4.multiply((BigInteger)((Object)genPolynomial5));
                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, genPolynomial6);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                // empty catch block
            }
        }
    }

    public void testHenselQuadraticLifting() {
        BigInteger bigInteger;
        java.math.BigInteger bigInteger2 = new java.math.BigInteger("19");
        BigInteger bigInteger3 = bigInteger = new BigInteger(bigInteger2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger2, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial;
            GenPolynomial<BigInteger> genPolynomial2;
            GenPolynomial<BigInteger> genPolynomial3;
            HenselApprox<ModInteger> henselApprox;
            BigInteger bigInteger4;
            GenPolynomial<ModInteger> genPolynomial4;
            GenPolynomial<ModInteger> genPolynomial5;
            GenPolynomial<ModInteger>[] genPolynomialArray;
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) < 1L || this.b.degree(0) < 2L) continue;
            GenPolynomial<ModInteger> genPolynomial6 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial6.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial7 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial7.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial8 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial8.degreeVector()) || !(genPolynomialArray = (genPolynomial5 = genPolynomial6).egcd(genPolynomial4 = genPolynomial7))[0].isONE()) continue;
            GenPolynomial<ModInteger> genPolynomial9 = genPolynomialArray[1];
            GenPolynomial<ModInteger> genPolynomial10 = genPolynomialArray[2];
            BigInteger bigInteger5 = this.a.maxNorm();
            bigInteger3 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger6 = this.c.maxNorm();
            if (bigInteger6.compareTo(bigInteger3) > 0) {
                bigInteger3 = bigInteger6;
            }
            long l = System.currentTimeMillis();
            try {
                henselApprox = HenselUtil.liftHenselQuadratic(this.c, bigInteger3, genPolynomial6, genPolynomial7, genPolynomial9, genPolynomial10);
                l = System.currentTimeMillis() - l;
                genPolynomial3 = henselApprox.A;
                genPolynomial2 = henselApprox.B;
                genPolynomial = genPolynomial3.multiply((BigInteger)((Object)genPolynomial2));
                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, genPolynomial);
            }
            catch (NoLiftingException noLiftingException) {
                HenselUtilTest.fail((String)("" + noLiftingException));
            }
            boolean bl = false;
            if (!bl) continue;
            bl = true;
            long l2 = System.currentTimeMillis();
            try {
                henselApprox = HenselUtil.liftHensel(this.c, bigInteger3, genPolynomial6, genPolynomial7, genPolynomial9, genPolynomial10);
                l2 = System.currentTimeMillis() - l2;
                genPolynomial3 = henselApprox.A;
                genPolynomial2 = henselApprox.B;
                genPolynomial = genPolynomial3.multiply((BigInteger)((Object)genPolynomial2));
                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, genPolynomial);
            }
            catch (NoLiftingException noLiftingException) {
                HenselUtilTest.fail((String)("" + noLiftingException));
            }
            System.out.println("\nquadratic Hensel time = " + l);
            System.out.println("linear    Hensel time = " + l2);
        }
    }

    public void testHenselQuadraticLiftingGcd() {
        BigInteger bigInteger;
        java.math.BigInteger bigInteger2 = new java.math.BigInteger("19");
        BigInteger bigInteger3 = bigInteger = new BigInteger(bigInteger2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger2, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to);
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger3, genPolynomialRing);
        for (int i = 1; i < 3; ++i) {
            BigInteger bigInteger4;
            this.a = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.b = this.dfac.random(this.kl + 70 * i, this.ll + 10, this.el + 5, this.q).abs();
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            if (this.a.degree(0) < 1L || this.b.degree(0) < 2L) continue;
            GenPolynomial<ModInteger> genPolynomial = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial3.degreeVector())) continue;
            BigInteger bigInteger5 = this.a.maxNorm();
            bigInteger3 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger6 = this.c.maxNorm();
            if (bigInteger6.compareTo(bigInteger3) > 0) {
                bigInteger3 = bigInteger6;
            }
            long l = System.currentTimeMillis();
            try {
                HenselApprox<ModInteger> henselApprox = HenselUtil.liftHenselQuadratic(this.c, bigInteger3, genPolynomial, genPolynomial2);
                l = System.currentTimeMillis() - l;
                GenPolynomial<BigInteger> genPolynomial4 = henselApprox.A;
                GenPolynomial<BigInteger> genPolynomial5 = henselApprox.B;
                GenPolynomial<GenPolynomial<BigInteger>> genPolynomial6 = genPolynomial4.multiply((BigInteger)((Object)genPolynomial5));
                HenselUtilTest.assertEquals((String)"lift(a b mod p) = a b", this.c, genPolynomial6);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                // empty catch block
            }
        }
    }

    public void testLiftingEgcd() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("5");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger2, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger2);
        for (int i = 1; i < 2; ++i) {
            BigInteger bigInteger3;
            GenPolynomial<ModInteger> genPolynomial;
            this.a = this.dfac.random(this.kl + 3 * i, this.ll + 1, this.el + 1, this.q).abs();
            this.b = this.dfac.random(this.kl + 3 * i, this.ll + 1, this.el + 5, this.q).abs();
            this.d = greatestCommonDivisorAbstract.baseGcd(this.a, this.b);
            if (!this.d.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.d);
                this.b = PolyUtil.basePseudoDivide(this.b, this.d);
            }
            if (this.a.degree(0) < 1L || this.b.degree(0) < 2L) continue;
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial3.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial3)).isONE()) continue;
            this.c = this.a.multiply((BigInteger)((Object)this.b));
            GenPolynomial<RingElem<ModInteger>> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial4.degreeVector())) continue;
            BigInteger bigInteger4 = this.a.maxNorm();
            BigInteger bigInteger5 = bigInteger4.compareTo(bigInteger3 = this.b.maxNorm()) > 0 ? bigInteger4 : bigInteger3;
            BigInteger bigInteger6 = this.c.maxNorm();
            if (bigInteger6.compareTo(bigInteger5) > 0) {
                bigInteger5 = bigInteger6;
            }
            long l = 1L;
            BigInteger bigInteger7 = bigInteger2;
            while (bigInteger7.compareTo(bigInteger5) < 0) {
                ++l;
                bigInteger7 = bigInteger7.multiply(bigInteger2);
            }
            long l2 = System.currentTimeMillis();
            try {
                GenPolynomial<ModInteger>[] genPolynomialArray = HenselUtil.liftExtendedEuclidean(genPolynomial2, genPolynomial3, l);
                l2 = System.currentTimeMillis() - l2;
                GenPolynomial<ModInteger> genPolynomial5 = genPolynomialArray[0];
                GenPolynomial<ModInteger> genPolynomial6 = genPolynomialArray[1];
                ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomial5.ring.coFac;
                GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(modularRingFactory, genPolynomialRing);
                genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, PolyUtil.integerFromModularCoefficients(this.dfac, genPolynomial2));
                genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, PolyUtil.integerFromModularCoefficients(this.dfac, genPolynomial3));
                genPolynomial4 = genPolynomial5.multiply((ModInteger)((Object)genPolynomial2)).sum((GenPolynomial<ModInteger>)genPolynomial6.multiply((ModInteger)((Object)genPolynomial3)));
                HenselUtilTest.assertTrue((String)("lift(s a + t b mod p^k) = 1: " + genPolynomial4), (boolean)genPolynomial4.isONE());
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselUtilTest.fail((String)("" + noLiftingException));
            }
        }
    }

    public void testLiftingEgcdList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger2, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger2);
        for (int i = 1; i < 2; ++i) {
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            GenPolynomial<ModInteger> genPolynomial;
            this.a = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 1, this.q).abs();
            this.b = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 5, this.q).abs();
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) < 1L || this.b.degree(0) < 1L) continue;
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial3.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial3)).isONE()) continue;
            this.d = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 4, this.q).abs();
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.d);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.b, this.d);
            if (!this.e.isONE()) {
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            if (this.d.degree(0) < 1L) continue;
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
            if (!this.d.degreeVector().equals(genPolynomial4.degreeVector())) continue;
            this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial5.degreeVector())) continue;
            BigInteger bigInteger5 = this.a.maxNorm();
            BigInteger bigInteger6 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger7 = this.c.maxNorm();
            if (bigInteger7.compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger7;
            }
            if ((bigInteger3 = this.d.maxNorm()).compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger3;
            }
            long l = 1L;
            BigInteger bigInteger8 = bigInteger2;
            while (bigInteger8.compareTo(bigInteger6) < 0) {
                ++l;
                bigInteger8 = bigInteger8.multiply(bigInteger2);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial3);
            arrayList.add(genPolynomial4);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            long l2 = System.currentTimeMillis();
            try {
                arrayList2.add(genPolynomial2);
                arrayList2.add(genPolynomial3);
                GenPolynomial<ModInteger>[] genPolynomialArray = HenselUtil.liftExtendedEuclidean(genPolynomial2, genPolynomial3, l);
                List list = HenselUtil.liftExtendedEuclidean(arrayList, l);
                l2 = System.currentTimeMillis() - l2;
                List list2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(this.dfac, list));
                boolean bl = HenselUtil.isExtendedEuclideanLift(arrayList, list2);
                HenselUtilTest.assertTrue((String)"lift(s0,s1,s2) mod p^k) = 1: ", (boolean)bl);
                arrayList3.add(genPolynomialArray[1]);
                arrayList3.add(genPolynomialArray[0]);
                arrayList3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(this.dfac, arrayList3));
                bl = HenselUtil.isExtendedEuclideanLift(arrayList2, arrayList3);
                HenselUtilTest.assertTrue((String)"lift(s a + t b mod p^k) = 1: ", (boolean)bl);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                // empty catch block
            }
        }
    }

    public void testLiftingDiophantList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("19");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger2, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger2);
        for (int i = 1; i < 2; ++i) {
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            GenPolynomial<ModInteger> genPolynomial;
            this.a = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 1, this.q).abs();
            this.b = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 5, this.q).abs();
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) < 1L || this.b.degree(0) < 1L) continue;
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial3.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial3)).isONE()) continue;
            this.d = this.dfac.random(this.kl + 3 * i, this.ll + 5, this.el + 4, this.q).abs();
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.d);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.b, this.d);
            if (!this.e.isONE()) {
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            if (this.d.degree(0) < 1L) continue;
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
            if (!this.d.degreeVector().equals(genPolynomial4.degreeVector())) continue;
            this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial5.degreeVector())) continue;
            BigInteger bigInteger5 = this.a.maxNorm();
            BigInteger bigInteger6 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger7 = this.c.maxNorm();
            if (bigInteger7.compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger7;
            }
            if ((bigInteger3 = this.d.maxNorm()).compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger3;
            }
            long l = 1L;
            BigInteger bigInteger8 = bigInteger2;
            while (bigInteger8.compareTo(bigInteger6) < 0) {
                ++l;
                bigInteger8 = bigInteger8.multiply(bigInteger2);
            }
            Element element = genPolynomialRing.random(4);
            ArrayList<GenPolynomial<ModInteger>> arrayList = new ArrayList<GenPolynomial<ModInteger>>();
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial3);
            arrayList.add(genPolynomial4);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            long l2 = System.currentTimeMillis();
            try {
                arrayList2.add(genPolynomial2);
                arrayList2.add(genPolynomial3);
                List<GenPolynomial<ModInteger>> list = HenselUtil.liftDiophant(genPolynomial2, genPolynomial3, element, l);
                List list2 = HenselUtil.liftDiophant(arrayList2, element, l);
                l2 = System.currentTimeMillis() - l2;
                List list3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(this.dfac, list2));
                boolean bl = HenselUtil.isDiophantLift(arrayList2, list3, element);
                HenselUtilTest.assertTrue((String)"lift(s0,s1,s2) mod p^k) = 1: ", (boolean)bl);
                arrayList3.add(list.get(0));
                arrayList3.add(list.get(1));
                arrayList3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, PolyUtil.integerFromModularCoefficients(this.dfac, arrayList3));
                bl = HenselUtil.isDiophantLift(arrayList2, arrayList3, element);
                HenselUtilTest.assertTrue((String)"lift(s a + t b mod p^k) = 1: ", (boolean)bl);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                // empty catch block
            }
        }
    }

    public void testHenselLiftingMonicList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("268435399");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger2, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger2);
        BigInteger bigInteger3 = bigInteger2.getONE();
        for (int i = 1; i < 2; ++i) {
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            GenPolynomial<ModInteger> genPolynomial;
            AbelianGroupElem<ExpVector> abelianGroupElem;
            this.a = this.dfac.parse("(x^3 + 20 x^2 - 313131)");
            this.b = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 5, this.q).abs();
            if (!this.a.leadingBaseCoefficient().isUnit()) {
                abelianGroupElem = this.a.leadingExpVector();
                this.a.doPutToMap((ExpVector)abelianGroupElem, bigInteger3);
            }
            if (!this.b.leadingBaseCoefficient().isUnit()) {
                abelianGroupElem = this.b.leadingExpVector();
                this.b.doPutToMap((ExpVector)abelianGroupElem, bigInteger3);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) < 1L) {
                this.a = this.dfac.parse("(x^3 + 20 x^2 - 313131)");
            }
            if (this.b.degree(0) < 1L) {
                this.b = this.dfac.parse("(x^4 + 23 x^3 - 32)");
            }
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial3.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial3)).isONE()) continue;
            this.d = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 4, this.q).abs();
            if (!this.d.leadingBaseCoefficient().isUnit()) {
                abelianGroupElem = this.d.leadingExpVector();
                this.d.doPutToMap((ExpVector)abelianGroupElem, bigInteger3);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.d);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.b, this.d);
            if (!this.e.isONE()) {
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            if (this.d.degree(0) < 1L) {
                this.d = this.dfac.parse("(x^2 + 22 x - 33)");
            }
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
            if (!this.d.degreeVector().equals(genPolynomial4.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial4)).isONE() || !(genPolynomial = genPolynomial3.gcd(genPolynomial4)).isONE()) continue;
            this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial5.degreeVector())) continue;
            BigInteger bigInteger6 = this.a.maxNorm();
            abelianGroupElem = bigInteger6.compareTo(bigInteger5 = this.b.maxNorm()) > 0 ? bigInteger6 : bigInteger5;
            BigInteger bigInteger7 = this.c.maxNorm();
            if (bigInteger7.compareTo((BigInteger)abelianGroupElem) > 0) {
                abelianGroupElem = bigInteger7;
            }
            if ((bigInteger4 = this.d.maxNorm()).compareTo((BigInteger)abelianGroupElem) > 0) {
                abelianGroupElem = bigInteger4;
            }
            long l = 1L;
            BigInteger bigInteger8 = bigInteger2;
            while (bigInteger8.compareTo((BigInteger)abelianGroupElem) < 0) {
                ++l;
                bigInteger8 = bigInteger8.multiply(bigInteger2);
            }
            ++l;
            bigInteger8 = bigInteger8.multiply(bigInteger2);
            ArrayList arrayList = new ArrayList();
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial3);
            arrayList.add(genPolynomial4);
            arrayList = PolyUtil.monic(arrayList);
            long l2 = System.currentTimeMillis();
            try {
                List list = HenselUtil.liftHenselMonic(this.c, arrayList, l);
                l2 = System.currentTimeMillis() - l2;
                List<GenPolynomial<BigInteger>> list2 = PolyUtil.integerFromModularCoefficients(this.dfac, list);
                boolean bl = HenselUtil.isHenselLift(this.c, bigInteger2, bigInteger8, list2);
                HenselUtilTest.assertTrue((String)("prod(lift(L)) = c: " + this.c), (boolean)bl);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                // empty catch block
            }
        }
    }

    public void testHenselLiftingList() {
        java.math.BigInteger bigInteger = new java.math.BigInteger("268435399");
        BigInteger bigInteger2 = new BigInteger(bigInteger);
        ModIntegerRing modIntegerRing = new ModIntegerRing(bigInteger, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, this.to, new String[]{"x"});
        this.dfac = new GenPolynomialRing<BigInteger>(bigInteger2, genPolynomialRing);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getProxy(bigInteger2);
        for (int i = 1; i < 2; ++i) {
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            GenPolynomial<ModInteger> genPolynomial;
            this.a = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 3, this.q).abs();
            this.a = greatestCommonDivisorAbstract.basePrimitivePart(this.a);
            this.b = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 5, this.q).abs();
            this.b = greatestCommonDivisorAbstract.basePrimitivePart(this.b);
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.b);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
            }
            if (this.a.degree(0) < 1L) {
                this.a = this.dfac.parse("( 3 x^3 + 20 x^2 - 313131)");
            }
            if (this.b.degree(0) < 1L) {
                this.b = this.dfac.parse("( 5 x^4 + 23 x^3 - 32)");
            }
            GenPolynomial<ModInteger> genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.a);
            if (!this.a.degreeVector().equals(genPolynomial2.degreeVector())) continue;
            GenPolynomial<ModInteger> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.b);
            if (!this.b.degreeVector().equals(genPolynomial3.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial3)).isONE()) continue;
            this.d = this.dfac.random(this.kl + 30 * i, this.ll + 5, this.el + 4, this.q).abs();
            this.d = greatestCommonDivisorAbstract.basePrimitivePart(this.d);
            this.e = greatestCommonDivisorAbstract.baseGcd(this.a, this.d);
            if (!this.e.isONE()) {
                this.a = PolyUtil.basePseudoDivide(this.a, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            this.e = greatestCommonDivisorAbstract.baseGcd(this.b, this.d);
            if (!this.e.isONE()) {
                this.b = PolyUtil.basePseudoDivide(this.b, this.e);
                this.d = PolyUtil.basePseudoDivide(this.d, this.e);
            }
            if (this.d.degree(0) < 1L) {
                this.d = this.dfac.parse("( 7 x^2 + 22 x - 33)");
            }
            GenPolynomial<ModInteger> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.d);
            if (!this.d.degreeVector().equals(genPolynomial4.degreeVector()) || !(genPolynomial = genPolynomial2.gcd(genPolynomial4)).isONE() || !(genPolynomial = genPolynomial3.gcd(genPolynomial4)).isONE()) continue;
            this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.d);
            GenPolynomial<ModInteger> genPolynomial5 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, this.c);
            if (!this.c.degreeVector().equals(genPolynomial5.degreeVector())) continue;
            BigInteger bigInteger5 = this.a.maxNorm();
            BigInteger bigInteger6 = bigInteger5.compareTo(bigInteger4 = this.b.maxNorm()) > 0 ? bigInteger5 : bigInteger4;
            BigInteger bigInteger7 = this.c.maxNorm();
            if (bigInteger7.compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger7;
            }
            if ((bigInteger3 = this.d.maxNorm()).compareTo(bigInteger6) > 0) {
                bigInteger6 = bigInteger3;
            }
            long l = 1L;
            BigInteger bigInteger8 = bigInteger2;
            while (bigInteger8.compareTo(bigInteger6) < 0) {
                ++l;
                bigInteger8 = bigInteger8.multiply(bigInteger2);
            }
            ++l;
            bigInteger8 = bigInteger8.multiply(bigInteger2);
            ArrayList arrayList = new ArrayList();
            ArrayList<GenPolynomial<BigInteger>> arrayList2 = new ArrayList<GenPolynomial<BigInteger>>();
            arrayList2.add(this.a);
            arrayList2.add(this.b);
            arrayList2.add(this.d);
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial3);
            arrayList.add(genPolynomial4);
            long l2 = System.currentTimeMillis();
            try {
                List list = HenselUtil.liftHensel(this.c, arrayList, l, this.c.leadingBaseCoefficient());
                l2 = System.currentTimeMillis() - l2;
                List<GenPolynomial<BigInteger>> list2 = PolyUtil.integerFromModularCoefficients(this.dfac, list);
                boolean bl = HenselUtil.isHenselLift(this.c, bigInteger2, bigInteger8, list2);
                HenselUtilTest.assertTrue((String)("prod(lift(L)) = c: " + this.c), (boolean)bl);
                continue;
            }
            catch (NoLiftingException noLiftingException) {
                HenselUtilTest.fail((String)("" + noLiftingException));
            }
        }
    }
}

