/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeRingChar0;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeIntTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    int rl = 3;
    int kl = 7;
    int ll = 4;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    BigInteger fac;
    GreatestCommonDivisorAbstract<BigInteger> ufd;
    SquarefreeRingChar0<BigInteger> sqf;
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SquarefreeIntTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeIntTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SquarefreeIntTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.fac = new BigInteger(1L);
        this.ufd = GCDFactory.getProxy(this.fac);
        this.sqf = new SquarefreeRingChar0<BigInteger>(this.fac);
        SquarefreeAbstract<BigInteger> squarefreeAbstract = SquarefreeFactory.getImplementation(this.fac);
        SquarefreeIntTest.assertEquals((String)"sqf == sqff ", this.sqf.getClass(), squarefreeAbstract.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<BigInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeIntTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeIntTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeIntTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<BigInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sortedMap = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeIntTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<BigInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<BigInteger>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<BigInteger>)this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeIntTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeIntTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeIntTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<BigInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<BigInteger>)this.cr).multiply(this.br).multiply(this.br);
        SortedMap sortedMap = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeIntTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sortedMap));
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<BigInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeIntTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeIntTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeIntTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<BigInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigInteger)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sortedMap = this.sqf.squarefreeFactors((BigInteger)((Object)this.d));
        SquarefreeIntTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }
}

