/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.Monomial;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GroebnerBaseFGLMExamples {
    String all = "Zahlbereich | Ordnung    | Elements G | Elements L | bitHeight G | bitHeight L | Deg G | Deg L | Time G | Time FGLM | Time L";
    String grad = "Zahlbereich | Ordnung    | Elements G | bitHeight G | Deg G | Time G | vDim";
    String lex = "Zahlbereich | Ordnung      | Elements L | bitHeight L | Deg L | Time L";
    String fglm = "Zahlbereich | Ordnung      | Elements G | Elements L  | bitHeight G | bitHeight L |  Deg G | Deg L | Time G | Time FGLM";
    String modAll = "Zahlbereich | Ordnung    | Elements G | Elements L | Deg G | Deg L | Time G | Time FGLM | Time L";
    String modGrad = "Zahlbereich | Ordnung      | Elements G | Deg G | Time G";
    String modfglm = "Zahlbereich | Ordnung      | Elements G | Elements L | Deg G | Deg L | Time G | Time FGLM";

    public static void main(String[] stringArray) {
        GroebnerBaseFGLMExamples groebnerBaseFGLMExamples = new GroebnerBaseFGLMExamples();
        groebnerBaseFGLMExamples.testC5();
    }

    public void xtestFiveVarsOrder() {
        String string = "(  (v^8*x*y*z), ( w^3*x - 2*v), ( 4*x*y - 2 + y), ( 3*y^5 - 3 + z ), ( 8*y^2*z^2 + x * y^6 )) ";
        String[] stringArray = new String[]{"v", "w", "x", "y", "z"};
        String string2 = this.shuffle(stringArray);
        String string3 = this.modAll(string2, string, 13);
        String string4 = this.modAll(string2, string, 7);
        System.out.println(this.all);
        System.out.println("Mod 13");
        System.out.println(string3);
        System.out.println("Mod 7");
        System.out.println(string4);
    }

    public void xtestCAP() {
        String string = "(  (y^2*z + 2*x*y*t - 2*x - z),(-x^3*z + 4*x*y^2*z + 4*x^2*y*t + 2*y^3*t + 4*x^2 - 10*y^2 + 4*x*z - 10*y*t + 2),(2*y*z*t + x*t^2 - x - 2*z),(-x*z^3 + 4*y*z^2*t + 4*x*z*t^2 + 2*y*t^3 + 4*x*z + 4*z^2 - 10*y*t -10*t^2 + 2)) ";
        String string2 = "(x,y,z,t)";
        String string3 = "(t,z,y,x)";
        String string4 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string4);
        String string5 = this.all(string2, string);
        String string6 = this.all(string3, string);
        String string7 = this.modAll(string2, string, 1831);
        String string8 = this.modAll(string3, string, 1831);
        System.out.println(this.all);
        System.out.println(string5);
        System.out.println(string6);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(string7);
        System.out.println(string8);
    }

    public void xtestAUX() {
        String string = "(  (a^2*b*c + a*b^2*c + a*b*c^2 + a*b*c + a*b + a*c + b*c),(a^2*b^2*c + a*b^2*c^2 + a^2*b*c + a*b*c + b*c + a + c ),(a^2*b^2*c^2 + a^2*b^2*c + a*b^2*c + a*b*c + a*c + c + 1)) ";
        String string2 = "(a,b,c)";
        String string3 = "(c,b,a)";
        String string4 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string4);
        String string5 = this.all(string2, string);
        String string6 = this.all(string3, string);
        String string7 = this.modAll(string2, string, 1831);
        String string8 = this.modAll(string3, string, 1831);
        System.out.println(this.all);
        System.out.println(string5);
        System.out.println(string6);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(string7);
        System.out.println(string8);
    }

    public void testC5() {
        String string = "(  (a + b + c + d + e),(a*b + b*c + c*d + a*e + d*e),(a*b*c + b*c*d + a*b*e + a*d*e + c*d*e),(a*b*c*d + a*b*c*e + a*b*d*e + a*c*d*e + b*c*d*e),(a*b*c*d*e -1)) ";
        String string2 = "(a,b,c,d,e)";
        String string3 = "(e,d,c,b,a)";
        String string4 = this.grad(string2, string);
        String string5 = this.all(string2, string);
        String string6 = this.all(string3, string);
        String string7 = this.modAll(string2, string, 1831);
        String string8 = this.modAll(string3, string, 1831);
        System.out.println(this.grad);
        System.out.println(string4);
        System.out.println("");
        System.out.println(this.all);
        System.out.println(string5);
        System.out.println(string6);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(string7);
        System.out.println(string8);
    }

    public void xtestModC5() {
        String string = "(  (a + b + c + d + e),(a*b + b*c + c*d + a*e + d*e),(a*b*c + b*c*d + a*b*e + a*d*e + c*d*e),(b*c*d + a*b*c*e + a*b*d*e + a*c*d*e + b*c*d*e),(a*b*c*d*e -1)) ";
        String string2 = "(a,b,c,d,e)";
        String string3 = "(e,d,c,b,a)";
        String string4 = this.grad(string3, string);
        System.out.println(this.grad);
        System.out.println(string4);
    }

    public void xtestC6() {
        String string = "(  (a + b + c + d + e + f),(a*b + b*c + c*d + d*e + e*f + a*f),(a*b*c + b*c*d + c*d*e + d*e*f + a*e*f + a*b*f),(a*b*c*d + b*c*d*e + c*d*e*f + a*d*e*f + a*b*e*f + a*b*c*f),(a*b*c*d*e + b*c*d*e*f + a*c*d*e*f + a*b*d*e*f + a*b*c*e*f + a*b*c*d*f),(a*b*c*d*e*f - 1)) ";
        String string2 = "(a,b,c,d,e,f)";
        String string3 = "(f,e,d,c,b,a)";
    }

    public void xtestIsaac() {
        String string = "(  (8*w^2 + 5*w*x - 4*w*y + 2*w*z + 3*w + 5*x^2 + 2*x*y - 7*x*z - 7*x + 7*y^2 -8*y*z - 7*y + 7*z^2 - 8*z + 8),(3*w^2 - 5*w*x - 3*w*y - 6*w*z + 9*w + 4*x^2 + 2*x*y - 2*x*z + 7*x + 9*y^2 + 6*y*z + 5*y + 7*z^2 + 7*z + 5),(-2*w^2 + 9*w*x + 9*w*y - 7*w*z - 4*w + 8*x^2 + 9*x*y - 3*x*z + 8*x + 6*y^2 - 7*y*z + 4*y - 6*z^2 + 8*z + 2),(7*w^2 + 5*w*x + 3*w*y - 5*w*z - 5*w + 2*x^2 + 9*x*y - 7*x*z + 4*x -4*y^2 - 5*y*z + 6*y - 4*z^2 - 9*z + 2)) ";
        String string2 = "(w,x,y,z)";
        String string3 = "(z,y,x,w)";
        String string4 = this.grad(string3, string);
        System.out.println(this.grad);
        System.out.println(string4);
    }

    public void xtestNiermann() {
        String string = "(  (x^2 + x*y^2*z - 2*x*y + y^4 + y^2 + z^2),(-x^3*y^2 + x*y^2*z + x*y*z^3 - 2*x*y + y^4),(-2*x^2*y + x*y^4 + y*z^4 - 3)) ";
        String string2 = "(x,y,z)";
        String string3 = "(z,y,x)";
        String string4 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string4);
        String string5 = this.modfglm(string2, string, 1831);
        String string6 = this.modfglm(string3, string, 2147464751);
        System.out.println(this.modfglm);
        System.out.println(string5);
        System.out.println(string6);
    }

    public void ytestWalkS7() {
        String string = "(  (2*g*b + 2*f*c + 2*e*d + a^2 + a),(2*g*c + 2*f*d + e^2 + 2*b*a + b),(2*g*d + 2*f*e + 2*c*a + c + b^2),(2*g*e + f^2 + 2*d*a + d + 2*c*b),(2*g*f + 2*e*a + e + 2*d*b + c^2),(g^2 + 2*f*a + f + 2*e*b + 2*d*c),(2*g*a + g + 2*f*b + 2*e*c + d^2)) ";
        String string2 = "(a,b,c,d,e,f,g)";
        String string3 = "(g,f,e,d,c,b,a)";
        String string4 = this.fglm(string3, string);
        System.out.println(this.fglm);
        System.out.println(string4);
    }

    public void ytestCassouMod1() {
        String string = "(  (15*a^4*b*c^2 + 6*a^4*b^3 + 21*a^4*b^2*c - 144*a^2*b - 8*a^2*b^2*d - 28*a^2*b*c*d - 648*a^2*c + 36*c^2*d + 9*a^4*c^3 - 120),(30*b^3*a^4*c - 32*c*d^2*b - 720*c*a^2*b - 24*b^3*a^2*d - 432*b^2*a^2 + 576*d*b - 576*c*d + 16*b*a^2*c^2*d + 16*c^2*d^2 + 16*d^2*b^2 + 9*b^4*a^4 + 5184 + 39*c^2*a^4*b^2 + 18*c^3*a^4*b - 432*c^2*a^2 + 24*c^3*a^2*d - 16*b^2*a^2*c*d - 240*b),(216*c*a^2*b - 162*c^2*a^2 - 81*b^2*a^2 + 5184 + 1008*d*b - 1008*c*d + 15*b^2*a^2*c*d - 15*b^3*a^2*d - 80*c*d^2*b + 40*c^2*d^2 + 40*d^2*b^2),(261 + 4*c*a^2*b - 3*c^2*a^2 - 4*b^2*a^2 + 22*d*b - 22*c*d)) ";
        String string2 = "(a,b,c,d)";
        String string3 = "(d,c,b,a)";
        String string4 = this.modfglm(string3, string, 1831);
        String string5 = this.modfglm(string2, string, 1831);
        System.out.println(this.modfglm);
        System.out.println(string4);
        System.out.println(string5);
    }

    public void ytestOmdi1() {
        String string = "(  (a + c + v + 2*x - 1),(a*b + c*u + 2*v*w + 2*x*y + 2*x*z -2/3),(a*b^2 + c*u^2 + 2*v*w^2 + 2*x*y^2 + 2*x*z^2 - 2/5),(a*b^3 + c*u^3 + 2*v*w^3 + 2*x*y^3 + 2*x*z^3 - 2/7),(a*b^4 + c*u^4 + 2*v*w^4 + 2*x*y^4 + 2*x*z^4 - 2/9),(v*w^2 + 2*x*y*z - 1/9),(v*w^4 + 2*x*y^2*z^2 - 1/25),(v*w^3 + 2*x*y*z^2 + x*y^2*z - 1/15),(v*w^4 + x*y*z^3 + x*y^3*z -1/21)) ";
        String string2 = "(a,b,c,u,v,w,x,y,z)";
        String string3 = "(z,y,x,w,v,u,c,b,a)";
        String string4 = this.grad(string3, string);
        System.out.println(this.grad);
        System.out.println(string4);
    }

    public void ytestLamm1() {
        String string = "(  (45*x^8 + 3*x^7 + 39*x^6 + 30*x^5 + 13*x^4 + 41*x^3 + 5*x^2 + 46*x + 7),(49*x^7*y + 35*x*y^7 + 37*x*y^6 + 9*y^7 + 4*x^6 + 6*y^6 + 27*x^3*y^2 + 20*x*y^4 + 31*x^4 + 33*x^2*y + 24*x^2 + 49*y + 43)) ";
        String string2 = "(x,y)";
        String string3 = "(y,x)";
        String string4 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string4);
        String string5 = this.all(string2, string);
        String string6 = this.all(string3, string);
        String string7 = this.modAll(string2, string, 1831);
        String string8 = this.modAll(string3, string, 1831);
        System.out.println(this.all);
        System.out.println(string5);
        System.out.println(string6);
        System.out.println("\n");
        System.out.println(this.modAll);
        System.out.println(string7);
        System.out.println(string8);
    }

    public void xtestEquilibrium() {
        String string = "(  (y^4 - 20/7*z^2),(z^2*x^4 + 7/10*z*x^4 + 7/48*x^4 - 50/27*z^2 - 35/27*z - 49/216),(x^5*y^3 + 7/5*z^4*y^3 + 609/1000 *z^3*y^3 + 49/1250*z^2*y^3 - 27391/800000*z*y^3 - 1029/160000*y^3 + 3/7*z^5*x*y^2 +3/5*z^6*x*y^2 + 63/200*z^3*x*y^2 + 147/2000*z^2*x*y^2 + 4137/800000*z*x*y^2 - 7/20*z^4*x^2*y - 77/125*z^3*x^2*y- 23863/60000*z^2*x^2*y - 1078/9375*z*x^2*y - 24353/1920000*x^2*y - 3/20*z^4*x^3 - 21/100*z^3*x^3- 91/800*z^2*x^3 - 5887/200000*z*x^3 - 343/128000*x^3)) ";
        String string2 = "(x,y,z)";
        String string3 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string3);
    }

    public void xtestTrinks2() {
        String string = "(  (45*p + 35*s - 165*b - 36),(35*p + 40*z + 25*t - 27*s),(15*w + 25*p*s + 30*z - 18*t - 165*b^2),(-9*w + 15*p*t + 20*z*s),(w*p + 2*z*t - 11*b^3),(99*w - 11*s*b + 3*b^2),(b^2 + 33/50*b + 2673/10000)) ";
        String string2 = "(b,s,t,z,p,w)";
        String string3 = "(s,b,t,z,p,w)";
        String string4 = "(s,t,b,z,p,w)";
        String string5 = "(s,t,z,p,b,w)";
        String string6 = "(s,t,z,p,w,b)";
        String string7 = "(s,z,p,w,b,t)";
        String string8 = "(p,w,b,t,s,z)";
        String string9 = "(z,w,b,s,t,p)";
        String string10 = "(t,z,p,w,b,s)";
        String string11 = "(z,p,w,b,s,t)";
        String string12 = "(p,w,b,s,t,z)";
        String string13 = "(w,b,s,t,z,p)";
        String string14 = this.all(string2, string);
        String string15 = this.all(string3, string);
        String string16 = this.all(string4, string);
        String string17 = this.all(string5, string);
        String string18 = this.all(string6, string);
        String string19 = this.all(string7, string);
        String string20 = this.all(string8, string);
        String string21 = this.all(string9, string);
        String string22 = this.all(string10, string);
        String string23 = this.all(string11, string);
        String string24 = this.all(string12, string);
        String string25 = this.all(string13, string);
        System.out.println(this.all);
        System.out.println(string14);
        System.out.println(string15);
        System.out.println(string16);
        System.out.println(string17);
        System.out.println(string18);
        System.out.println(string19);
        System.out.println(string20);
        System.out.println(string21);
        System.out.println(string22);
        System.out.println(string23);
        System.out.println(string24);
        System.out.println(string25);
    }

    public void xtestHairerRungeKutta_1() {
        String string = "(  (a-f),(b-h-g),(e+d+c-1),(d*a+c*b-1/2),(d*a^2+c*b^2-1/3),(c*g*a-1/6)) ";
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        String string2 = this.shuffle(stringArray);
        String string3 = this.shuffle(stringArray);
        String string4 = this.shuffle(stringArray);
        String string5 = this.shuffle(stringArray);
        String string6 = this.shuffle(stringArray);
        String string7 = this.grad(string2, string);
        System.out.println(this.grad);
        System.out.println(string7);
        String string8 = this.lex(string2, string);
        String string9 = this.lex(string3, string);
        String string10 = this.lex(string4, string);
        String string11 = this.lex(string5, string);
        String string12 = this.lex(string6, string);
        System.out.println(this.lex);
        System.out.println(string8);
        System.out.println(string9);
        System.out.println(string10);
        System.out.println(string11);
        System.out.println(string12);
    }

    public String all(String string, String string2) {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        String string3 = string + " G " + string2;
        String string4 = string + " L " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        StringReader stringReader2 = new StringReader(string4);
        GenPolynomialTokenizer genPolynomialTokenizer2 = new GenPolynomialTokenizer(stringReader2);
        PolynomialList polynomialList2 = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
            polynomialList2 = genPolynomialTokenizer2.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + polynomialList);
        System.out.println("Input " + polynomialList2);
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(polynomialList2.list);
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list2 = groebnerBaseAbstract.GB(polynomialList.list);
        l2 = System.currentTimeMillis() - l2;
        GroebnerBaseFGLM<BigRational> groebnerBaseFGLM = new GroebnerBaseFGLM<BigRational>();
        long l3 = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list3 = groebnerBaseFGLM.convGroebnerToLex(list2);
        l3 = System.currentTimeMillis() - l3;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list2.get((int)0).ring, list2);
        OrderedPolynomialList orderedPolynomialList2 = new OrderedPolynomialList(list3.get((int)0).ring, list3);
        OrderedPolynomialList orderedPolynomialList3 = new OrderedPolynomialList(list.get((int)0).ring, list);
        int n = list2.size();
        int n2 = list3.size();
        long l4 = PolyUtil.totalDegreeLeadingTerm(list2);
        long l5 = PolyUtil.totalDegreeLeadingTerm(list);
        int n3 = this.bitHeight(list2);
        int n4 = this.bitHeight(list3);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + orderedPolynomialList2);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + orderedPolynomialList3);
        String string5 = "BigRational |" + string + " |" + n + "          |" + n2 + "          |" + n3 + "   |" + n4 + "           |" + l4 + "      |" + l5 + "    |" + l2 + "      |" + l3 + "       |" + l;
        if (!orderedPolynomialList2.equals(orderedPolynomialList3)) {
            throw new RuntimeException("FGLM != GB: " + orderedPolynomialList2 + " != " + orderedPolynomialList3);
        }
        return string5;
    }

    public String fglm(String string, String string2) {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        String string3 = string + " G " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + polynomialList);
        long l = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list = groebnerBaseAbstract.GB(polynomialList.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseFGLM<BigRational> groebnerBaseFGLM = new GroebnerBaseFGLM<BigRational>();
        long l2 = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list2 = groebnerBaseFGLM.convGroebnerToLex(list);
        l2 = System.currentTimeMillis() - l2;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list.get((int)0).ring, list);
        OrderedPolynomialList orderedPolynomialList2 = new OrderedPolynomialList(list2.get((int)0).ring, list2);
        int n = list.size();
        int n2 = list2.size();
        long l3 = PolyUtil.totalDegreeLeadingTerm(list);
        long l4 = PolyUtil.totalDegreeLeadingTerm(list2);
        int n3 = this.bitHeight(list);
        int n4 = this.bitHeight(list2);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + orderedPolynomialList2);
        String string4 = "BigRational |" + string + " |" + n + "         |" + n2 + "  |" + n3 + "   |" + n4 + "           |" + l3 + "      |" + l4 + "    |" + l + "      |" + l2;
        return string4;
    }

    public String grad(String string, String string2) {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        String string3 = string + " G " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + polynomialList);
        long l = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list = groebnerBaseAbstract.GB(polynomialList.list);
        l = System.currentTimeMillis() - l;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list.get((int)0).ring, list);
        GroebnerBaseFGLM<BigRational> groebnerBaseFGLM = new GroebnerBaseFGLM<BigRational>();
        long l2 = PolyUtil.totalDegreeLeadingTerm(list);
        List list2 = groebnerBaseFGLM.redTerms(list);
        OrderedPolynomialList orderedPolynomialList2 = new OrderedPolynomialList(list2.get((int)0).ring, list2);
        int n = list2.size();
        int n2 = list.size();
        int n3 = this.bitHeight(list);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        System.out.println("Reduced Terms" + orderedPolynomialList2);
        String string4 = "BigRational |" + string + " |" + n2 + "    |" + n3 + "    |" + l2 + "    |" + l + "    |" + n;
        return string4;
    }

    public String lex(String string, String string2) {
        BigRational bigRational = new BigRational();
        GroebnerBaseAbstract<BigRational> groebnerBaseAbstract = GBFactory.getImplementation(bigRational);
        String string3 = string + " L " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("Input " + polynomialList);
        long l = System.currentTimeMillis();
        List<GenPolynomial<BigRational>> list = groebnerBaseAbstract.GB(polynomialList.list);
        l = System.currentTimeMillis() - l;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list.get((int)0).ring, list);
        int n = list.size();
        long l2 = PolyUtil.totalDegreeLeadingTerm(list);
        int n2 = this.bitHeight(list);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + orderedPolynomialList);
        String string4 = "BigRational" + string + "|" + n + "     |" + n2 + "    |" + l2 + "    |" + l;
        return string4;
    }

    public String modAll(String string, String string2, Integer n) {
        ModIntegerRing modIntegerRing = new ModIntegerRing(n.intValue());
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(modIntegerRing);
        String string3 = "Mod " + modIntegerRing.modul + " " + string + " G " + string2;
        String string4 = "Mod " + modIntegerRing.modul + " " + string + " L " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        StringReader stringReader2 = new StringReader(string4);
        GenPolynomialTokenizer genPolynomialTokenizer2 = new GenPolynomialTokenizer(stringReader2);
        PolynomialList polynomialList2 = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
            polynomialList2 = genPolynomialTokenizer2.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + polynomialList);
        System.out.println("L= " + polynomialList2);
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(polynomialList2.list);
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        List list2 = groebnerBaseAbstract.GB(polynomialList.list);
        l2 = System.currentTimeMillis() - l2;
        GroebnerBaseFGLM groebnerBaseFGLM = new GroebnerBaseFGLM();
        long l3 = System.currentTimeMillis();
        List list3 = groebnerBaseFGLM.convGroebnerToLex(list2);
        l3 = System.currentTimeMillis() - l3;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list2.get((int)0).ring, list2);
        OrderedPolynomialList orderedPolynomialList2 = new OrderedPolynomialList(list3.get((int)0).ring, list3);
        List list4 = list;
        OrderedPolynomialList orderedPolynomialList3 = new OrderedPolynomialList(list4.get((int)0).ring, list4);
        int n2 = list2.size();
        int n3 = list3.size();
        long l4 = PolyUtil.totalDegreeLeadingTerm(list2);
        long l5 = PolyUtil.totalDegreeLeadingTerm(list);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + orderedPolynomialList2);
        System.out.println("Groebnerbase Buchberger (INVLEX) " + orderedPolynomialList3);
        String string5 = "Mod " + n + "    |" + string + " |" + n2 + "          |" + n3 + "          |" + l4 + "    |" + l5 + "    |" + l2 + "     |" + l3 + "    |" + l;
        if (!orderedPolynomialList2.equals(orderedPolynomialList3)) {
            throw new RuntimeException("FGLM != GB: " + orderedPolynomialList2 + " != " + orderedPolynomialList3);
        }
        return string5;
    }

    public String modGrad(String string, String string2, Integer n) {
        ModIntegerRing modIntegerRing = new ModIntegerRing(n.intValue());
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(modIntegerRing);
        String string3 = "Mod " + modIntegerRing.modul + " " + string + " G " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + polynomialList);
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(polynomialList.list);
        l = System.currentTimeMillis() - l;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list.get((int)0).ring, list);
        int n2 = list.size();
        long l2 = PolyUtil.totalDegreeLeadingTerm(list);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        String string4 = "Mod " + n + "    |" + string + " |" + n2 + "           |" + l2 + "    |" + l;
        return string4;
    }

    public String modfglm(String string, String string2, Integer n) {
        ModIntegerRing modIntegerRing = new ModIntegerRing(n.intValue());
        GroebnerBaseAbstract<ModInteger> groebnerBaseAbstract = GBFactory.getImplementation(modIntegerRing);
        String string3 = "Mod " + modIntegerRing.modul + " " + string + " G " + string2;
        StringReader stringReader = new StringReader(string3);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "fail";
        }
        System.out.println("G= " + polynomialList);
        long l = System.currentTimeMillis();
        List list = groebnerBaseAbstract.GB(polynomialList.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseFGLM groebnerBaseFGLM = new GroebnerBaseFGLM();
        long l2 = System.currentTimeMillis();
        List list2 = groebnerBaseFGLM.convGroebnerToLex(list);
        l2 = System.currentTimeMillis() - l2;
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(list.get((int)0).ring, list);
        OrderedPolynomialList orderedPolynomialList2 = new OrderedPolynomialList(list2.get((int)0).ring, list2);
        int n2 = list.size();
        int n3 = list2.size();
        long l3 = PolyUtil.totalDegreeLeadingTerm(list);
        long l4 = PolyUtil.totalDegreeLeadingTerm(list2);
        System.out.println("Order of Variables: " + string);
        System.out.println("Groebnerbases: ");
        System.out.println("Groebnerbase Buchberger (IGRLEX) " + orderedPolynomialList);
        System.out.println("Groebnerbase FGML (INVLEX) computed from Buchberger (IGRLEX) " + orderedPolynomialList2);
        String string4 = "Mod " + n + "    |" + string + " |" + n2 + "         |" + n3 + "           |" + l3 + "    |" + l4 + "    |" + l + "     |" + l2;
        return string4;
    }

    public String shuffle(String[] stringArray) {
        Collections.shuffle(Arrays.asList(stringArray));
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(ExpVector.varsToString(stringArray));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int bitHeight(List<GenPolynomial<BigRational>> list) {
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = BigInteger.ONE;
        for (GenPolynomial<BigRational> genPolynomial : list) {
            for (Monomial<BigRational> monomial : genPolynomial) {
                BigRational bigRational = monomial.coefficient();
                BigInteger bigInteger3 = bigRational.denominator().abs();
                BigInteger bigInteger4 = bigRational.numerator().abs();
                if (bigInteger3.compareTo(bigInteger) > 0) {
                    bigInteger = bigInteger3;
                }
                if (bigInteger4.compareTo(bigInteger2) <= 0) continue;
                bigInteger2 = bigInteger4;
            }
        }
        int n = bigInteger.compareTo(bigInteger2) > 0 ? bigInteger.bitLength() : bigInteger2.bitLength();
        return n;
    }
}

