/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.WordIdeal;
import edu.jas.arith.BigRational;
import edu.jas.gb.WordGroebnerBase;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class WordIdealTest
extends TestCase {
    TermOrder to;
    GenWordPolynomialRing<BigRational> fac;
    List<GenWordPolynomial<BigRational>> L;
    List<GenWordPolynomial<BigRational>> M;
    PolynomialList<BigRational> F;
    List<GenWordPolynomial<BigRational>> G;
    WordGroebnerBase<BigRational> bb;
    GenWordPolynomial<BigRational> a;
    GenWordPolynomial<BigRational> b;
    GenWordPolynomial<BigRational> c;
    GenWordPolynomial<BigRational> d;
    GenWordPolynomial<BigRational> e;
    int kl = 3;
    int ll = 5;
    int el = 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)WordIdealTest.suite());
    }

    public WordIdealTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordIdealTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] stringArray = new String[]{"x", "y", "z"};
        this.fac = new GenWordPolynomialRing<BigRational>(bigRational, stringArray);
        this.bb = new WordGroebnerBaseSeq<BigRational>();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testIdealSum() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.fac.random(this.kl, this.ll, this.el);
        this.e = this.d;
        this.L.add(this.a);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        this.L = this.bb.GB(this.L);
        WordIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        this.L.add(this.b);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false);
        WordIdealTest.assertTrue((String)"not isZERO( I )", (!wordIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.GB(this.L);
        WordIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertTrue((String)"not isZERO( I )", (!wordIdeal.isZERO() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        WordIdeal<BigRational> wordIdeal2 = wordIdeal;
        WordIdeal<BigRational> wordIdeal3 = wordIdeal2.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal3.equals(wordIdeal));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.c);
        WordIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isGB(this.L));
        wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, true);
        wordIdeal3 = wordIdeal2.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"K contains(I)", (boolean)wordIdeal3.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal3.contains(wordIdeal2));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.d);
        WordIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isGB(this.L));
        wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, true);
        wordIdeal = wordIdeal3;
        wordIdeal3 = wordIdeal2.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"K contains(I)", (boolean)wordIdeal3.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal3.contains(wordIdeal2));
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.e);
        WordIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isGB(this.L));
        wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, true);
        wordIdeal = wordIdeal3;
        wordIdeal3 = wordIdeal2.sum(wordIdeal);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"equals( K, I )", (boolean)wordIdeal3.equals(wordIdeal));
        WordIdealTest.assertTrue((String)"K contains(J)", (boolean)wordIdeal3.contains(wordIdeal));
        WordIdealTest.assertTrue((String)"I contains(K)", (boolean)wordIdeal.contains(wordIdeal3));
    }

    public void testWordIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.c;
        this.e = this.d;
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.a);
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, false);
        WordIdealTest.assertTrue((String)"not isONE( I )", (!wordIdeal.isONE() || this.a.isConstant() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( I )", (boolean)wordIdeal.isGB());
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.L.add(this.b);
        WordIdeal<BigRational> wordIdeal2 = new WordIdeal<BigRational>(this.fac, this.L, false);
        WordIdealTest.assertTrue((String)"not isONE( J )", (!wordIdeal2.isONE() || this.a.isConstant() || this.b.isConstant() ? 1 : 0) != 0);
        WordIdealTest.assertTrue((String)"isGB( J )", (boolean)wordIdeal2.isGB());
        WordIdeal<BigRational> wordIdeal3 = wordIdeal.product(wordIdeal2);
        WordIdeal<BigRational> wordIdeal4 = wordIdeal2.product(wordIdeal);
        WordIdeal<BigRational> wordIdeal5 = wordIdeal3.sum(wordIdeal4);
        WordIdealTest.assertTrue((String)"isGB( K )", (boolean)wordIdeal3.isGB());
        WordIdealTest.assertTrue((String)"isGB( H )", (boolean)wordIdeal4.isGB());
        WordIdealTest.assertTrue((String)"isGB( G )", (boolean)wordIdeal5.isGB());
        WordIdealTest.assertTrue((String)"J contains(K)", (boolean)wordIdeal2.contains(wordIdeal3));
    }

    public void testWordIdealCommonZeros() {
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        WordIdeal<BigRational> wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenWordPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
            WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)0);
        WordIdeal<BigRational> wordIdeal2 = wordIdeal.product(wordIdeal);
        WordIdealTest.assertEquals((String)"commonZeroTest( J )", (int)wordIdeal2.commonZeroTest(), (int)0);
        this.L.remove(0);
        wordIdeal = new WordIdeal<BigRational>(this.fac, this.L, true);
        WordIdealTest.assertEquals((String)"commonZeroTest( I )", (int)wordIdeal.commonZeroTest(), (int)1);
    }
}

