/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Local;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class LocalRing<C extends GcdRingElem<C>>
implements RingFactory<Local<C>>,
QuotPairFactory<GenPolynomial<C>, Local<C>> {
    private static final Logger logger = Logger.getLogger(LocalRing.class);
    protected final GreatestCommonDivisor<C> engine;
    public final Ideal<C> ideal;
    public final GenPolynomialRing<C> ring;
    protected int isField = -1;

    public LocalRing(Ideal<C> ideal) {
        if (ideal == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ideal = ideal.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            this.isField = 0;
            logger.warn((Object)"ideal not maximal");
        }
        this.ring = this.ideal.list.ring;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
    }

    @Override
    public GenPolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Local<C> create(GenPolynomial<C> genPolynomial) {
        return new Local<C>(this, genPolynomial);
    }

    @Override
    public Local<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return new Local<C>(this, genPolynomial, genPolynomial2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.ideal.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public Local<C> copy(Local<C> local) {
        return new Local(local.ring, local.num, local.den, true);
    }

    @Override
    public Local<C> getZERO() {
        return new Local(this, this.ring.getZERO());
    }

    @Override
    public Local<C> getONE() {
        return new Local(this, this.ring.getONE());
    }

    @Override
    public List<Local<C>> generators() {
        List<GenPolynomial<C>> list = this.ring.generators();
        ArrayList<Local<C>> arrayList = new ArrayList<Local<C>>(list.size());
        MonoidElem monoidElem = this.ring.getONE();
        for (GenPolynomial<C> genPolynomial : list) {
            Local<C> local = new Local<C>(this, genPolynomial);
            arrayList.add(local);
            if (genPolynomial.isONE() || this.ideal.contains(genPolynomial)) continue;
            local = new Local<C>(this, monoidElem, genPolynomial);
            arrayList.add(local);
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Local<C> fromInteger(BigInteger bigInteger) {
        return new Local(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public Local<C> fromInteger(long l) {
        return new Local(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "LocalRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "LC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalRing)) {
            return false;
        }
        LocalRing localRing = null;
        try {
            localRing = (LocalRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (localRing == null) {
            return false;
        }
        if (!this.ring.equals(localRing.ring)) {
            return false;
        }
        return this.ideal.equals(localRing.ideal);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public Local<C> random(int n) {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2 = ((GenPolynomial)this.ring.random(n)).monic();
        genPolynomial2 = this.ideal.normalform(genPolynomial2);
        do {
            genPolynomial = ((GenPolynomial)this.ring.random(n)).monic();
        } while ((genPolynomial = this.ideal.normalform(genPolynomial)).isZERO());
        return new Local(this, genPolynomial2, genPolynomial, false);
    }

    public Local<C> random(int n, int n2, int n3, float f) {
        GenPolynomial<C> genPolynomial;
        GenPolynomial<C> genPolynomial2 = this.ring.random(n, n2, n3, f).monic();
        genPolynomial2 = this.ideal.normalform(genPolynomial2);
        do {
            genPolynomial = this.ring.random(n, n2, n3, f).monic();
        } while ((genPolynomial = this.ideal.normalform(genPolynomial)).isZERO());
        return new Local<C>(this, genPolynomial2, genPolynomial, false);
    }

    @Override
    public Local<C> random(int n, Random random) {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2 = ((GenPolynomial)this.ring.random(n, random)).monic();
        genPolynomial2 = this.ideal.normalform(genPolynomial2);
        do {
            genPolynomial = ((GenPolynomial)this.ring.random(n)).monic();
        } while ((genPolynomial = this.ideal.normalform(genPolynomial)).isZERO());
        return new Local(this, genPolynomial2, genPolynomial, false);
    }

    @Override
    public Local<C> parse(String string) {
        int n = string.indexOf("{");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("}")) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("|")) < 0) {
            Element element = this.ring.parse(string);
            return new Local(this, element);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Element element = this.ring.parse(string2);
        Element element2 = this.ring.parse(string3);
        return new Local(this, element, element2);
    }

    @Override
    public Local<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '{', '}');
        return this.parse(string);
    }
}

