/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.root.Interval;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.RealRootsAbstract;
import edu.jas.root.RealRootsSturm;
import edu.jas.structure.Power;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RealRootTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    BigRational eps;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 1;
    int kl = 5;
    int ll = 7;
    int el = 7;
    float q = 0.7f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RealRootTest.suite());
    }

    public RealRootTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RealRootTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, this.to, stringArray);
        this.eps = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.eps = null;
    }

    public void testSturmSequence() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<GenPolynomial<BigRational>> list = realRootsSturm.sturmSequence(this.a);
        try {
            this.b = this.a.remainder(list.get(0));
        }
        catch (Exception exception) {
            RealRootTest.fail((String)("not S(0)|f " + exception));
        }
        RealRootTest.assertTrue((String)"a mod S(0) == 0 ", (boolean)this.b.isZERO());
        RealRootTest.assertTrue((String)"S(-1) == 1 ", (boolean)list.get(list.size() - 1).isConstant());
    }

    public void testRootBound() {
        this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        BigRational bigRational = realRootsSturm.realRootBound(this.a);
        RealRootTest.assertTrue((String)"M >= 1 ", (bigRational.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
        this.a = this.a.monic();
        bigRational = realRootsSturm.realRootBound(this.a);
        RealRootTest.assertTrue((String)"M >= 1 ", (bigRational.compareTo(BigRational.ONE) >= 0 ? 1 : 0) != 0);
    }

    public void testRealRootIsolation() {
        this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 2, this.q);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> list = realRootsSturm.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots >= 0 ", (list.size() >= 0 ? 1 : 0) != 0);
    }

    public void testRealRootIsolationWilkinson() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        for (int i = 0; i < 10; ++i) {
            this.c = this.dfac.fromInteger(i);
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<Interval<Object>> list = realRootsSturm.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 10 ", (list.size() == 10 ? 1 : 0) != 0);
        list = realRootsSturm.refineIntervals(list, this.a, this.eps);
        int n = 0;
        for (Interval<Object> interval : list) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = interval.toDecimal();
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal2.compareTo(bigDecimal = ((Interval)arrayList.get(n++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }

    public void testRealRootIsolationWilkinsonInverse() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(9);
        this.a = this.d;
        for (int i = 1; i < 9; ++i) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        Collections.reverse(arrayList);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<Interval<Object>> list = realRootsSturm.realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 8 ", (list.size() == 8 ? 1 : 0) != 0);
        list = realRootsSturm.refineIntervals(list, this.a, this.eps);
        int n = 0;
        for (Interval<Object> interval : list) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = interval.toDecimal();
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal2.compareTo(bigDecimal = ((Interval)arrayList.get(n++)).toDecimal()) == 0 ? 1 : 0) != 0);
        }
    }

    public void testRealAlgebraicNumberSign() {
        int n;
        this.d = this.dfac.fromInteger(2L);
        this.e = this.dfac.univariate(0);
        this.a = this.e.multiply((BigRational)((Object)this.e));
        this.a = this.a.subtract((BigRational)((Object)this.d));
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        this.ai = new BigRational(1L);
        this.bi = new BigRational(2L);
        Interval<BigRational> interval = new Interval<BigRational>(this.ai, this.bi);
        RealRootTest.assertTrue((String)"sign change", (boolean)realRootsSturm.signChange(interval, this.a));
        this.b = this.dfac.random(this.kl, (int)this.a.degree() + 1, (int)this.a.degree(), 1.0f);
        if (this.b.isZERO()) {
            int n2 = realRootsSturm.realSign(interval, this.a, this.b);
            RealRootTest.assertTrue((String)"algebraic sign", (n2 == 0 ? 1 : 0) != 0);
            return;
        }
        int n3 = realRootsSturm.realSign(interval, this.a, this.b);
        RealRootTest.assertTrue((String)"algebraic sign", (n3 != (n = realRootsSturm.realSign(interval, this.a, (GenPolynomial<BigRational>)this.b.negate())) ? 1 : 0) != 0);
        interval = new Interval<BigRational>(this.bi.negate(), this.ai.negate());
        RealRootTest.assertTrue((String)"sign change", (boolean)realRootsSturm.signChange(interval, this.a));
        int n4 = realRootsSturm.realSign(interval, this.a, this.b);
        int n5 = realRootsSturm.realSign(interval, this.a, (GenPolynomial<BigRational>)this.b.negate());
        RealRootTest.assertTrue((String)"algebraic sign", (n4 != n5 ? 1 : 0) != 0);
        RealRootTest.assertTrue((String)"algebraic sign", (n3 * n4 == n * n5 ? 1 : 0) != 0);
    }

    public void testRealRootIsolationDecimalWilkinson() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        for (int i = 0; i < 10; ++i) {
            this.c = this.dfac.fromInteger(i);
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> list = ((RealRootsAbstract)realRootsSturm).realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 10 ", (list.size() == 10 ? 1 : 0) != 0);
        this.eps = this.eps.multiply(new BigRational(100000L));
        BigDecimal bigDecimal = new BigDecimal(this.eps);
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal("100"));
        try {
            int n = 0;
            for (Interval<BigRational> interval : list) {
                BigDecimal bigDecimal3;
                BigDecimal bigDecimal4 = realRootsSturm.approximateRoot(interval, this.a, this.eps);
                RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal4.subtract(bigDecimal3 = ((Interval)arrayList.get(n++)).toDecimal()).abs().compareTo(bigDecimal2) <= 0 ? 1 : 0) != 0);
            }
        }
        catch (NoConvergenceException noConvergenceException) {
            RealRootTest.fail((String)noConvergenceException.toString());
        }
    }

    public void testRealRootIsolationDecimalWilkinsonInverse() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        for (int i = 1; i < 10; ++i) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        Collections.reverse(arrayList);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        List<Interval<BigRational>> list = ((RealRootsAbstract)realRootsSturm).realRoots(this.a);
        RealRootTest.assertTrue((String)"#roots = 9 ", (list.size() == 9 ? 1 : 0) != 0);
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal bigDecimal = new BigDecimal(this.eps);
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal("10"));
        try {
            int n = 0;
            for (Interval<BigRational> interval : list) {
                BigDecimal bigDecimal3;
                BigDecimal bigDecimal4 = realRootsSturm.approximateRoot(interval, this.a, this.eps);
                RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal4.subtract(bigDecimal3 = ((Interval)arrayList.get(n++)).toDecimal()).abs().compareTo(bigDecimal2) <= 0 ? 1 : 0) != 0);
            }
        }
        catch (NoConvergenceException noConvergenceException) {
            RealRootTest.fail((String)noConvergenceException.toString());
        }
    }

    public void testRealRootIsolationDecimalWilkinsonAll() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        for (int i = 0; i < 10; ++i) {
            this.c = this.dfac.fromInteger(i);
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        this.eps = this.eps.multiply(new BigRational(10000L));
        BigDecimal bigDecimal = new BigDecimal(this.eps);
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal("100"));
        List<BigDecimal> list = null;
        list = realRootsSturm.approximateRoots(this.a, this.eps);
        RealRootTest.assertTrue((String)"#roots = 10 ", (list.size() == 10 ? 1 : 0) != 0);
        int n = 0;
        for (BigDecimal bigDecimal3 : list) {
            BigDecimal bigDecimal4;
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal3.subtract(bigDecimal4 = ((Interval)arrayList.get(n++)).toDecimal()).abs().compareTo(bigDecimal2) <= 0 ? 1 : 0) != 0);
        }
        boolean bl = realRootsSturm.isApproximateRoot(list, this.a, this.eps);
        RealRootTest.assertTrue((String)"some |a(dd)| < eps ", (boolean)bl);
    }

    public void testRealRootIsolationDecimalWilkinsonInverseAll() {
        this.d = this.dfac.getONE();
        this.e = this.dfac.univariate(0);
        ArrayList<Interval<BigRational>> arrayList = new ArrayList<Interval<BigRational>>(10);
        this.a = this.d;
        for (int i = 1; i < 10; ++i) {
            this.c = this.dfac.fromInteger(i);
            if (i != 0) {
                this.c = this.d.divide(this.c);
            }
            arrayList.add(new Interval<BigRational>(this.c.leadingBaseCoefficient()));
            this.b = this.e.subtract((BigRational)((Object)this.c));
            this.a = this.a.multiply((BigRational)((Object)this.b));
        }
        Collections.reverse(arrayList);
        RealRootsSturm<BigRational> realRootsSturm = new RealRootsSturm<BigRational>();
        this.eps = this.eps.multiply(new BigRational(1000000L));
        BigDecimal bigDecimal = new BigDecimal(this.eps);
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal("10"));
        List<BigDecimal> list = null;
        list = realRootsSturm.approximateRoots(this.a, this.eps);
        RealRootTest.assertTrue((String)"#roots = 9 ", (list.size() == 9 ? 1 : 0) != 0);
        int n = 0;
        for (BigDecimal bigDecimal3 : list) {
            BigDecimal bigDecimal4;
            RealRootTest.assertTrue((String)"|dd - di| < eps ", (bigDecimal3.subtract(bigDecimal4 = ((Interval)arrayList.get(n++)).toDecimal()).abs().compareTo(bigDecimal2) <= 0 ? 1 : 0) != 0);
        }
        boolean bl = realRootsSturm.isApproximateRoot(list, this.a, this.eps);
        RealRootTest.assertTrue((String)"some |a(dd)| < eps ", (boolean)bl);
    }
}

