/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Serializable;

public class Rectangle<C extends RingElem<C> & Rational>
implements Serializable {
    public final Complex<C>[] corners;

    Rectangle(Complex<C>[] complexArray) {
        if (complexArray.length < 5) {
            this.corners = new Complex[5];
            for (int i = 0; i < 4; ++i) {
                this.corners[i] = complexArray[i];
            }
        } else {
            this.corners = complexArray;
        }
        if (this.corners[4] == null) {
            this.corners[4] = this.corners[0];
        }
    }

    public Rectangle(Complex<C> complex) {
        this(complex, complex);
    }

    public Rectangle(Complex<C> complex, Complex<C> complex2) {
        this(new Complex(complex.ring, complex.getRe(), complex2.getIm()), complex, new Complex(complex.ring, complex2.getRe(), complex.getIm()), complex2);
    }

    public Rectangle(Complex<C> complex, Complex<C> complex2, Complex<C> complex3, Complex<C> complex4) {
        this(new Complex[]{complex, complex2, complex3, complex4});
    }

    public String toString() {
        return "[" + this.corners[1] + ", " + this.corners[3] + "]";
    }

    public String toScript() {
        return "(" + this.corners[1].toScript() + ", " + this.corners[3].toScript() + ")";
    }

    public Complex<C> getNW() {
        return this.corners[0];
    }

    public Complex<C> getSW() {
        return this.corners[1];
    }

    public Complex<C> getSE() {
        return this.corners[2];
    }

    public Complex<C> getNE() {
        return this.corners[3];
    }

    public Rectangle<C> exchangeNW(Complex<C> complex) {
        Complex<C> complex2 = this.getSE();
        Complex<C> complex3 = new Complex<C>(complex.factory(), complex.getRe(), complex2.getIm());
        Complex<C> complex4 = new Complex<C>(complex.factory(), complex2.getRe(), complex.getIm());
        return new Rectangle<C>(complex, complex3, complex2, complex4);
    }

    public Rectangle<C> exchangeSW(Complex<C> complex) {
        Complex<C> complex2 = this.getNE();
        Complex<C> complex3 = new Complex<C>(complex.factory(), complex.getRe(), complex2.getIm());
        Complex<C> complex4 = new Complex<C>(complex.factory(), complex2.getRe(), complex.getIm());
        return new Rectangle<C>(complex3, complex, complex4, complex2);
    }

    public Rectangle<C> exchangeSE(Complex<C> complex) {
        Complex<C> complex2 = this.getNW();
        Complex<C> complex3 = new Complex<C>(complex.factory(), complex2.getRe(), complex.getIm());
        Complex<C> complex4 = new Complex<C>(complex.factory(), complex.getRe(), complex2.getIm());
        return new Rectangle<C>(complex2, complex3, complex, complex4);
    }

    public Rectangle<C> exchangeNE(Complex<C> complex) {
        Complex<C> complex2 = this.getSW();
        Complex<C> complex3 = new Complex<C>(complex.factory(), complex2.getRe(), complex.getIm());
        Complex<C> complex4 = new Complex<C>(complex.factory(), complex.getRe(), complex2.getIm());
        return new Rectangle<C>(complex3, complex2, complex4, complex);
    }

    public boolean contains(Complex<C> complex) {
        Complex<C> complex2 = this.getSW();
        Complex<C> complex3 = this.getNE();
        C c = complex.getRe();
        C c2 = complex.getIm();
        return c.compareTo(complex2.getRe()) >= 0 && c2.compareTo(complex2.getIm()) >= 0 && c.compareTo(complex3.getRe()) <= 0 && c2.compareTo(complex3.getIm()) <= 0;
    }

    public boolean contains(Rectangle<C> rectangle) {
        return this.contains(rectangle.getSW()) && this.contains(rectangle.getNE());
    }

    public Complex<C> randomPoint() {
        Complex<RingElem> complex = this.getSW();
        Complex<C> complex2 = this.getSE();
        Complex<C> complex3 = this.getNW();
        Element element = ((ComplexRing)complex.factory()).random(13);
        RingElem ringElem = (RingElem)complex2.getRe().subtract(complex.getRe());
        RingElem ringElem2 = (RingElem)complex3.getIm().subtract(complex.getIm());
        RingElem ringElem3 = (RingElem)((Complex)element).getRe().abs();
        RingElem ringElem4 = (RingElem)((Complex)element).getIm().abs();
        RingElem ringElem5 = (RingElem)((RingFactory)ringElem.factory()).getONE();
        if (!ringElem3.isZERO() && ringElem3.compareTo(ringElem5) > 0) {
            ringElem3 = (RingElem)ringElem3.inverse();
        }
        if (!ringElem4.isZERO() && ringElem4.compareTo(ringElem5) > 0) {
            ringElem4 = (RingElem)ringElem4.inverse();
        }
        ringElem3 = ringElem3.multiply(ringElem);
        ringElem4 = ringElem4.multiply(ringElem2);
        Complex<RingElem> complex4 = new Complex<RingElem>((ComplexRing<RingElem>)complex.factory(), ringElem3, ringElem4);
        complex4 = complex.sum(complex4);
        return complex4;
    }

    public Rectangle<C> copy() {
        return new Rectangle<C>(this.corners);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = null;
        try {
            rectangle = (Rectangle)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i].equals(rectangle.corners[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n += 37 * this.corners[i].hashCode();
        }
        return 37 * n + this.corners[3].hashCode();
    }

    public Complex<C> getCenter() {
        RingElem ringElem = (RingElem)this.corners[2].getRe().subtract(this.corners[1].getRe());
        RingElem ringElem2 = (RingElem)this.corners[0].getIm().subtract(this.corners[1].getIm());
        ElemFactory elemFactory = ringElem.factory();
        RingElem ringElem3 = (RingElem)elemFactory.fromInteger(2L);
        ringElem = ringElem.divide(ringElem3);
        ringElem2 = ringElem2.divide(ringElem3);
        ringElem = this.corners[1].getRe().sum((RingElem)ringElem);
        ringElem2 = this.corners[1].getIm().sum((RingElem)ringElem2);
        return new Complex<RingElem>((ComplexRing<RingElem>)this.corners[0].factory(), ringElem, ringElem2);
    }

    public Complex<BigRational> getRationalCenter() {
        Complex<C> complex = this.getCenter();
        BigRational bigRational = ((Rational)complex.getRe()).getRational();
        BigRational bigRational2 = ((Rational)complex.getIm()).getRational();
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(bigRational.factory());
        Complex<BigRational> complex2 = new Complex<BigRational>(complexRing, bigRational, bigRational2);
        return complex2;
    }

    public Complex<BigDecimal> getDecimalCenter() {
        Complex<BigRational> complex = this.getRationalCenter();
        BigDecimal bigDecimal = new BigDecimal(complex.getRe());
        BigDecimal bigDecimal2 = new BigDecimal(complex.getIm());
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal.factory());
        Complex<BigDecimal> complex2 = new Complex<BigDecimal>(complexRing, bigDecimal, bigDecimal2);
        return complex2;
    }

    public String centerApprox() {
        Complex<BigDecimal> complex = this.getDecimalCenter();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append(complex.getRe().toString());
        stringBuffer.append(" i ");
        stringBuffer.append(complex.getIm().toString());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public C length() {
        Complex<C> complex = this.corners[3].subtract(this.corners[1]);
        return ((Complex)complex.norm()).getRe();
    }

    public BigRational rationalLength() {
        return ((Rational)this.length()).getRational();
    }

    public C lengthReal() {
        RingElem ringElem = (RingElem)this.corners[3].getRe().subtract(this.corners[1].getRe());
        return (C)((RingElem)ringElem.abs());
    }

    public C lengthImag() {
        RingElem ringElem = (RingElem)this.corners[3].getIm().subtract(this.corners[1].getIm());
        return (C)((RingElem)ringElem.abs());
    }
}

