/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.PrimeList;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDModLongTest
extends TestCase {
    GreatestCommonDivisorAbstract<ModLong> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<ModLong> dfac;
    GenPolynomialRing<ModLong> cfac;
    GenPolynomialRing<GenPolynomial<ModLong>> rfac;
    PrimeList primes = new PrimeList();
    ModLongRing mi;
    ModLong ai;
    ModLong bi;
    ModLong ci;
    ModLong di;
    ModLong ei;
    GenPolynomial<ModLong> a;
    GenPolynomial<ModLong> b;
    GenPolynomial<ModLong> c;
    GenPolynomial<ModLong> d;
    GenPolynomial<ModLong> e;
    GenPolynomial<ModLong> ac;
    GenPolynomial<ModLong> bc;
    GenPolynomial<GenPolynomial<ModLong>> ar;
    GenPolynomial<GenPolynomial<ModLong>> br;
    GenPolynomial<GenPolynomial<ModLong>> cr;
    GenPolynomial<GenPolynomial<ModLong>> dr;
    GenPolynomial<GenPolynomial<ModLong>> er;
    GenPolynomial<GenPolynomial<ModLong>> arc;
    GenPolynomial<GenPolynomial<ModLong>> brc;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDModLongTest.suite());
    }

    public GCDModLongTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDModLongTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new ModLongRing(5L, true);
        this.ufd = new GreatestCommonDivisorPrimitive<ModLong>();
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, this.rl, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testModularEvaluationGcd() {
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        for (int i = 0; i < 2; ++i) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            abelianGroupElem = abelianGroupElem.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomialRing.univariate(0)))));
            if (genPolynomial.isZERO() || genPolynomial2.isZERO() || abelianGroupElem.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (abelianGroupElem.length() > 0 ? 1 : 0) != 0);
            genPolynomial = genPolynomial.multiply((BigInteger)abelianGroupElem);
            genPolynomial2 = genPolynomial2.multiply((BigInteger)abelianGroupElem);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).gcd(genPolynomial, genPolynomial2);
            abelianGroupElem = greatestCommonDivisorPrimitive.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)abelianGroupElem).abs();
            GenPolynomial<BigInteger> genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial3, abelianGroupElem);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial, genPolynomial3);
            GCDModLongTest.assertTrue((String)("gcd(a,b) | a" + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial2, genPolynomial3);
            GCDModLongTest.assertTrue((String)("gcd(a,b) | b" + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
    }

    public void testModularSimpleGcd() {
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular(true);
        GreatestCommonDivisorPrimitive<RingElem<BigInteger>> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<RingElem<BigInteger>>();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(), 3, this.to);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<RingElem<BigInteger>> genPolynomial = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigInteger>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            AbelianGroupElem<GenPolynomial<Object>> abelianGroupElem = genPolynomialRing.random(this.kl, this.ll + i, this.el + i, this.q);
            abelianGroupElem = abelianGroupElem.multiply((GenPolynomial<Object>)((Object)((BigInteger)((Object)genPolynomialRing.univariate(0)))));
            if (genPolynomial.isZERO() || genPolynomial2.isZERO() || abelianGroupElem.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (abelianGroupElem.length() > 0 ? 1 : 0) != 0);
            genPolynomial = genPolynomial.multiply((BigInteger)abelianGroupElem);
            genPolynomial2 = genPolynomial2.multiply((BigInteger)abelianGroupElem);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).gcd(genPolynomial, genPolynomial2);
            abelianGroupElem = greatestCommonDivisorPrimitive.basePrimitivePart((GenPolynomial<RingElem<BigInteger>>)abelianGroupElem).abs();
            GenPolynomial<BigInteger> genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial3, abelianGroupElem);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial, genPolynomial3);
            GCDModLongTest.assertTrue((String)("gcd(a,b) | a" + genPolynomial4), (boolean)genPolynomial4.isZERO());
            genPolynomial4 = PolyUtil.basePseudoRemainder(genPolynomial2, genPolynomial3);
            GCDModLongTest.assertTrue((String)("gcd(a,b) | b" + genPolynomial4), (boolean)genPolynomial4.isZERO());
        }
    }

    public void testRecursiveContentPPmodular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive();
        for (int i = 0; i < 1; ++i) {
            this.a = this.cfac.random(this.kl, this.ll + 2 * i, this.el + i, this.q).monic();
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.cr = PolyUtil.monic(this.cr);
            this.cr = this.cr.multiply(this.a);
            if (this.cr.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.c = greatestCommonDivisorPrimitive.recursiveContent(this.cr).monic();
            this.dr = greatestCommonDivisorPrimitive.recursivePrimitivePart(this.cr);
            this.dr = PolyUtil.monic(this.dr);
            this.ar = this.dr.multiply(this.c);
            GCDModLongTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
        }
    }

    public void testGCDbaseModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        GreatestCommonDivisorPrimitive<ModLong> greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive<ModLong>();
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + 3 + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.ac = this.a.multiply((ModLong)((Object)this.c));
            this.bc = this.b.multiply((ModLong)((Object)this.c));
            this.d = ((GreatestCommonDivisorAbstract)greatestCommonDivisorPrimitive).baseGcd(this.ac, this.bc);
            this.d = this.d.monic();
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.arc = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
            this.brc = this.br.multiply((GenPolynomial<ModLong>)this.cr);
            this.dr = this.ufd.recursiveUnivariateGcd(this.arc, this.brc);
            this.dr = PolyUtil.monic(this.dr);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testArbitraryRecursiveGCDModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<ModLong>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to);
        for (int i = 0; i < 1; ++i) {
            this.ar = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.br = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.cr = this.rfac.random(this.kl, 2, this.el + 2, this.q);
            this.ar = PolyUtil.monic(this.ar);
            this.br = PolyUtil.monic(this.br);
            this.cr = PolyUtil.monic(this.cr);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.arc = this.ar.multiply((GenPolynomial<ModLong>)this.cr);
            this.brc = this.br.multiply((GenPolynomial<ModLong>)this.cr);
            this.dr = this.ufd.recursiveGcd(this.arc, this.brc);
            this.dr = PolyUtil.monic(this.dr);
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testGcdModular() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 4, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.b = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            this.c = this.dfac.random(this.kl, this.ll, this.el + i, this.q).monic();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDModLongTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.ac = this.a.multiply((ModLong)((Object)this.c));
            this.bc = this.b.multiply((ModLong)((Object)this.c));
            this.d = this.ufd.gcd(this.ac, this.bc);
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDModLongTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.ac, this.d);
            GCDModLongTest.assertTrue((String)("gcd(ac,bc) | ac " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.basePseudoRemainder(this.bc, this.d);
            GCDModLongTest.assertTrue((String)("gcd(ac,bc) | bc " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<ModLong>(this.mi, 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDModLongTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        ArrayList arrayList = new ArrayList(5);
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        arrayList.add(this.d);
        arrayList.add(this.e);
        List<GenPolynomial<Object>> list = this.ufd.coPrime(arrayList);
        GCDModLongTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDModLongTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
        list = this.ufd.coPrimeRec(arrayList);
        GCDModLongTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDModLongTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
    }
}

