/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.QuotientRing;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorGenericTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorGenericTest.suite());
    }

    public FactorGenericTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorGenericTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void xtestDummy() {
    }

    public void testGenericFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"w2"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        Element element = genPolynomialRing.parse(" w2^2 - 2 ");
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(element, true);
        String[] stringArray2 = new String[]{"x"};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, 1, termOrder, stringArray2);
        QuotientRing quotientRing = new QuotientRing(genPolynomialRing2);
        String[] stringArray3 = new String[]{"wx"};
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(quotientRing, 1, termOrder, stringArray3);
        Element element2 = genPolynomialRing3.parse(" wx^2 - { x } ");
        AlgebraicNumberRing algebraicNumberRing2 = new AlgebraicNumberRing(element2, true);
        String[] stringArray4 = new String[]{"y"};
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(algebraicNumberRing2, 1, termOrder, stringArray4);
        Element element3 = genPolynomialRing4.parse(" ( y^2 - { { x } } ) * ( y^2 - 2 )^2 ");
        FactorAbstract factorAbstract = FactorFactory.getImplementation(algebraicNumberRing2);
        SortedMap sortedMap = factorAbstract.factors(element3);
        FactorGenericTest.assertTrue((String)"#facs >= 4", (sortedMap.size() >= 4 ? 1 : 0) != 0);
        boolean bl = factorAbstract.isFactorization(element3, sortedMap);
        FactorGenericTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }
}

