/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Residue;
import edu.jas.poly.ResidueRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ResidueTest
extends TestCase {
    ResidueRing<BigInteger> fac;
    GenPolynomialRing<BigRational> pfac;
    ResidueRing<GenPolynomial<BigRational>> mfac;
    Residue<BigInteger> a;
    Residue<BigInteger> b;
    Residue<BigInteger> c;
    Residue<BigInteger> d;
    Residue<BigInteger> e;
    Residue<GenPolynomial<BigRational>> ap;
    Residue<GenPolynomial<BigRational>> bp;
    Residue<GenPolynomial<BigRational>> cp;
    Residue<GenPolynomial<BigRational>> dp;
    Residue<GenPolynomial<BigRational>> ep;
    int rl = 1;
    int kl = 13;
    int ll = 7;
    int el = 3;
    float q = 0.4f;
    int il = 2;
    long p = 0xFFFFFFFFFFFFFA3L;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ResidueTest.suite());
    }

    public ResidueTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ResidueTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        BigInteger bigInteger = new BigInteger(1L);
        this.fac = new ResidueRing<BigInteger>(bigInteger, new BigInteger(this.p));
        this.pfac = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        GenPolynomial<BigRational> genPolynomial = this.pfac.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isConstant()) {
            genPolynomial = this.pfac.random(this.kl, this.ll, this.el, this.q);
        }
        this.mfac = new ResidueRing<GenPolynomial<BigRational>>(this.pfac, genPolynomial);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.fac = null;
        this.pfac = null;
        this.mfac = null;
    }

    public void testIntConstruction() {
        this.c = this.fac.getONE();
        ResidueTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ResidueTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ResidueTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testPolyConstruction() {
        this.cp = this.mfac.getONE();
        ResidueTest.assertTrue((String)"isZERO( cp )", (!this.cp.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"isONE( cp )", (boolean)this.cp.isONE());
        this.dp = this.mfac.getZERO();
        ResidueTest.assertTrue((String)"isZERO( dp )", (boolean)this.dp.isZERO());
        ResidueTest.assertTrue((String)"isONE( dp )", (!this.dp.isONE() ? 1 : 0) != 0);
    }

    public void testIntRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1));
            if (this.a.isZERO()) continue;
            ResidueTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ResidueTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testPolyRandom() {
        for (int i = 0; i < 7; ++i) {
            this.ap = this.mfac.random(this.kl + i);
            if (this.ap.isZERO()) continue;
            ResidueTest.assertTrue((String)(" not isZERO( ap" + i + " )"), (!this.ap.isZERO() ? 1 : 0) != 0);
            ResidueTest.assertTrue((String)(" not isONE( ap" + i + " )"), (!this.ap.isONE() ? 1 : 0) != 0);
        }
    }

    public void testIntAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        ResidueTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ResidueTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        ResidueTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Residue<BigInteger>)this.fac.getZERO());
        this.d = this.a.subtract((Residue<BigInteger>)this.fac.getZERO());
        ResidueTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Residue)this.fac.getZERO()).sum(this.a);
        this.d = ((Residue)this.fac.getZERO()).subtract(this.a.negate());
        ResidueTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testPolyAddition() {
        this.ap = this.mfac.random(this.kl);
        this.bp = this.mfac.random(this.kl);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.cp.subtract(this.bp);
        ResidueTest.assertEquals((String)"a+b-b = a", this.ap, this.dp);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.bp.sum(this.ap);
        ResidueTest.assertEquals((String)"a+b = b+a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.cp.sum(this.ap.sum(this.bp));
        this.ep = this.cp.sum(this.ap).sum(this.bp);
        ResidueTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dp, this.ep);
        this.cp = this.ap.sum((Residue<GenPolynomial<BigRational>>)this.mfac.getZERO());
        this.dp = this.ap.subtract((Residue<GenPolynomial<BigRational>>)this.mfac.getZERO());
        ResidueTest.assertEquals((String)"a+0 = a-0", this.cp, this.dp);
        this.cp = ((Residue)this.mfac.getZERO()).sum(this.ap);
        this.dp = ((Residue)this.mfac.getZERO()).subtract(this.ap.negate());
        ResidueTest.assertEquals((String)"0+a = 0+(-a)", this.cp, this.dp);
    }

    public void testIntMultiplication() {
        this.a = this.fac.random(this.kl);
        if (this.a.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        if (this.b.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        ResidueTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        ResidueTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ResidueTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ResidueTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        ResidueTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ResidueTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Residue<BigInteger>)this.fac.getONE());
        this.d = ((Residue)this.fac.getONE()).multiply(this.a);
        ResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            ResidueTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testPolyMultiplication() {
        this.ap = this.mfac.random(this.kl);
        if (this.ap.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( a )", (!this.ap.isZERO() ? 1 : 0) != 0);
        this.bp = this.mfac.random(this.kl);
        if (this.bp.isZERO()) {
            return;
        }
        ResidueTest.assertTrue((String)"not isZERO( b )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.bp.multiply(this.ap);
        this.dp = this.ap.multiply(this.bp);
        ResidueTest.assertTrue((String)"not isZERO( c )", (!this.cp.isZERO() ? 1 : 0) != 0);
        ResidueTest.assertTrue((String)"not isZERO( d )", (!this.dp.isZERO() ? 1 : 0) != 0);
        this.ep = this.dp.subtract(this.cp);
        ResidueTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ep), (boolean)this.ep.isZERO());
        ResidueTest.assertTrue((String)"a*b = b*a", (boolean)this.cp.equals(this.dp));
        ResidueTest.assertEquals((String)"a*b = b*a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.ap.multiply(this.bp.multiply(this.cp));
        this.ep = this.ap.multiply(this.bp).multiply(this.cp);
        ResidueTest.assertEquals((String)"a(bc) = (ab)c", this.dp, this.ep);
        ResidueTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.dp.equals(this.ep));
        this.cp = this.ap.multiply((Residue<GenPolynomial<BigRational>>)this.mfac.getONE());
        this.dp = ((Residue)this.mfac.getONE()).multiply(this.ap);
        ResidueTest.assertEquals((String)"a*1 = 1*a", this.cp, this.dp);
        if (this.ap.isUnit()) {
            this.cp = this.ap.inverse();
            this.dp = this.cp.multiply(this.ap);
            ResidueTest.assertTrue((String)"a*1/a = 1", (boolean)this.dp.isONE());
        }
    }
}

