/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbufd.GroebnerBaseFGLM;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseFGLMTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<GenPolynomial<BigRational>> Gs;
    GroebnerBase<BigRational> bb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseFGLMTest.suite());
    }

    public GroebnerBaseFGLMTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseFGLMTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, new TermOrder(2));
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseFGLM<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testTrinks7GBase() {
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        String string2 = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseFGLMTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseFGLMTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        this.Gs = groebnerBaseSeq.GB(this.F.list);
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, this.Gs);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gs));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gs.size());
        GroebnerBaseFGLMTest.assertEquals((String)"GB == FGLM", polynomialList, polynomialList2);
    }

    public void testTrinks6GBase() {
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseFGLMTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseFGLMTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        this.Gs = groebnerBaseSeq.GB(this.F.list);
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, this.Gs);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gs));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gs.size());
        GroebnerBaseFGLMTest.assertEquals((String)"GB == FGLM", polynomialList, polynomialList2);
    }

    public void testTrinks7GBaseSqrt() {
        Comparable comparable2;
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        GroebnerBaseFGLM groebnerBaseFGLM = new GroebnerBaseFGLM();
        String string = "AN[ (w2) (w2^2 - 2) ] (B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseFGLMTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseFGLMTest.fail((String)("" + iOException));
        }
        GenPolynomialRing genPolynomialRing = polynomialList.ring;
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        algebraicNumberRing = new AlgebraicNumberRing(algebraicNumberRing.modul, true);
        genPolynomialRing = new GenPolynomialRing(algebraicNumberRing, genPolynomialRing);
        ArrayList arrayList = new ArrayList(polynomialList.list.size());
        for (Comparable comparable2 : polynomialList.list) {
            GenPolynomial genPolynomial = genPolynomialRing.copy(comparable2);
            arrayList.add(genPolynomial);
        }
        polynomialList = new PolynomialList(genPolynomialRing, arrayList);
        List list = groebnerBaseFGLM.GB(polynomialList.list);
        PolynomialList polynomialList2 = new PolynomialList(polynomialList.ring, list);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseFGLM.isGB(list));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)list.size());
        List list2 = groebnerBaseSeq.GB(polynomialList.list);
        comparable2 = new PolynomialList(polynomialList.ring, list2);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseFGLM.isGB(list2));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)list2.size());
        GroebnerBaseFGLMTest.assertEquals((String)"GB == FGLM", (Object)polynomialList2, comparable2);
    }

    public void testTrinks7GBaseCompl() {
        GroebnerBaseSeq groebnerBaseSeq = new GroebnerBaseSeq(new ReductionSeq(), new OrderedSyzPairlist());
        GroebnerBaseFGLM groebnerBaseFGLM = new GroebnerBaseFGLM();
        String string = "Complex (B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseFGLMTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseFGLMTest.fail((String)("" + iOException));
        }
        List list = groebnerBaseFGLM.GB(polynomialList.list);
        PolynomialList polynomialList2 = new PolynomialList(polynomialList.ring, list);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseFGLM.isGB(list));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)list.size());
        List list2 = groebnerBaseSeq.GB(polynomialList.list);
        PolynomialList polynomialList3 = new PolynomialList(polynomialList.ring, list2);
        GroebnerBaseFGLMTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)groebnerBaseFGLM.isGB(list2));
        GroebnerBaseFGLMTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)list2.size());
        GroebnerBaseFGLMTest.assertEquals((String)"GB == FGLM", polynomialList2, polynomialList3);
    }
}

