/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigOctonion;
import edu.jas.arith.BigQuaternion;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigOctonionTest
extends TestCase {
    BigOctonion a;
    BigOctonion b;
    BigOctonion c;
    BigOctonion d;
    BigOctonion e;
    BigOctonion fac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigOctonionTest.suite());
    }

    public BigOctonionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigOctonionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new BigOctonion();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstants() {
        this.a = BigOctonion.ZERO;
        this.b = BigOctonion.ONE;
        this.c = this.b.subtract(this.b);
        BigOctonionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigOctonionTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = BigOctonion.ZERO;
        this.b = BigOctonion.ONE;
        this.c = this.b.subtract(this.b);
        BigOctonionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testConstructor() {
        this.a = new BigOctonion("6/8");
        this.b = new BigOctonion("3/4");
        BigOctonionTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigOctonion("3/4 i 4/5 j 1/5 k 2/5");
        this.b = new BigOctonion("-3/4 i -4/5 j -1/5 k -2/5");
        BigOctonionTest.assertEquals((String)"3/4 + i 4/5 + j 1/5 + k 2/5", (Object)this.a, (Object)this.b.negate());
        String string = "6/1111111111111111111111111111111111111111111";
        this.a = new BigOctonion(string);
        String string2 = this.a.toString();
        BigOctonionTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        String string3 = "3/4 i 4/5 j 1/5 k 2/5";
        String string4 = "-3/4 i -4/5 j -1/5 k -2/5";
        string = string3 + " o " + string4;
        this.a = new BigOctonion(string);
        BigQuaternion bigQuaternion = new BigQuaternion(string3);
        BigQuaternion bigQuaternion2 = new BigQuaternion(string4);
        this.b = new BigOctonion(bigQuaternion, bigQuaternion2);
        BigOctonionTest.assertEquals((String)("s = " + string), (Object)this.a, (Object)this.b);
        this.a = new BigOctonion(1L);
        this.b = new BigOctonion(-1L);
        this.c = this.b.sum(this.a);
        BigOctonionTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigOctonionTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)BigOctonion.ZERO);
    }

    public void testRandom() {
        this.a = this.fac.random(100);
        this.b = new BigOctonion(this.a.getR(), this.a.getI());
        this.c = this.b.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a-b = 0", (Object)BigOctonion.ZERO, (Object)this.c);
        this.d = new BigOctonion(this.b.getR(), this.b.getI());
        BigOctonionTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = this.fac.random(50);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(BigOctonion.ZERO);
        BigOctonionTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(BigOctonion.ZERO);
        BigOctonionTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        BigOctonionTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)BigOctonion.ZERO);
    }

    public void testMultiplication() {
        this.a = this.fac.random(30);
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        BigOctonionTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigOctonionTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(BigOctonion.ONE);
        BigOctonionTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(BigOctonion.ONE);
        BigOctonionTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.fac.random(30);
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        BigOctonionTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        this.b = this.a.abs();
        this.c = this.b.inverse();
        this.d = this.b.multiply(this.c);
        BigOctonionTest.assertTrue((String)"abs(a)*1/abs(a) = 1", (boolean)this.d.isONE());
        this.a = this.fac.random(3);
        this.b = this.a.abs();
        this.c = this.a.conjugate();
        this.d = this.a.multiply(this.c);
        BigOctonionTest.assertEquals((String)"abs(a)^2 = a a^", (Object)this.b, (Object)this.d);
    }

    public void testMultiplicationAxioms() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigOctonionTest.assertTrue((String)"a*b != b*a", (!this.c.equals(this.d) ? 1 : 0) != 0);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        BigOctonionTest.assertTrue((String)"a(bc) != (ab)c", (!this.e.equals(this.d) ? 1 : 0) != 0);
    }

    public void testDistributive() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigOctonionTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }
}

