/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocal;
import edu.jas.application.SolvableLocalRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class LocalSolvablePolynomialQLRTest
extends TestCase {
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> a;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> b;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> c;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> d;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> e;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> f;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> x1;
    QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational> x2;
    int rl = 4;
    int kl = 1;
    int ll = 4;
    int el = 3;
    float q = 0.2f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    QLRSolvablePolynomialRing<SolvableLocal<BigRational>, BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<SolvableLocal<BigRational>> sring;
    GenSolvablePolynomialRing<BigRational> cring;
    SolvableLocalRing<BigRational> qcring;
    SolvableIdeal<BigRational> sideal;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)LocalSolvablePolynomialQLRTest.suite());
    }

    public LocalSolvablePolynomialQLRTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(LocalSolvablePolynomialQLRTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        this.cring.addRelations(weylRelations);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalRing<BigRational>(this.sideal);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.tord, this.vars);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        LocalSolvablePolynomialQLRTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational>(this.ring);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        LocalSolvablePolynomialQLRTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        LocalSolvablePolynomialQLRTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            LocalSolvablePolynomialQLRTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative: ", (boolean)this.ring.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 5; ++i) {
            this.a = this.ring.random(this.kl, this.ll + 2 * i, this.el + i, this.q);
            LocalSolvablePolynomialQLRTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            LocalSolvablePolynomialQLRTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            LocalSolvablePolynomialQLRTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl + 1, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocal<BigRational>)((Object)this.a));
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.a));
        this.c = (QLRSolvablePolynomial)this.b.subtract((SolvableLocal<BigRational>)((Object)this.a));
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableLocal<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.b));
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.c.subtract((SolvableLocal<BigRational>)((Object)this.b));
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.b.sum((SolvableLocal<BigRational>)((Object)this.c))));
        this.e = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.b)).sum(this.c);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        Element element = this.qcring.random(this.kl);
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)element, expVector);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocal<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableLocal<BigRational>)element, expVector);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((QLRSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QLRSolvablePolynomial)this.b.sum((SolvableLocal<BigRational>)((Object)this.a));
        this.d = (QLRSolvablePolynomial)this.a.sum((SolvableLocal<BigRational>)element, expVector);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QLRSolvablePolynomial)this.a.subtract((SolvableLocal<BigRational>)((Object)this.b));
        this.d = (QLRSolvablePolynomial)this.a.subtract((SolvableLocal<BigRational>)element, expVector);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.b = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.b.multiply((SolvableLocal<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b));
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b.multiply((SolvableLocal<BigRational>)((Object)this.c))));
        this.e = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b)).multiply(this.c);
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MonoidElem monoidElem = ((SolvableLocal)this.a.leadingBaseCoefficient()).inverse();
        this.d = this.a.multiply((SolvableLocal<BigRational>)monoidElem);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((SolvableLocal)this.d.leadingBaseCoefficient()).isONE());
        this.d = (QLRSolvablePolynomial)this.a.monic();
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a.monic(): ", (boolean)((SolvableLocal)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testCommutative() {
        LocalSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = this.cring.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(this.cring, arrayList);
        this.qcring = new SolvableLocalRing<BigRational>(this.sideal);
        this.ring = new QLRSolvablePolynomialRing(this.qcring, this.ring);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((SolvableLocal<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b));
        LocalSolvablePolynomialQLRTest.assertEquals((String)"b*a == a*b: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((SolvableLocal<BigRational>)((Object)((QLRSolvablePolynomial)this.b.sum((SolvableLocal<BigRational>)((Object)this.c)))));
        this.e = (QLRSolvablePolynomial)this.a.multiply((SolvableLocal<BigRational>)((Object)this.b)).sum(this.a.multiply((SolvableLocal<BigRational>)((Object)this.c)));
        LocalSolvablePolynomialQLRTest.assertEquals((String)"a*(b+c) = a*b+a*c", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        ArrayList arrayList = new ArrayList();
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b - a^2");
        arrayList.add(genPolynomial);
        this.sideal = new SolvableIdeal<BigRational>(genSolvablePolynomialRing, arrayList);
        SolvableLocalRing<BigRational> solvableLocalRing = new SolvableLocalRing<BigRational>(this.sideal);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isCommutative()", (boolean)solvableLocalRing.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)solvableLocalRing.isAssociative());
        this.ring = new QLRSolvablePolynomialRing(solvableLocalRing, this.ring);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        LocalSolvablePolynomialQLRTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        LocalSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.polCoeff.parse("x");
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.polCoeff.parse("b x + a");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial2.leadingExpVector(), genSolvablePolynomial2);
        LocalSolvablePolynomialQLRTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        LocalSolvablePolynomialQLRTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial3 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial3;
            this.a = new QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial4 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial4;
                this.b = new QLRSolvablePolynomial<SolvableLocal<BigRational>, BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b));
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                LocalSolvablePolynomialQLRTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.parse("x^2 + a b");
        this.b = this.ring.parse("a b + a");
        this.b = (QLRSolvablePolynomial)this.b.inverse();
        this.c = this.b.multiply((SolvableLocal<BigRational>)((Object)this.a));
        this.d = this.a.multiply((SolvableLocal<BigRational>)((Object)this.b));
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = (QLRSolvablePolynomial)this.b.inverse();
        LocalSolvablePolynomialQLRTest.assertTrue((String)"b*b^-1 == 1", (boolean)this.e.multiply((SolvableLocal<BigRational>)((Object)this.b)).isONE());
        this.c = this.e.multiply((SolvableLocal<BigRational>)((Object)this.c));
        this.d = this.d.multiply((SolvableLocal<BigRational>)((Object)this.e));
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a == b * 1/b * a", (boolean)this.a.equals(this.c));
        LocalSolvablePolynomialQLRTest.assertTrue((String)"a == a * 1/b * b", (boolean)this.a.equals(this.d));
    }
}

