/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GaloisFieldTest
extends TestCase {
    AlgebraicNumberRing<ModInteger> fac;
    GenPolynomialRing<ModInteger> mfac;
    AlgebraicNumber<ModInteger> a;
    AlgebraicNumber<ModInteger> b;
    AlgebraicNumber<ModInteger> c;
    AlgebraicNumber<ModInteger> d;
    AlgebraicNumber<ModInteger> e;
    int rl = 1;
    int kl = 10;
    int ll;
    int el = this.ll = 15;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GaloisFieldTest.suite());
    }

    public GaloisFieldTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GaloisFieldTest.class);
        return testSuite;
    }

    protected long getPrime() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return l -= 93L;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        long l = this.getPrime();
        this.mfac = new GenPolynomialRing<ModInteger>(new ModIntegerRing(l), 1);
        GenPolynomial<ModInteger> genPolynomial = this.mfac.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isConstant()) {
            genPolynomial = this.mfac.random(this.kl, this.ll, this.el, this.q);
        }
        this.fac = new AlgebraicNumberRing<ModInteger>(genPolynomial);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        GaloisFieldTest.assertTrue((String)"length( c ) = 1", (this.c.getVal().length() == 1 ? 1 : 0) != 0);
        GaloisFieldTest.assertTrue((String)"isZERO( c )", (!this.c.getVal().isZERO() ? 1 : 0) != 0);
        GaloisFieldTest.assertTrue((String)"isONE( c )", (boolean)this.c.getVal().isONE());
        this.d = this.fac.getZERO();
        GaloisFieldTest.assertTrue((String)"length( d ) = 0", (this.d.getVal().length() == 0 ? 1 : 0) != 0);
        GaloisFieldTest.assertTrue((String)"isZERO( d )", (boolean)this.d.getVal().isZERO());
        GaloisFieldTest.assertTrue((String)"isONE( d )", (!this.d.getVal().isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.ll + i);
            GaloisFieldTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.getVal().length() >= 0 ? 1 : 0) != 0);
            GaloisFieldTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.getVal().isZERO() ? 1 : 0) != 0);
            GaloisFieldTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.getVal().isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((ModInteger)((Object)this.b));
        this.d = this.c.subtract(this.b);
        GaloisFieldTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((ModInteger)((Object)this.a.sum((ModInteger)((Object)this.b))));
        this.e = this.c.sum((ModInteger)((Object)this.a)).sum(this.b);
        GaloisFieldTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((ModInteger)this.fac.getZERO());
        this.d = this.a.subtract((AlgebraicNumber<ModInteger>)this.fac.getZERO());
        GaloisFieldTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((AlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((AlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        GaloisFieldTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        GaloisFieldTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        GaloisFieldTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((ModInteger)((Object)this.a));
        this.d = this.a.multiply((ModInteger)((Object)this.b));
        GaloisFieldTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        GaloisFieldTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        GaloisFieldTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        GaloisFieldTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        GaloisFieldTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((ModInteger)((Object)this.b.multiply((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        GaloisFieldTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        GaloisFieldTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((ModInteger)this.fac.getONE());
        this.d = ((AlgebraicNumber)this.fac.getONE()).multiply(this.a);
        GaloisFieldTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply((ModInteger)((Object)this.a));
        GaloisFieldTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((ModInteger)((Object)this.b.sum((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).sum((AlgebraicNumber<ModInteger>)this.a.multiply((ModInteger)((Object)this.c)));
        GaloisFieldTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testChineseRemainder() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 0);
        this.mfac = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial<ModInteger> genPolynomial = ((GenPolynomial)monoidElem).extend(this.mfac, 0, 1L);
        Element<GenPolynomial<Object>> element = this.mfac.fromInteger(2L);
        Element<GenPolynomial<Object>> element2 = this.mfac.fromInteger(5L);
        element = genPolynomial.subtract((ModInteger)element);
        element2 = genPolynomial.subtract((ModInteger)element2);
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial2 = ((GenPolynomial)element).multiply(element2);
        AlgebraicNumberRing<RingElem<ModInteger>> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element, true);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing2 = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element2, true);
        AlgebraicNumberRing<GenPolynomial<ModInteger>> algebraicNumberRing3 = new AlgebraicNumberRing<GenPolynomial<ModInteger>>(genPolynomial2, false);
        this.a = algebraicNumberRing3.random(9);
        this.b = new AlgebraicNumber<ModInteger>(algebraicNumberRing, this.a.getVal());
        this.c = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, this.a.getVal());
        this.d = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, (GenPolynomial<ModInteger>)element);
        this.d = this.d.inverse();
        this.e = algebraicNumberRing3.chineseRemainder(this.b, this.d, this.c);
        GaloisFieldTest.assertEquals((String)"cra(a mod (x-m0),a mod (x-m1)) = a (mod 19)", this.a, this.e);
        modIntegerRing = new ModIntegerRing(this.getPrime());
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 0);
        this.mfac = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        monoidElem = genPolynomialRing.getONE();
        genPolynomial = ((GenPolynomial)monoidElem).extend(this.mfac, 0, 1L);
        element = this.mfac.fromInteger(21L);
        element2 = this.mfac.fromInteger(57L);
        element = genPolynomial.subtract((ModInteger)element);
        element2 = genPolynomial.subtract((ModInteger)element2);
        genPolynomial2 = ((GenPolynomial)element).multiply(element2);
        algebraicNumberRing = new AlgebraicNumberRing<GenPolynomial<Object>>((GenPolynomial<GenPolynomial<Object>>)element, true);
        algebraicNumberRing2 = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element2, true);
        algebraicNumberRing3 = new AlgebraicNumberRing<GenPolynomial<ModInteger>>(genPolynomial2, false);
        for (int i = 0; i < 5; ++i) {
            this.a = algebraicNumberRing3.random(9);
            this.b = new AlgebraicNumber<ModInteger>(algebraicNumberRing, this.a.getVal());
            this.c = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, this.a.getVal());
            this.d = new AlgebraicNumber<GenPolynomial<Object>>((AlgebraicNumberRing<GenPolynomial<Object>>)algebraicNumberRing2, (GenPolynomial<GenPolynomial<Object>>)element);
            this.d = this.d.inverse();
            this.e = algebraicNumberRing3.chineseRemainder(this.b, this.d, this.c);
            GaloisFieldTest.assertEquals((String)"cra(a mod (x-m0),a mod (x-m1)) = a (mod 2^60-93)", this.a, this.e);
        }
    }

    public void testInterpolate() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 0);
        this.mfac = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial<ModInteger> genPolynomial = ((GenPolynomial)monoidElem).extend(this.mfac, 0, 1L);
        Element<GenPolynomial<Object>> element = this.mfac.fromInteger(2L);
        Element<GenPolynomial<Object>> element2 = this.mfac.fromInteger(5L);
        element = genPolynomial.subtract((ModInteger)element);
        element2 = genPolynomial.subtract((ModInteger)element2);
        GenPolynomial<GenPolynomial<ModInteger>> genPolynomial2 = ((GenPolynomial)element).multiply(element2);
        AlgebraicNumberRing<RingElem<ModInteger>> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element, true);
        AlgebraicNumberRing<ModInteger> algebraicNumberRing2 = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element2, true);
        AlgebraicNumberRing<GenPolynomial<ModInteger>> algebraicNumberRing3 = new AlgebraicNumberRing<GenPolynomial<ModInteger>>(genPolynomial2, false);
        this.a = algebraicNumberRing3.random(9);
        this.b = new AlgebraicNumber<ModInteger>(algebraicNumberRing, this.a.getVal());
        this.c = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, this.a.getVal());
        ModInteger modInteger = (ModInteger)algebraicNumberRing2.modul.trailingBaseCoefficient();
        ModInteger modInteger2 = (ModInteger)this.c.val.trailingBaseCoefficient();
        this.d = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, (GenPolynomial<ModInteger>)element);
        this.d = this.d.inverse();
        ModInteger modInteger3 = (ModInteger)this.d.val.leadingBaseCoefficient();
        this.e = algebraicNumberRing3.interpolate(this.b, (GenPolynomial<ModInteger>)((Object)modInteger3), (GenPolynomial<ModInteger>)((Object)modInteger), (GenPolynomial<ModInteger>)((Object)modInteger2));
        GaloisFieldTest.assertEquals((String)"cra(a mod (x-m0),a mod (x-m1)) = a (mod 19)", this.a, this.e);
        modIntegerRing = new ModIntegerRing(this.getPrime());
        genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 0);
        this.mfac = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        monoidElem = genPolynomialRing.getONE();
        genPolynomial = ((GenPolynomial)monoidElem).extend(this.mfac, 0, 1L);
        element = this.mfac.fromInteger(21L);
        element2 = this.mfac.fromInteger(57L);
        element = genPolynomial.subtract((ModInteger)element);
        element2 = genPolynomial.subtract((ModInteger)element2);
        genPolynomial2 = ((GenPolynomial)element).multiply(element2);
        algebraicNumberRing = new AlgebraicNumberRing<GenPolynomial<Object>>((GenPolynomial<GenPolynomial<Object>>)element, true);
        algebraicNumberRing2 = new AlgebraicNumberRing<ModInteger>((GenPolynomial<ModInteger>)element2, true);
        algebraicNumberRing3 = new AlgebraicNumberRing<GenPolynomial<ModInteger>>(genPolynomial2, false);
        for (int i = 0; i < 5; ++i) {
            this.a = algebraicNumberRing3.random(9);
            this.b = new AlgebraicNumber<ModInteger>(algebraicNumberRing, this.a.getVal());
            this.c = new AlgebraicNumber<ModInteger>(algebraicNumberRing2, this.a.getVal());
            modInteger = (ModInteger)algebraicNumberRing2.modul.trailingBaseCoefficient();
            modInteger2 = (ModInteger)this.c.val.trailingBaseCoefficient();
            this.d = new AlgebraicNumber<GenPolynomial<Object>>((AlgebraicNumberRing<GenPolynomial<Object>>)algebraicNumberRing2, (GenPolynomial<GenPolynomial<Object>>)element);
            this.d = this.d.inverse();
            modInteger3 = (ModInteger)this.d.val.leadingBaseCoefficient();
            this.e = algebraicNumberRing3.interpolate(this.b, (GenPolynomial<ModInteger>)((Object)modInteger3), (GenPolynomial<ModInteger>)((Object)modInteger), (GenPolynomial<ModInteger>)((Object)modInteger2));
            GaloisFieldTest.assertEquals((String)"cra(a mod (x-m0),a mod (x-m1)) = a (mod 2^60-93)", this.a, this.e);
        }
    }
}

