/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.FactorFactory;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PrimaryComponent;
import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Reduction;
import edu.jas.gbmod.SyzygySeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBasePartial;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class Ideal<C extends GcdRingElem<C>>
implements Comparable<Ideal<C>>,
Serializable {
    private static final Logger logger = Logger.getLogger(Ideal.class);
    private final boolean debug = logger.isDebugEnabled();
    protected PolynomialList<C> list;
    protected boolean isGB;
    protected boolean testGB;
    protected boolean isTopt;
    protected final GroebnerBaseAbstract<C> bb;
    protected final Reduction<C> red;
    protected final SquarefreeAbstract<C> engine;

    public Ideal(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, new ArrayList<GenPolynomial<C>>());
    }

    public Ideal(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        this(new PolynomialList<C>(genPolynomialRing, list));
    }

    public Ideal(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, boolean bl) {
        this(new PolynomialList<C>(genPolynomialRing, list), bl);
    }

    public Ideal(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, boolean bl, boolean bl2) {
        this(new PolynomialList<C>(genPolynomialRing, list), bl, bl2);
    }

    public Ideal(PolynomialList<C> polynomialList) {
        this(polynomialList, false);
    }

    public Ideal(PolynomialList<C> polynomialList, GroebnerBaseAbstract<C> groebnerBaseAbstract, Reduction<C> reduction) {
        this(polynomialList, false, groebnerBaseAbstract, reduction);
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl) {
        this(polynomialList, bl, GBFactory.getImplementation(polynomialList.ring.coFac));
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl, boolean bl2) {
        this(polynomialList, bl, bl2, GBFactory.getImplementation(polynomialList.ring.coFac));
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl, GroebnerBaseAbstract<C> groebnerBaseAbstract, Reduction<C> reduction) {
        this(polynomialList, bl, false, groebnerBaseAbstract, reduction);
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl, GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        this(polynomialList, bl, false, groebnerBaseAbstract, groebnerBaseAbstract.red);
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        this(polynomialList, bl, bl2, groebnerBaseAbstract, groebnerBaseAbstract.red);
    }

    public Ideal(PolynomialList<C> polynomialList, boolean bl, boolean bl2, GroebnerBaseAbstract<C> groebnerBaseAbstract, Reduction<C> reduction) {
        if (polynomialList == null || polynomialList.list == null) {
            throw new IllegalArgumentException("list and list.list may not be null");
        }
        this.list = polynomialList;
        this.isGB = bl;
        this.isTopt = bl2;
        this.testGB = bl;
        this.bb = groebnerBaseAbstract;
        this.red = reduction;
        this.engine = SquarefreeFactory.getImplementation(polynomialList.ring.coFac);
    }

    public Ideal<C> copy() {
        return new Ideal<C>(this.list.copy(), this.isGB, this.isTopt, this.bb, this.red);
    }

    public List<GenPolynomial<C>> getList() {
        return this.list.list;
    }

    public GenPolynomialRing<C> getRing() {
        return this.list.ring;
    }

    public Ideal<C> getZERO() {
        ArrayList arrayList = new ArrayList(0);
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), arrayList);
        return new Ideal<C>(polynomialList, true, this.isTopt, this.bb, this.red);
    }

    public Ideal<C> getONE() {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(this.list.ring.getONE());
        PolynomialList<C> polynomialList = new PolynomialList<C>(this.getRing(), arrayList);
        return new Ideal<C>(polynomialList, true, this.isTopt, this.bb, this.red);
    }

    public String toString() {
        return this.list.toString();
    }

    public String toScript() {
        return this.list.toScript();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ideal)) {
            logger.warn((Object)"equals no Ideal");
            return false;
        }
        Ideal ideal = null;
        try {
            ideal = (Ideal)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.contains(ideal) && ideal.contains(this);
    }

    @Override
    public int compareTo(Ideal<C> ideal) {
        return this.list.compareTo(ideal.list);
    }

    public int hashCode() {
        int n = this.list.hashCode();
        if (this.isGB) {
            n <<= 1;
        }
        if (this.testGB) {
            ++n;
        }
        return n;
    }

    public boolean isZERO() {
        return this.list.isZERO();
    }

    public boolean isONE() {
        return this.list.isONE();
    }

    public void doToptimize() {
        if (this.isTopt) {
            return;
        }
        this.list = TermOrderOptimization.optimizeTermOrder(this.list);
        this.isTopt = true;
        if (this.isGB) {
            this.isGB = false;
            this.doGB();
        }
    }

    public boolean isGB() {
        if (this.testGB) {
            return this.isGB;
        }
        logger.warn((Object)"isGB computing");
        this.isGB = this.bb.isGB(this.getList());
        this.testGB = true;
        return this.isGB;
    }

    public void doGB() {
        if (this.isGB && this.testGB) {
            return;
        }
        List<GenPolynomial<C>> list = this.getList();
        logger.info((Object)("GB computing = " + list));
        list = this.bb.GB(list);
        if (this.isTopt) {
            List<Integer> list2 = ((OptimizedPolynomialList)this.list).perm;
            this.list = new OptimizedPolynomialList<C>(list2, this.getRing(), list);
        } else {
            this.list = new PolynomialList<C>(this.getRing(), list);
        }
        this.isGB = true;
        this.testGB = true;
    }

    public Ideal<C> GB() {
        if (this.isGB) {
            return this;
        }
        this.doGB();
        return this;
    }

    public boolean contains(Ideal<C> ideal) {
        if (ideal == null || ideal.isZERO()) {
            return true;
        }
        return this.contains(ideal.getList());
    }

    public boolean contains(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (this.isZERO()) {
            return false;
        }
        if (!this.isGB) {
            this.doGB();
        }
        return (genPolynomial2 = this.red.normalform(this.getList(), genPolynomial)) == null || genPolynomial2.isZERO();
    }

    public boolean contains(List<GenPolynomial<C>> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        if (this.isONE()) {
            return true;
        }
        if (!this.isGB) {
            this.doGB();
        }
        for (GenPolynomial<C> genPolynomial : list) {
            GenPolynomial<C> genPolynomial2;
            if (genPolynomial == null || (genPolynomial2 = this.red.normalform(this.getList(), genPolynomial)).isZERO()) continue;
            return false;
        }
        return true;
    }

    public Ideal<C> sum(Ideal<C> ideal) {
        if (ideal == null || ideal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return ideal;
        }
        int n = this.getList().size() + ideal.getList().size();
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(ideal.getList());
        Ideal<C> ideal2 = new Ideal<C>(this.getRing(), arrayList, false);
        if (this.isGB && ideal.isGB) {
            ideal2.doGB();
        }
        return ideal2;
    }

    public Ideal<C> sum(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        int n = this.getList().size() + 1;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.add(genPolynomial);
        Ideal<C> ideal = new Ideal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            ideal.doGB();
        }
        return ideal;
    }

    public Ideal<C> sum(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        int n = this.getList().size() + list.size();
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(n);
        arrayList.addAll(this.getList());
        arrayList.addAll(list);
        Ideal<C> ideal = new Ideal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            ideal.doGB();
        }
        return ideal;
    }

    public Ideal<C> product(Ideal<C> ideal) {
        if (ideal == null || ideal.isZERO()) {
            return ideal;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = this.getList().size() * ideal.getList().size();
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(n);
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : this.getList()) {
            for (GenPolynomial<Object> genPolynomial2 : ideal.getList()) {
                genPolynomial2 = genPolynomial.multiply(genPolynomial2);
                arrayList.add(genPolynomial2);
            }
        }
        Ideal<C> ideal2 = new Ideal<C>(this.getRing(), arrayList, false);
        if (this.isGB && ideal.isGB) {
            ideal2.doGB();
        }
        return ideal2;
    }

    public Ideal<C> product(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.getList().size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial2 : this.getList()) {
            GenPolynomial<GenPolynomial<C>> genPolynomial3 = genPolynomial2.multiply(genPolynomial);
            arrayList.add(genPolynomial3);
        }
        Ideal<C> ideal = new Ideal<C>(this.getRing(), arrayList, false);
        if (this.isGB) {
            ideal.doGB();
        }
        return ideal;
    }

    public Ideal<C> intersect(List<Ideal<C>> list) {
        if (list == null || list.size() == 0) {
            return this.getZERO();
        }
        Ideal<C> ideal = null;
        for (Ideal<C> ideal2 : list) {
            if (ideal == null) {
                ideal = ideal2;
                continue;
            }
            if (ideal.isONE()) {
                return ideal;
            }
            ideal = ideal.intersect(ideal2);
        }
        return ideal;
    }

    public Ideal<C> intersect(Ideal<C> ideal) {
        if (ideal == null || ideal.isZERO()) {
            return ideal;
        }
        if (this.isZERO()) {
            return this;
        }
        List<GenPolynomial<C>> list = PolyGBUtil.intersect(this.getRing(), this.getList(), ideal.getList());
        Ideal<C> ideal2 = new Ideal<C>(this.getRing(), list, true);
        return ideal2;
    }

    public Ideal<C> intersect(GenPolynomialRing<C> genPolynomialRing) {
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        List<GenPolynomial<C>> list = PolyUtil.intersect(genPolynomialRing, this.getList());
        return new Ideal<C>(genPolynomialRing, list, this.isGB, this.isTopt);
    }

    public Ideal<C> eliminate(GenPolynomialRing<C> genPolynomialRing) {
        if (genPolynomialRing == null) {
            throw new IllegalArgumentException("R may not be null");
        }
        if (this.list.ring.equals(genPolynomialRing)) {
            return this;
        }
        String[] stringArray = genPolynomialRing.getVars();
        Ideal<C> ideal = this.eliminate(stringArray);
        return ideal.intersect(genPolynomialRing);
    }

    public Ideal<C> eliminate(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("ename may not be null");
        }
        Object[] objectArray = this.getRing().getVars();
        if (objectArray == null) {
            throw new IllegalArgumentException("aname may not be null");
        }
        GroebnerBasePartial<C> groebnerBasePartial = new GroebnerBasePartial<C>(this.bb, null);
        String[] stringArray2 = GroebnerBasePartial.remainingVars((String[])objectArray, stringArray);
        OptimizedPolynomialList<C> optimizedPolynomialList = null;
        if (stringArray2.length == 0) {
            if (Arrays.equals(objectArray, stringArray)) {
                return this;
            }
            optimizedPolynomialList = groebnerBasePartial.partialGB(this.getList(), stringArray);
        } else {
            optimizedPolynomialList = groebnerBasePartial.elimPartialGB(this.getList(), stringArray2, stringArray);
        }
        if (this.debug) {
            logger.debug((Object)("elimination GB = " + optimizedPolynomialList));
        }
        Ideal<C> ideal = new Ideal<C>(optimizedPolynomialList, true);
        return ideal;
    }

    public Ideal<C> quotient(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(1);
        arrayList.add(genPolynomial);
        Ideal<C> ideal = new Ideal<C>(this.getRing(), arrayList, true);
        Ideal<C> ideal2 = this.intersect(ideal);
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(ideal2.getList().size());
        for (GenPolynomial<C> genPolynomial2 : ideal2.getList()) {
            genPolynomial2 = genPolynomial2.divide(genPolynomial);
            arrayList2.add(genPolynomial2);
        }
        return new Ideal<C>(this.getRing(), arrayList2, true);
    }

    public Ideal<C> quotient(Ideal<C> ideal) {
        if (ideal == null) {
            return this;
        }
        if (ideal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal2 = null;
        for (GenPolynomial<C> genPolynomial : ideal.getList()) {
            Ideal<C> ideal3 = this.quotient(genPolynomial);
            if (ideal2 == null) {
                ideal2 = ideal3;
                continue;
            }
            ideal2 = ideal2.intersect(ideal3);
        }
        return ideal2;
    }

    public Ideal<C> infiniteQuotientRab(GenPolynomial<C> genPolynomial) {
        MonoidElem<GenPolynomial<C>> monoidElem2;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.getONE();
        }
        if (genPolynomial.isONE()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal = this.GB();
        List<GenPolynomial<C>> list = ideal.getList();
        ArrayList arrayList = new ArrayList(list.size() + 1);
        GenPolynomialRing<C> genPolynomialRing = this.getRing().extend(1);
        for (MonoidElem<GenPolynomial<C>> monoidElem2 : list) {
            monoidElem2 = monoidElem2.extend(genPolynomialRing, 0, 0L);
            arrayList.add(monoidElem2);
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.extend(genPolynomialRing, 0, 1L);
        monoidElem2 = genPolynomialRing.getONE();
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = genPolynomial2.subtract((C)monoidElem2);
        arrayList.add(genPolynomial3);
        logger.warn((Object)"infiniteQuotientRab computing GB ");
        List<GenPolynomial<C>> list2 = this.bb.GB(arrayList);
        if (this.debug) {
            logger.info((Object)("infiniteQuotientRab    = " + genPolynomialRing + ", c = " + arrayList));
            logger.info((Object)("infiniteQuotientRab GB = " + list2));
        }
        Ideal<C> ideal2 = new Ideal<C>(genPolynomialRing, list2, true);
        Ideal<C> ideal3 = ideal2.intersect(this.getRing());
        return ideal3;
    }

    public int infiniteQuotientExponent(GenPolynomial<C> genPolynomial, Ideal<C> ideal) {
        int n = 0;
        if (genPolynomial == null) {
            return n;
        }
        if (genPolynomial.isZERO() || genPolynomial.isONE()) {
            return n;
        }
        if (this.isZERO() || this.isONE()) {
            return n;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = this.getRing().getONE();
        for (GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial3 : ideal.getList()) {
            if (this.contains(genPolynomial3)) continue;
            GenPolynomial<MonoidElem> genPolynomial4 = genPolynomial3.multiply(genPolynomial2);
            while (!this.contains(genPolynomial4)) {
                genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial);
                ++n;
                genPolynomial4 = genPolynomial3.multiply(genPolynomial2);
            }
        }
        return n;
    }

    public Ideal<C> infiniteQuotient(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = 0;
        Ideal<C> ideal = this.GB();
        GenPolynomial<C> genPolynomial2 = genPolynomial;
        Ideal<C> ideal2 = ideal;
        boolean bl = false;
        while (!bl) {
            ideal2 = ideal.quotient(genPolynomial2);
            ideal2 = ideal2.GB();
            logger.info((Object)("infiniteQuotient s = " + n));
            bl = ideal2.contains(ideal);
            if (bl) continue;
            ideal = ideal2;
            ++n;
        }
        return ideal2;
    }

    public boolean isRadicalMember(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return true;
        }
        if (genPolynomial.isZERO()) {
            return true;
        }
        if (this.isZERO()) {
            return true;
        }
        Ideal<C> ideal = this.infiniteQuotientRab(genPolynomial);
        if (this.debug) {
            logger.debug((Object)("infiniteQuotientRab = " + ideal));
        }
        return ideal.isONE();
    }

    public Ideal<C> infiniteQuotientOld(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        int n = 0;
        Ideal<C> ideal = this.GB();
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomial;
        boolean bl = false;
        while (!bl) {
            Ideal<C> ideal2 = ideal.quotient(genPolynomial2);
            ideal2 = ideal2.GB();
            logger.debug((Object)("infiniteQuotient s = " + n));
            bl = ideal2.contains(ideal);
            if (bl) continue;
            ideal = ideal2;
            ++n;
            genPolynomial2 = genPolynomial2.multiply((GenPolynomial<C>)genPolynomial);
        }
        return ideal;
    }

    public Ideal<C> infiniteQuotient(Ideal<C> ideal) {
        if (ideal == null) {
            return this;
        }
        if (ideal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal2 = null;
        for (GenPolynomial<C> genPolynomial : ideal.getList()) {
            Ideal<C> ideal3 = this.infiniteQuotient(genPolynomial);
            if (ideal2 == null) {
                ideal2 = ideal3;
                continue;
            }
            ideal2 = ideal2.intersect(ideal3);
        }
        return ideal2;
    }

    public Ideal<C> infiniteQuotientRab(Ideal<C> ideal) {
        if (ideal == null) {
            return this;
        }
        if (ideal.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal2 = null;
        for (GenPolynomial<C> genPolynomial : ideal.getList()) {
            Ideal<C> ideal3 = this.infiniteQuotientRab(genPolynomial);
            if (ideal2 == null) {
                ideal2 = ideal3;
                continue;
            }
            ideal2 = ideal2.intersect(ideal3);
        }
        return ideal2;
    }

    public Ideal<C> power(int n) {
        if (n <= 0) {
            return this.getONE();
        }
        if (this.isZERO() || this.isONE()) {
            return this;
        }
        Ideal<C> ideal = this;
        for (int i = 1; i < n; ++i) {
            ideal = ideal.product(this);
        }
        return ideal;
    }

    public GenPolynomial<C> normalform(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return genPolynomial;
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (this.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial2 = this.red.normalform(this.list.list, genPolynomial);
        return genPolynomial2;
    }

    public List<GenPolynomial<C>> normalform(List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() == 0) {
            return list;
        }
        if (this.isZERO()) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            GenPolynomial<C> genPolynomial2 = this.normalform(genPolynomial);
            if (genPolynomial2 == null || genPolynomial2.isZERO()) continue;
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public Ideal<C> annihilator(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        this.doGB();
        ArrayList arrayList = new ArrayList(1 + this.getList().size());
        arrayList.add(genPolynomial);
        arrayList.addAll(this.getList());
        SyzygySeq syzygySeq = new SyzygySeq(this.getRing().coFac);
        List list = syzygySeq.zeroRelationsArbitrary(arrayList);
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list.size());
        for (List list2 : list) {
            GenPolynomial genPolynomial2;
            if (list2 == null || list2.isEmpty() || (genPolynomial2 = list2.get(0)) == null || genPolynomial2.isZERO()) continue;
            arrayList2.add(genPolynomial2);
        }
        Ideal<C> ideal = new Ideal<C>(this.getRing(), arrayList2);
        return ideal;
    }

    public boolean isAnnihilator(GenPolynomial<C> genPolynomial, Ideal<C> ideal) {
        Ideal<C> ideal2 = ideal.product(genPolynomial);
        return this.contains(ideal2);
    }

    public Ideal<C> annihilator(Ideal<C> ideal) {
        if (ideal == null || ideal.isZERO()) {
            return this.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal2 = null;
        for (GenPolynomial<C> genPolynomial : ideal.getList()) {
            Ideal<C> ideal3 = this.annihilator(genPolynomial);
            if (ideal2 == null) {
                ideal2 = ideal3;
                continue;
            }
            ideal2 = ideal2.intersect(ideal3);
        }
        return ideal2;
    }

    public boolean isAnnihilator(Ideal<C> ideal, Ideal<C> ideal2) {
        Ideal<C> ideal3 = ideal2.product(ideal);
        return this.contains(ideal3);
    }

    /*
     * WARNING - void declaration
     */
    public GenPolynomial<C> inverse(GenPolynomial<C> genPolynomial) {
        void var8_11;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new NotInvertibleException("zero not invertible");
        }
        if (this.isZERO()) {
            throw new NotInvertibleException("zero ideal");
        }
        if (genPolynomial.isUnit()) {
            return genPolynomial.inverse();
        }
        this.doGB();
        ArrayList arrayList = new ArrayList(1 + this.list.list.size());
        arrayList.add(genPolynomial);
        arrayList.addAll(this.list.list);
        ExtendedGB<C> extendedGB = this.bb.extGB(arrayList);
        List list = extendedGB.G;
        GenPolynomial genPolynomial3 = null;
        int n = -1;
        for (GenPolynomial genPolynomial22 : list) {
            ++n;
            if (genPolynomial22 == null || !genPolynomial22.isUnit()) continue;
            genPolynomial3 = genPolynomial22;
            break;
        }
        if (genPolynomial3 == null) {
            throw new NotInvertibleException(" h = " + genPolynomial);
        }
        List list2 = extendedGB.G2F.get(n);
        GenPolynomial genPolynomial2 = (GenPolynomial)list2.get(0);
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new NotInvertibleException(" h = " + genPolynomial);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.red.normalform(this.list.list, genPolynomial4);
        if (!genPolynomial5.isONE()) {
            GcdRingElem gcdRingElem = (GcdRingElem)((Object)genPolynomial5.leadingBaseCoefficient());
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            GenPolynomial<GcdRingElem> genPolynomial6 = genPolynomial2.multiply(gcdRingElem);
        }
        if (this.debug) {
            genPolynomial4 = var8_11.multiply(genPolynomial);
            genPolynomial5 = this.red.normalform(this.list.list, genPolynomial4);
            logger.debug((Object)("inv k = " + genPolynomial5));
            if (!genPolynomial5.isUnit()) {
                throw new NotInvertibleException(" k = " + genPolynomial5);
            }
        }
        return var8_11;
    }

    public boolean isUnit(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return false;
        }
        if (this.isZERO()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(1 + this.list.list.size());
        arrayList.add(genPolynomial);
        arrayList.addAll(this.list.list);
        List<GenPolynomial<C>> list = this.bb.GB(arrayList);
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2 == null || !genPolynomial2.isUnit()) continue;
            return true;
        }
        return false;
    }

    public Ideal<C> squarefree() {
        if (this.isZERO()) {
            return this;
        }
        Ideal<C> ideal = this;
        Ideal<C> ideal2 = null;
        while (true) {
            List<GenPolynomial<C>> list = ideal.getList();
            ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list);
            for (GenPolynomial<C> genPolynomial : list) {
                GenPolynomial<C> genPolynomial2 = this.engine.squarefreePart(genPolynomial);
                arrayList.add(genPolynomial2);
            }
            ideal2 = new Ideal<C>(ideal.getRing(), arrayList, false);
            ideal2.doGB();
            if (ideal.equals(ideal2)) break;
            ideal = ideal2;
        }
        return ideal;
    }

    public int commonZeroTest() {
        if (this.isZERO()) {
            return 1;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return -1;
        }
        return this.bb.commonZeroTest(this.getList());
    }

    public boolean isMaximal() {
        if (this.commonZeroTest() != 0) {
            return false;
        }
        for (Long l : this.univariateDegrees()) {
            if (l <= 1L) continue;
            return false;
        }
        return true;
    }

    public List<Long> univariateDegrees() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.isZERO()) {
            return arrayList;
        }
        if (!this.isGB) {
            this.doGB();
        }
        if (this.isONE()) {
            return arrayList;
        }
        return this.bb.univariateDegrees(this.getList());
    }

    public Dimension dimension() {
        int n = this.commonZeroTest();
        Set<Integer> set = new HashSet<Integer>();
        Set<Set<Integer>> set2 = new HashSet<Set<Integer>>();
        if (n <= 0) {
            return new Dimension(n, set, set2, this.list.ring.getVars());
        }
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.list.ring.nvar; ++i) {
            hashSet.add(i);
        }
        set2 = this.dimension(set, hashSet, set2);
        for (Set<Integer> set3 : set2) {
            int n3 = set3.size();
            if (n3 <= n2) continue;
            n2 = n3;
            set = set3;
        }
        return new Dimension(n2, set, set2, this.list.ring.getVars());
    }

    protected Set<Set<Integer>> dimension(Set<Integer> set, Set<Integer> set2, Set<Set<Integer>> set3) {
        Set<Set<Integer>> set4 = set3;
        HashSet<Integer> hashSet = new HashSet<Integer>(set2);
        for (Integer object : set2) {
            hashSet.remove(object);
            HashSet<Integer> hashSet2 = new HashSet<Integer>(set);
            hashSet2.add(object);
            if (this.containsHT(hashSet2, this.getList())) continue;
            set4 = this.dimension(hashSet2, hashSet, set4);
        }
        boolean bl = false;
        for (Set<Integer> set5 : set4) {
            if (!set5.containsAll(set)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            set4.add(set);
        }
        return set4;
    }

    protected boolean containsHT(Set<Integer> set, List<GenPolynomial<C>> list) {
        HashSet<Integer> hashSet = null;
        for (GenPolynomial<C> genPolynomial : list) {
            int[] nArray;
            ExpVector expVector;
            if (genPolynomial == null || (expVector = genPolynomial.leadingExpVector()) == null || (nArray = expVector.dependencyOnVariables()) == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<Integer>(set.size());
                int n = expVector.length() - 1;
                for (Integer n2 : set) {
                    hashSet.add(n - n2);
                }
            }
            if (!this.contains(nArray, hashSet)) continue;
            return true;
        }
        return false;
    }

    protected boolean contains(int[] nArray, Set<Integer> set) {
        for (int i = 0; i < nArray.length; ++i) {
            if (set.contains(nArray[i])) continue;
            return false;
        }
        return true;
    }

    public List<GenPolynomial<C>> constructUnivariate() {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            GenPolynomial<C> genPolynomial = this.constructUnivariate(i);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    public GenPolynomial<C> constructUnivariate(int n) {
        this.doGB();
        return this.bb.constructUnivariate(n, this.getList());
    }

    public List<IdealWithUniv<C>> zeroDimRadicalDecomposition() {
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return arrayList;
        }
        IdealWithUniv idealWithUniv = new IdealWithUniv(this, new ArrayList());
        arrayList.add(idealWithUniv);
        if (this.isONE()) {
            return arrayList;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("must use prime decomposition for char p and infinite coefficient rings, found " + this.list.ring.coFac.toScript()));
            return this.zeroDimPrimeDecomposition();
        }
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            ArrayList arrayList2 = new ArrayList();
            for (IdealWithUniv idealWithUniv2 : arrayList) {
                ArrayList arrayList3;
                GenPolynomial genPolynomial = idealWithUniv2.ideal.constructUnivariate(i);
                SortedMap<GenPolynomial<C>, Long> sortedMap = this.engine.baseSquarefreeFactors(genPolynomial);
                if (sortedMap == null || sortedMap.size() == 0 || sortedMap.size() == 1 && (Long)sortedMap.get(sortedMap.firstKey()) == 1L) {
                    arrayList3 = new ArrayList();
                    arrayList3.addAll(idealWithUniv2.upolys);
                    arrayList3.add(genPolynomial);
                    IdealWithUniv idealWithUniv3 = new IdealWithUniv(idealWithUniv2.ideal, arrayList3);
                    arrayList2.add(idealWithUniv3);
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("squarefree facs = " + sortedMap));
                }
                arrayList3 = idealWithUniv2.ideal.list.ring;
                int n = ((GenPolynomialRing)((Object)arrayList3)).nvar - 1 - i;
                for (GenPolynomial genPolynomial2 : sortedMap.keySet()) {
                    GenPolynomial genPolynomial3 = genPolynomial2.extendUnivariate(arrayList3, n);
                    Ideal ideal = idealWithUniv2.ideal.sum(genPolynomial3);
                    ArrayList arrayList4 = new ArrayList();
                    arrayList4.addAll(idealWithUniv2.upolys);
                    arrayList4.add(genPolynomial2);
                    IdealWithUniv idealWithUniv4 = new IdealWithUniv(ideal, arrayList4);
                    if (this.debug) {
                        logger.info((Object)("ideal with squarefree facs = " + idealWithUniv4));
                    }
                    arrayList2.add(idealWithUniv4);
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public boolean isZeroDimRadical() {
        if (this.isZERO()) {
            return false;
        }
        if (this.isONE()) {
            return false;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("radical only for char 0 or finite coefficient rings, but found " + this.list.ring.coFac.toScript()));
        }
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            GenPolynomial<C> genPolynomial = this.constructUnivariate(i);
            boolean bl = this.engine.isSquarefree(genPolynomial);
            if (bl) continue;
            System.out.println("not squarefree " + this.engine.squarefreePart(genPolynomial) + ", " + genPolynomial);
            return false;
        }
        return true;
    }

    public List<IdealWithUniv<C>> zeroDimDecomposition() {
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return arrayList;
        }
        IdealWithUniv idealWithUniv = new IdealWithUniv(this, new ArrayList());
        arrayList.add(idealWithUniv);
        if (this.isONE()) {
            return arrayList;
        }
        FactorAbstract factorAbstract = FactorFactory.getImplementation(this.list.ring.coFac);
        for (int i = this.list.ring.nvar - 1; i >= 0; --i) {
            ArrayList arrayList2 = new ArrayList();
            for (IdealWithUniv idealWithUniv2 : arrayList) {
                ArrayList arrayList3;
                GenPolynomial genPolynomial = idealWithUniv2.ideal.constructUnivariate(i);
                SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial);
                if (sortedMap.size() == 0 || sortedMap.size() == 1 && (Long)sortedMap.get(sortedMap.firstKey()) == 1L) {
                    arrayList3 = new ArrayList();
                    arrayList3.addAll(idealWithUniv2.upolys);
                    arrayList3.add(genPolynomial);
                    IdealWithUniv idealWithUniv3 = new IdealWithUniv(idealWithUniv2.ideal, arrayList3);
                    arrayList2.add(idealWithUniv3);
                    continue;
                }
                if (this.debug) {
                    logger.info((Object)("irreducible facs = " + sortedMap));
                }
                arrayList3 = idealWithUniv2.ideal.list.ring;
                int n = ((GenPolynomialRing)((Object)arrayList3)).nvar - 1 - i;
                for (GenPolynomial genPolynomial2 : sortedMap.keySet()) {
                    GenPolynomial genPolynomial3 = genPolynomial2.extendUnivariate(arrayList3, n);
                    Ideal ideal = idealWithUniv2.ideal.sum(genPolynomial3);
                    ArrayList arrayList4 = new ArrayList();
                    arrayList4.addAll(idealWithUniv2.upolys);
                    arrayList4.add(genPolynomial2);
                    IdealWithUniv idealWithUniv4 = new IdealWithUniv(ideal, arrayList4);
                    arrayList2.add(idealWithUniv4);
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public List<IdealWithUniv<C>> zeroDimDecompositionExtension(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        int n;
        GenPolynomial<C> genPolynomial;
        if (list == null || list.size() + 1 != this.list.ring.nvar) {
            throw new IllegalArgumentException("univariate polynomial list not correct " + list);
        }
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return arrayList;
        }
        IdealWithUniv<C> idealWithUniv = new IdealWithUniv<C>(this, list);
        if (this.isONE()) {
            arrayList.add(idealWithUniv);
            return arrayList;
        }
        FactorAbstract<C> factorAbstract = FactorFactory.getImplementation(this.list.ring.coFac);
        SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial = this.constructUnivariate(n = this.list.ring.nvar - 1));
        if (sortedMap.size() == 1 && (Long)sortedMap.get(sortedMap.firstKey()) == 1L) {
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(genPolynomial);
            arrayList2.addAll(list);
            IdealWithUniv idealWithUniv2 = new IdealWithUniv(this, arrayList2, list2);
            arrayList.add(idealWithUniv2);
            return arrayList;
        }
        logger.info((Object)("irreducible facs = " + sortedMap));
        GenPolynomialRing genPolynomialRing = this.list.ring;
        int n2 = genPolynomialRing.nvar - 1 - n;
        for (GenPolynomial genPolynomial2 : sortedMap.keySet()) {
            GenPolynomial genPolynomial3 = genPolynomial2.extendUnivariate(genPolynomialRing, n2);
            Ideal ideal = this.sum(genPolynomial3);
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add(genPolynomial2);
            arrayList3.addAll(list);
            IdealWithUniv idealWithUniv3 = new IdealWithUniv(ideal, arrayList3, list2);
            arrayList.add(idealWithUniv3);
        }
        return arrayList;
    }

    public boolean isZeroDimDecomposition(List<IdealWithUniv<C>> list) {
        if (list == null || list.size() == 0) {
            return this.isZERO();
        }
        GenPolynomialRing genPolynomialRing = this.list.ring;
        int n = genPolynomialRing.nvar;
        int n2 = list.get((int)0).ideal.list.ring.nvar;
        int n3 = n2 - n;
        Ideal<IdealWithUniv<C>> ideal = this;
        if (n3 > 0) {
            Iterator<IdealWithUniv<C>> iterator = genPolynomialRing.extendLower(n3);
            IdealWithUniv<C> idealWithUniv = new ArrayList(this.list.list.size());
            for (GenPolynomial<IdealWithUniv<C>> genPolynomial : this.getList()) {
                GenPolynomial<IdealWithUniv<C>> genPolynomial2 = genPolynomial.extendLower((GenPolynomialRing<IdealWithUniv<C>>)((Object)iterator), 0, 0L);
                idealWithUniv.add((Object)genPolynomial2);
            }
            ideal = new Ideal<IdealWithUniv<C>>(iterator, idealWithUniv, this.isGB, this.isTopt);
        }
        for (IdealWithUniv<C> idealWithUniv : list) {
            boolean bl = idealWithUniv.ideal.contains(ideal);
            if (bl) continue;
            System.out.println("not contained " + this + " in " + idealWithUniv.ideal);
            return false;
        }
        for (IdealWithUniv<C> idealWithUniv : list) {
            GenPolynomialRing genPolynomialRing2 = idealWithUniv.ideal.list.ring;
            int n4 = 0;
            for (GenPolynomial genPolynomial : idealWithUniv.upolys) {
                GenPolynomial genPolynomial3 = genPolynomial.extendUnivariate(genPolynomialRing2, n4++);
                boolean bl = idealWithUniv.ideal.contains(genPolynomial3);
                if (bl) continue;
                System.out.println("not contained " + genPolynomial3 + " in " + idealWithUniv.ideal);
                return false;
            }
        }
        return true;
    }

    public IdealWithUniv<C> normalPositionFor(int n, int n2, List<GenPolynomial<C>> list) {
        GenPolynomialRing genPolynomialRing = this.list.ring;
        if (genPolynomialRing.tord.getEvord() != 2) {
            throw new IllegalArgumentException("invalid term order for normalPosition " + genPolynomialRing.tord);
        }
        if (genPolynomialRing.characteristic().signum() == 0) {
            return this.normalPositionForChar0(n, n2, list);
        }
        return this.normalPositionForCharP(n, n2, list);
    }

    IdealWithUniv<C> normalPositionForChar0(int n, int n2, List<GenPolynomial<C>> list) {
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> genPolynomial;
        Ideal<GenPolynomial<GenPolynomial<Element>>> ideal;
        GenPolynomialRing genPolynomialRing = this.list.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.extendLower(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.list.list.size() + 1);
        for (GenPolynomial ideal22 : this.getList()) {
            GenPolynomial<C> genPolynomial2 = ideal22.extendLower(genPolynomialRing2, 0, 0L);
            arrayList.add(genPolynomial2);
        }
        ArrayList arrayList2 = new ArrayList();
        if (list != null && list.size() > 0) {
            for (GenPolynomial genPolynomial3 : list) {
                GenPolynomial<C> genPolynomial4 = genPolynomial3.extendLower(genPolynomialRing2, 0, 0L);
                arrayList2.add(genPolynomial4);
            }
        }
        Ideal<GenPolynomial<GenPolynomial<Element>>> ideal2 = new Ideal<GenPolynomial<GenPolynomial<Element>>>(genPolynomialRing2, arrayList, true);
        int n3 = this.list.ring.nvar - 1 - n;
        int n4 = this.list.ring.nvar - 1 - n2;
        GenPolynomial<Element> genPolynomial5 = genPolynomialRing2.univariate(n3);
        GenPolynomial<GenPolynomial<Element>> genPolynomial6 = genPolynomialRing2.univariate(n4);
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> genPolynomial7 = genPolynomialRing2.univariate(genPolynomialRing2.nvar - 1);
        int n5 = 0;
        do {
            genPolynomial = genPolynomial7.subtract(genPolynomial6.subtract(genPolynomial5.multiply(genPolynomialRing2.fromInteger(--n5))));
            genPolynomial = genPolynomial.monic();
            ideal = ideal2.sum(genPolynomial);
            if (-n5 % 5 != 0) continue;
            logger.info((Object)("normal position, t = " + n5));
        } while (!ideal.isNormalPositionFor(n + 1, n2 + 1));
        if (this.debug) {
            logger.info((Object)("normal position = " + ideal));
        }
        arrayList2.add(genPolynomial);
        IdealWithUniv<GenPolynomial<GenPolynomial<Element>>> idealWithUniv = new IdealWithUniv<GenPolynomial<GenPolynomial<Element>>>(ideal, null, arrayList2);
        return idealWithUniv;
    }

    IdealWithUniv<C> normalPositionForCharP(int n, int n2, List<GenPolynomial<C>> list) {
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> genPolynomial;
        Serializable serializable;
        Ideal<GenPolynomial<GenPolynomial<Element>>> ideal;
        GenPolynomialRing genPolynomialRing = this.list.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.extendLower(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(this.list.list.size() + 1);
        for (GenPolynomial ideal22 : this.getList()) {
            GenPolynomial<C> genPolynomial2 = ideal22.extendLower(genPolynomialRing2, 0, 0L);
            arrayList.add(genPolynomial2);
        }
        ArrayList arrayList2 = new ArrayList();
        if (list != null && list.size() > 0) {
            for (GenPolynomial genPolynomial3 : list) {
                GenPolynomial<C> genPolynomial4 = genPolynomial3.extendLower(genPolynomialRing2, 0, 0L);
                arrayList2.add(genPolynomial4);
            }
        }
        Ideal<GenPolynomial<GenPolynomial<Element>>> ideal2 = new Ideal<GenPolynomial<GenPolynomial<Element>>>(genPolynomialRing2, arrayList, true);
        int n3 = this.list.ring.nvar - 1 - n;
        int n4 = this.list.ring.nvar - 1 - n2;
        GenPolynomial<Element> genPolynomial5 = genPolynomialRing2.univariate(n3);
        GenPolynomial<GenPolynomial<Element>> genPolynomial6 = genPolynomialRing2.univariate(n4);
        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> genPolynomial7 = genPolynomialRing2.univariate(genPolynomialRing2.nvar - 1);
        AlgebraicNumberRing algebraicNumberRing = null;
        Iterator iterator = null;
        int n5 = 0;
        do {
            Serializable serializable2;
            --n5;
            if (algebraicNumberRing == null) {
                serializable = genPolynomialRing2.fromInteger(n5);
                if (((GenPolynomial)serializable).isZERO()) {
                    Serializable serializable3;
                    serializable2 = genPolynomialRing2.coFac;
                    while (!(serializable2 instanceof AlgebraicNumberRing)) {
                        if (serializable2 instanceof GenPolynomialRing) {
                            serializable3 = (GenPolynomialRing)serializable2;
                            serializable2 = ((GenPolynomialRing)serializable3).coFac;
                            continue;
                        }
                        if (serializable2 instanceof QuotientRing) {
                            serializable3 = (QuotientRing)serializable2;
                            serializable2 = ((QuotientRing)serializable3).ring.coFac;
                            continue;
                        }
                        throw new ArithmeticException("field elements exhausted, need algebraic extension of base ring");
                    }
                    algebraicNumberRing = (AlgebraicNumberRing)serializable2;
                    logger.info((Object)("afac = " + algebraicNumberRing.toScript()));
                    iterator = algebraicNumberRing.iterator();
                    serializable3 = iterator.next();
                    for (int i = 0; i < algebraicNumberRing.characteristic().intValue(); ++i) {
                        serializable3 = iterator.next();
                    }
                    serializable = genPolynomialRing2.parse(((AlgebraicNumber)serializable3).toString());
                }
            } else {
                if (!iterator.hasNext()) {
                    throw new ArithmeticException("field elements exhausted, normal position not reachable: !aiter.hasNext(): " + n5);
                }
                serializable2 = (AlgebraicNumber)iterator.next();
                serializable = genPolynomialRing2.parse(serializable2.toString());
            }
            if (((GenPolynomial)serializable).isZERO()) {
                throw new ArithmeticException("field elements exhausted, normal position not reachable: tn == 0: " + n5);
            }
            genPolynomial = genPolynomial7.subtract(genPolynomial6.subtract(genPolynomial5.multiply((Element)serializable)));
            genPolynomial = genPolynomial.monic();
            ideal = ideal2.sum(genPolynomial);
            if (-n5 % 4 != 0) continue;
            logger.info((Object)("normal position, t = " + n5));
            logger.info((Object)("normal position, GB = " + ideal));
            if (n5 >= -550) continue;
            throw new ArithmeticException("normal position not reached in " + n5 + " steps");
        } while (!ideal.isNormalPositionFor(n + 1, n2 + 1));
        if (this.debug) {
            logger.info((Object)("normal position = " + ideal));
        }
        arrayList2.add(genPolynomial);
        serializable = new IdealWithUniv<GenPolynomial<GenPolynomial<Element>>>(ideal, null, arrayList2);
        return serializable;
    }

    public boolean isNormalPositionFor(int n, int n2) {
        int n3 = this.list.ring.nvar - 1 - n;
        int n4 = this.list.ring.nvar - 1 - n2;
        boolean bl = false;
        boolean bl2 = false;
        for (GenPolynomial<C> genPolynomial : this.getList()) {
            ExpVector expVector = genPolynomial.leadingExpVector();
            int[] nArray = expVector.dependencyOnVariables();
            if (nArray.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero");
            }
            if (nArray[0] == n3) {
                if (expVector.totalDeg() != 1L) {
                    return false;
                }
                bl = true;
            } else if (nArray[0] == n4) {
                if (expVector.totalDeg() != 1L) {
                    return false;
                }
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return bl && bl2;
    }

    public int[] normalPositionIndex2Vars() {
        int[] nArray = null;
        int n = -1;
        int n2 = -1;
        for (GenPolynomial<C> genPolynomial : this.getList()) {
            ExpVector expVector = genPolynomial.leadingExpVector();
            int[] nArray2 = expVector.dependencyOnVariables();
            if (nArray2.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero " + genPolynomial);
            }
            if (nArray2.length >= 2) {
                n = nArray2[0];
                n2 = nArray2[1];
                break;
            }
            int n3 = nArray2[0];
            GenPolynomial<C> genPolynomial2 = genPolynomial.reductum();
            expVector = genPolynomial2.degreeVector();
            nArray2 = expVector.dependencyOnVariables();
            int n4 = Arrays.binarySearch(nArray2, n3);
            int n5 = 2;
            if (n4 >= 0) {
                n5 = 3;
            }
            if (nArray2.length < n5) continue;
            switch (n4) {
                case 0: {
                    n = nArray2[1];
                    n2 = nArray2[2];
                    break;
                }
                case 1: {
                    n = nArray2[0];
                    n2 = nArray2[2];
                    break;
                }
                case 2: {
                    n = nArray2[0];
                    n2 = nArray2[1];
                    break;
                }
                default: {
                    n = nArray2[0];
                    n2 = nArray2[1];
                    break;
                }
            }
            break;
        }
        if (n < 0 || n2 < 0) {
            return nArray;
        }
        n = this.list.ring.nvar - 1 - n;
        n2 = this.list.ring.nvar - 1 - n2;
        nArray = new int[]{n2, n};
        logger.info((Object)("normalPositionIndex2Vars, np = " + Arrays.toString(nArray)));
        return nArray;
    }

    public int[] normalPositionIndexUnivars() {
        ExpVector expVector;
        int[] nArray = null;
        int n = -1;
        int n2 = -1;
        for (GenPolynomial<C> genPolynomial : this.getList()) {
            expVector = genPolynomial.degreeVector();
            int[] nArray2 = expVector.dependencyOnVariables();
            long l = expVector.totalDeg();
            if (nArray2.length == 0) {
                throw new IllegalArgumentException("ideal dimension is not zero");
            }
            if (nArray2.length == 1 && l >= 2L) {
                if (n == -1) {
                    n = nArray2[0];
                } else if (n2 == -1 && n > (n2 = nArray2[0])) {
                    int n3 = n;
                    n = n2;
                    n2 = n3;
                }
            }
            if (n < 0 || n2 < 0) continue;
            break;
        }
        if (n < 0 || n2 < 0) {
            for (GenPolynomial<C> genPolynomial : this.getList()) {
                expVector = genPolynomial.leadingExpVector();
                long l = expVector.totalDeg();
                if (l >= 2L) {
                    expVector = genPolynomial.degreeVector();
                    int[] nArray3 = expVector.dependencyOnVariables();
                    if (nArray3.length == 0) {
                        throw new IllegalArgumentException("ideal dimension is not zero");
                    }
                    if (nArray3.length >= 2) {
                        n = nArray3[0];
                        n2 = nArray3[1];
                    }
                }
                if (n < 0 || n2 < 0) continue;
                break;
            }
        }
        if (n < 0 || n2 < 0) {
            return nArray;
        }
        n = this.list.ring.nvar - 1 - n;
        n2 = this.list.ring.nvar - 1 - n2;
        nArray = new int[]{n2, n};
        logger.info((Object)("normalPositionIndexUnivars, np = " + Arrays.toString(nArray)));
        return nArray;
    }

    public List<IdealWithUniv<C>> zeroDimRootDecomposition() {
        List<IdealWithUniv<C>> list = this.zeroDimDecomposition();
        if (this.isZERO()) {
            return list;
        }
        if (this.isONE()) {
            return list;
        }
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        while (list.size() > 0) {
            IdealWithUniv<C> idealWithUniv = list.remove(0);
            int[] nArray = idealWithUniv.ideal.normalPositionIndex2Vars();
            if (nArray == null || nArray.length != 2) {
                arrayList.add(idealWithUniv);
                continue;
            }
            IdealWithUniv idealWithUniv2 = idealWithUniv.ideal.normalPositionFor(nArray[0], nArray[1], idealWithUniv.others);
            List list2 = idealWithUniv2.ideal.zeroDimDecompositionExtension(idealWithUniv.upolys, idealWithUniv2.others);
            list.addAll(list2);
        }
        return arrayList;
    }

    public List<IdealWithUniv<C>> zeroDimPrimeDecomposition() {
        List<IdealWithUniv<C>> list = this.zeroDimPrimeDecompositionFE();
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        if (list.size() == 1) {
            IdealWithUniv<C> idealWithUniv = list.get(0);
            int n = idealWithUniv.upolys.size() - this.getRing().nvar;
            List list2 = idealWithUniv.upolys.subList(n, idealWithUniv.upolys.size());
            idealWithUniv = new IdealWithUniv(this, list2);
            arrayList.add(idealWithUniv);
            return arrayList;
        }
        for (IdealWithUniv<C> idealWithUniv : list) {
            Serializable serializable;
            if (idealWithUniv.ideal.getRing().nvar == this.getRing().nvar) {
                arrayList.add(idealWithUniv);
                continue;
            }
            Ideal<C> ideal = idealWithUniv.ideal;
            if (idealWithUniv.others != null) {
                serializable = new ArrayList();
                serializable.addAll(ideal.getList());
                serializable.addAll(idealWithUniv.others);
                ideal = new Ideal(ideal.getRing(), serializable);
            }
            serializable = ideal.eliminate(this.getRing());
            int n = idealWithUniv.upolys.size() - this.getRing().nvar;
            List list3 = idealWithUniv.upolys.subList(n, idealWithUniv.upolys.size());
            IdealWithUniv idealWithUniv2 = new IdealWithUniv(serializable, list3);
            arrayList.add(idealWithUniv2);
        }
        return arrayList;
    }

    public List<IdealWithUniv<C>> zeroDimPrimeDecompositionFE() {
        List<IdealWithUniv<C>> list = this.zeroDimRootDecomposition();
        if (this.isZERO()) {
            return list;
        }
        if (this.isONE()) {
            return list;
        }
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        while (list.size() > 0) {
            IdealWithUniv<C> idealWithUniv = list.remove(0);
            int[] nArray = idealWithUniv.ideal.normalPositionIndexUnivars();
            if (nArray == null || nArray.length != 2) {
                arrayList.add(idealWithUniv);
                continue;
            }
            IdealWithUniv idealWithUniv2 = idealWithUniv.ideal.normalPositionFor(nArray[0], nArray[1], idealWithUniv.others);
            List list2 = idealWithUniv2.ideal.zeroDimDecompositionExtension(idealWithUniv.upolys, idealWithUniv2.others);
            list.addAll(list2);
        }
        return arrayList;
    }

    public Ideal<C> primaryIdeal(Ideal<C> ideal) {
        Ideal<C> ideal2;
        boolean bl;
        Ideal<C> ideal3;
        Ideal<C> ideal4 = ideal;
        int n = 0;
        do {
            ideal3 = ideal4;
            ++n;
        } while ((ideal4 = ideal3.product(ideal)).contains(this));
        do {
            if (bl = (ideal2 = this.sum(ideal4)).contains(ideal3)) continue;
            ideal3 = ideal4;
            ++n;
            ideal4 = ideal3.product(ideal);
        } while (!bl);
        logger.info((Object)("exponent = " + n));
        return ideal2;
    }

    public List<PrimaryComponent<C>> zeroDimPrimaryDecomposition() {
        List<IdealWithUniv<C>> list = this.zeroDimPrimeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("prim decomp = " + list));
        }
        return this.zeroDimPrimaryDecomposition(list);
    }

    public List<IdealWithUniv<C>> zeroDimElimination(List<IdealWithUniv<C>> list) {
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList<IdealWithUniv<C>>();
        if (this.isZERO()) {
            return arrayList;
        }
        if (this.isONE()) {
            arrayList.add(list.get(0));
            return arrayList;
        }
        ArrayList<IdealWithUniv<C>> arrayList2 = new ArrayList<IdealWithUniv<C>>();
        for (IdealWithUniv<C> idealWithUniv : list) {
            GenPolynomial genPolynomial;
            Serializable serializable4;
            Iterable<GenPolynomial<Object>> iterable;
            Serializable serializable2;
            Serializable serializable32;
            List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>();
            list2.addAll(idealWithUniv.ideal.getList());
            GenPolynomialRing genPolynomialRing = idealWithUniv.ideal.list.ring;
            int n = 0;
            for (Serializable serializable32 : idealWithUniv.upolys) {
                serializable2 = serializable32.extendUnivariate(genPolynomialRing, n++);
                if (n == 1) continue;
                list2.add((GenPolynomial<C>)serializable2);
            }
            if (idealWithUniv.others != null) {
                list2.addAll(idealWithUniv.others);
            }
            Ideal ideal = new Ideal(genPolynomialRing, list2);
            serializable32 = null;
            if (genPolynomialRing.tord.getEvord() != 4) {
                serializable2 = new ArrayList();
                serializable32 = new TermOrder(4);
                iterable = new GenPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, (TermOrder)serializable32, genPolynomialRing.getVars());
                for (Serializable serializable4 : list2) {
                    genPolynomial = ((GenPolynomialRing)iterable).copy(serializable4);
                    serializable2.add(genPolynomial.monic());
                }
                ideal = new Ideal(iterable, serializable2);
            }
            list2 = this.red.irreducibleSet(ideal.getList());
            ideal = new Ideal(ideal.getRing(), list2);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("eliminate = " + ideal));
            }
            serializable2 = ideal.eliminate(this.list.ring);
            if (serializable32 != null && !((Ideal)serializable2).list.ring.equals(this.list.ring)) {
                iterable = new ArrayList();
                for (Serializable serializable4 : ((Ideal)serializable2).getList()) {
                    genPolynomial = this.list.ring.copy((GenPolynomial<C>)serializable4);
                    iterable.add(genPolynomial);
                }
                serializable2 = new Ideal(this.list.ring, iterable);
            }
            int n2 = idealWithUniv.upolys.size() - this.list.ring.nvar;
            Iterator<GenPolynomial<C>> iterator = new ArrayList();
            for (int i = 0; i < this.list.ring.nvar; ++i) {
                iterator.add(idealWithUniv.upolys.get(i + n2));
            }
            serializable4 = new IdealWithUniv<C>(serializable2, iterator);
            arrayList2.add((IdealWithUniv<C>)serializable4);
        }
        return arrayList2;
    }

    public List<PrimaryComponent<C>> zeroDimPrimaryDecomposition(List<IdealWithUniv<C>> list) {
        ArrayList<PrimaryComponent<C>> arrayList = new ArrayList<PrimaryComponent<C>>();
        if (this.isZERO()) {
            return arrayList;
        }
        if (this.isONE()) {
            PrimaryComponent primaryComponent = new PrimaryComponent(list.get((int)0).ideal, list.get(0));
            arrayList.add(primaryComponent);
            return arrayList;
        }
        for (IdealWithUniv<C> idealWithUniv : list) {
            Ideal ideal = this.primaryIdeal(idealWithUniv.ideal);
            PrimaryComponent primaryComponent = new PrimaryComponent(ideal, idealWithUniv);
            arrayList.add(primaryComponent);
        }
        return arrayList;
    }

    public boolean isPrimaryDecomposition(List<PrimaryComponent<C>> list) {
        for (PrimaryComponent<C> object : list) {
            boolean primaryComponent = object.primary.contains(this);
            if (primaryComponent) continue;
            System.out.println("not contained " + this + " in " + object);
            return false;
        }
        Ideal ideal = null;
        for (PrimaryComponent<C> primaryComponent : list) {
            if (ideal == null) {
                ideal = primaryComponent.primary;
                continue;
            }
            ideal = ideal.intersect(primaryComponent.primary);
        }
        return this.contains(ideal);
    }

    public IdealWithUniv<Quotient<C>> extension(String ... stringArray) {
        GenPolynomialRing<C> genPolynomialRing = this.getRing();
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, stringArray.length, genPolynomialRing.tord, stringArray);
        IdealWithUniv idealWithUniv = this.extension(genPolynomialRing2);
        return idealWithUniv;
    }

    public IdealWithUniv<Quotient<C>> extension(GenPolynomialRing<C> genPolynomialRing) {
        QuotientRing<C> quotientRing = new QuotientRing<C>(genPolynomialRing);
        IdealWithUniv<Quotient<C>> idealWithUniv = this.extension(quotientRing);
        return idealWithUniv;
    }

    public IdealWithUniv<Quotient<C>> extension(QuotientRing<C> quotientRing) {
        GenPolynomial genPolynomial3;
        GenPolynomialRing<C> genPolynomialRing = this.getRing();
        GenPolynomialRing genPolynomialRing2 = quotientRing.ring;
        Object[] objectArray = GroebnerBasePartial.remainingVars(genPolynomialRing.getVars(), genPolynomialRing2.getVars());
        GroebnerBasePartial<C> groebnerBasePartial = new GroebnerBasePartial<C>();
        OptimizedPolynomialList optimizedPolynomialList = groebnerBasePartial.elimPartialGB(this.getList(), (String[])objectArray, genPolynomialRing2.getVars());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("rvars = " + Arrays.toString(objectArray)));
            logger.info((Object)("partialGB = " + optimizedPolynomialList));
        }
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, objectArray.length, genPolynomialRing.tord, (String[])objectArray);
        List list = optimizedPolynomialList.list;
        List list2 = PolyUtil.recursive(genPolynomialRing3, list);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(quotientRing, genPolynomialRing3);
        List list3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list2);
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = GCDFactory.getImplementation(genPolynomialRing.coFac);
        GenPolynomial genPolynomial2 = null;
        for (GenPolynomial genPolynomial3 : list2) {
            if (genPolynomial2 == null) {
                genPolynomial2 = genPolynomial3.leadingBaseCoefficient();
                continue;
            }
            genPolynomial2 = greatestCommonDivisorAbstract.lcm(genPolynomial2, genPolynomial3.leadingBaseCoefficient());
        }
        GenPolynomial<Object> genPolynomial4 = ((GenPolynomial)genPolynomialRing3.getONE()).multiply(genPolynomial2);
        genPolynomial3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, genPolynomial4);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension f = " + genPolynomial2));
            logger.info((Object)("ext = " + list3));
        }
        ArrayList arrayList = new ArrayList(0);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(genPolynomial3);
        list3 = PolyUtil.monic(list3);
        Ideal ideal = new Ideal(genPolynomialRing4, list3);
        IdealWithUniv idealWithUniv = new IdealWithUniv(ideal, arrayList, arrayList2);
        return idealWithUniv;
    }

    public IdealWithUniv<C> permContraction(IdealWithUniv<Quotient<C>> idealWithUniv) {
        return Ideal.permutation(this.getRing(), Ideal.contraction(idealWithUniv));
    }

    public static <C extends GcdRingElem<C>> IdealWithUniv<C> contraction(IdealWithUniv<Quotient<C>> idealWithUniv) {
        Serializable serializable;
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial222;
        ArrayList arrayList;
        Ideal ideal = idealWithUniv.ideal;
        List list = ideal.getList();
        QuotientRing quotientRing = (QuotientRing)ideal.getRing().coFac;
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(quotientRing.ring, ideal.getRing());
        GenPolynomialRing genPolynomialRing2 = quotientRing.ring.extend(ideal.getRing().getVars());
        TermOrder termOrder = new TermOrder(quotientRing.ring.tord.getEvord());
        genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing2.coFac, genPolynomialRing2.nvar, termOrder, genPolynomialRing2.getVars());
        List list2 = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing, list);
        List list3 = PolyUtil.distribute(genPolynomialRing2, list2);
        Ideal ideal2 = new Ideal(genPolynomialRing2, list3);
        ArrayList arrayList2 = new ArrayList();
        if (idealWithUniv.others != null && idealWithUniv.others.size() > 0) {
            arrayList = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing, idealWithUniv.others);
            List list4 = PolyUtil.distribute(genPolynomialRing2, arrayList);
            arrayList2.addAll(list4);
        }
        arrayList = new ArrayList(0);
        int n = 0;
        for (GenPolynomial genPolynomial222 : idealWithUniv.upolys) {
            genPolynomial = genPolynomial222.extendUnivariate(ideal.getRing(), n++);
            GenPolynomial serializable22 = PolyUfdUtil.integralFromQuotientCoefficients(genPolynomialRing, genPolynomial);
            serializable = PolyUtil.distribute(genPolynomialRing2, serializable22);
            arrayList.add(serializable);
        }
        GreatestCommonDivisorAbstract greatestCommonDivisorAbstract = GCDFactory.getImplementation(quotientRing.ring.coFac);
        genPolynomial222 = null;
        for (GenPolynomial genPolynomial2 : list2) {
            if (genPolynomial222 == null) {
                genPolynomial222 = (GenPolynomial)genPolynomial2.leadingBaseCoefficient();
                continue;
            }
            genPolynomial222 = greatestCommonDivisorAbstract.lcm(genPolynomial222, (GenPolynomial)genPolynomial2.leadingBaseCoefficient());
        }
        genPolynomial = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial222);
        genPolynomial222 = PolyUtil.distribute(genPolynomialRing2, genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contraction f = " + genPolynomial222));
            logger.info((Object)("cont = " + ideal2));
        }
        arrayList2.add(genPolynomial222);
        if (genPolynomial222.isONE()) {
            IdealWithUniv idealWithUniv2 = new IdealWithUniv(ideal2, arrayList, arrayList2);
            return idealWithUniv2;
        }
        Ideal ideal3 = ideal2.infiniteQuotientRab(genPolynomial222);
        serializable = new IdealWithUniv(ideal3, arrayList, arrayList2);
        return serializable;
    }

    public static <C extends GcdRingElem<C>> IdealWithUniv<C> permutation(GenPolynomialRing<C> genPolynomialRing, IdealWithUniv<C> idealWithUniv) {
        Object[] objectArray;
        Ideal ideal = idealWithUniv.ideal;
        GenPolynomialRing genPolynomialRing2 = ideal.getRing();
        Object[] objectArray2 = genPolynomialRing.getVars();
        if (Arrays.equals(objectArray2, objectArray = genPolynomialRing2.getVars())) {
            return idealWithUniv;
        }
        List<Integer> list = GroebnerBasePartial.getPermutation((String[])objectArray, (String[])objectArray2);
        GenPolynomialRing genPolynomialRing3 = TermOrderOptimization.permutation(list, ideal.getRing());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("pfac = " + genPolynomialRing3));
        }
        List list2 = TermOrderOptimization.permutation(list, genPolynomialRing3, ideal.getList());
        ideal = new Ideal(genPolynomialRing3, list2);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("perm cont = " + ideal));
        }
        List list3 = TermOrderOptimization.permutation(list, genPolynomialRing3, idealWithUniv.others);
        List list4 = TermOrderOptimization.permutation(list, genPolynomialRing3, idealWithUniv.upolys);
        IdealWithUniv idealWithUniv2 = new IdealWithUniv(ideal, list4, list3);
        return idealWithUniv2;
    }

    public Ideal<C> radical() {
        List<IdealWithUniv<C>> list = this.radicalDecomposition();
        ArrayList<Ideal<C>> arrayList = new ArrayList<Ideal<C>>(list.size());
        for (IdealWithUniv<C> idealWithUniv : list) {
            arrayList.add(idealWithUniv.ideal);
        }
        Ideal<C> ideal = this.intersect(arrayList);
        return ideal;
    }

    public List<IdealWithUniv<C>> radicalDecomposition() {
        Serializable serializable;
        List list3;
        int n = this.commonZeroTest();
        ArrayList<IdealWithUniv<C>> arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (n < 0) {
            IdealWithUniv idealWithUniv = new IdealWithUniv(this, arrayList2);
            arrayList.add(idealWithUniv);
            return arrayList;
        }
        if (n == 0) {
            arrayList = this.zeroDimRadicalDecomposition();
            return arrayList;
        }
        if (this.isZERO()) {
            return arrayList;
        }
        if (this.list.ring.coFac.characteristic().signum() > 0 && !this.list.ring.coFac.isFinite()) {
            logger.warn((Object)("must use prime decomposition for char p and infinite coefficient rings, found " + this.list.ring.coFac.toScript()));
            return this.primeDecomposition();
        }
        Dimension dimension = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dimension));
        }
        Set<Set<Integer>> set = dimension.M;
        Set<Integer> object2 = null;
        for (Set<Integer> integerArray2 : set) {
            if (object2 == null) {
                object2 = integerArray2;
                continue;
            }
            if (integerArray2.size() >= object2.size()) continue;
            object2 = integerArray2;
        }
        int n2 = object2.size();
        Integer[] integerArray = new Integer[]{};
        int n3 = object2.toArray(integerArray)[n2 - 1];
        for (Set<Integer> n5 : set) {
            int idealWithUniv;
            if (n5.size() != n2 || (idealWithUniv = n5.toArray(integerArray)[n2 - 1].intValue()) >= n3) continue;
            object2 = n5;
            n3 = idealWithUniv;
        }
        Object[] objectArray = new String[object2.size()];
        int n4 = 0;
        for (Integer n5 : object2) {
            objectArray[n4++] = dimension.v[n5];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(objectArray) + ", indexes = " + object2));
        }
        IdealWithUniv<Quotient<C>> idealWithUniv = this.extension((String[])objectArray);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + idealWithUniv));
        }
        List list2 = idealWithUniv.ideal.zeroDimRadicalDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim radical decomp = " + list2));
        }
        for (List list3 : list2) {
            serializable = this.permContraction((IdealWithUniv<Quotient<C>>)((Object)list3));
            arrayList.add((IdealWithUniv<C>)serializable);
        }
        IdealWithUniv<C> idealWithUniv2 = this.permContraction(idealWithUniv);
        list3 = idealWithUniv2.others;
        if (list3.size() == 0) {
            return arrayList;
        }
        serializable = (GenPolynomial)list3.get(0);
        if (((GenPolynomial)serializable).isONE()) {
            return arrayList;
        }
        Ideal<C> ideal = this.sum((GenPolynomial<C>)serializable);
        if (ideal.isONE()) {
            logger.info((Object)("1 in ideal for " + serializable));
            return arrayList;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("radical decomp ext-cont fx = " + serializable));
            logger.info((Object)("recursion radical decomp T = " + ideal));
        }
        List<IdealWithUniv<C>> list4 = ideal.radicalDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion radical decomp = " + list4));
        }
        arrayList.addAll(list4);
        return arrayList;
    }

    public List<IdealWithUniv<C>> decomposition() {
        Serializable serializable;
        List list4;
        int n = this.commonZeroTest();
        List<IdealWithUniv<C>> list2 = new ArrayList<IdealWithUniv<C>>();
        if (n < 0) {
            return list2;
        }
        if (n == 0) {
            list2 = this.zeroDimDecomposition();
            return list2;
        }
        if (this.isZERO()) {
            return list2;
        }
        Dimension dimension = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dimension));
        }
        Set<Set<Integer>> set = dimension.M;
        Set<Integer> set2 = null;
        for (Set<Integer> set3 : set) {
            if (set2 == null) {
                set2 = set3;
                continue;
            }
            if (set3.size() >= set2.size()) continue;
            set2 = set3;
        }
        Object[] objectArray = new String[set2.size()];
        int n2 = 0;
        for (Integer object2 : set2) {
            objectArray[n2++] = dimension.v[object2];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(objectArray)));
        }
        IdealWithUniv<Quotient<C>> idealWithUniv = this.extension((String[])objectArray);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + idealWithUniv));
        }
        List list3 = idealWithUniv.ideal.zeroDimDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim irred decomp = " + list3));
        }
        for (List list4 : list3) {
            serializable = this.permContraction((IdealWithUniv<Quotient<C>>)((Object)list4));
            list2.add((IdealWithUniv<C>)serializable);
        }
        IdealWithUniv<C> idealWithUniv2 = this.permContraction(idealWithUniv);
        list4 = idealWithUniv2.others;
        if (list4.size() == 0) {
            return list2;
        }
        serializable = (GenPolynomial)list4.get(0);
        if (((GenPolynomial)serializable).isONE()) {
            return list2;
        }
        Ideal<C> ideal = this.sum((GenPolynomial<C>)serializable);
        if (ideal.isONE()) {
            logger.info((Object)("1 in ideal for " + serializable));
            return list2;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("irred decomp ext-cont fx = " + serializable));
            logger.info((Object)("recursion irred decomp T = " + ideal));
        }
        List<IdealWithUniv<C>> list5 = ideal.decomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion irred decomposition = " + list5));
        }
        list2.addAll(list5);
        return list2;
    }

    public List<IdealWithUniv<C>> primeDecomposition() {
        Serializable serializable;
        List list4;
        int n = this.commonZeroTest();
        List<IdealWithUniv<C>> list2 = new ArrayList<IdealWithUniv<C>>();
        if (n < 0) {
            return list2;
        }
        if (n == 0) {
            list2 = this.zeroDimPrimeDecomposition();
            return list2;
        }
        if (this.isZERO()) {
            return list2;
        }
        Dimension dimension = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dimension));
        }
        Set<Set<Integer>> set = dimension.M;
        Set<Integer> set2 = null;
        for (Set<Integer> set3 : set) {
            if (set2 == null) {
                set2 = set3;
                continue;
            }
            if (set3.size() >= set2.size()) continue;
            set2 = set3;
        }
        Object[] objectArray = new String[set2.size()];
        int n2 = 0;
        for (Integer object2 : set2) {
            objectArray[n2++] = dimension.v[object2];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(objectArray)));
        }
        IdealWithUniv<Quotient<C>> idealWithUniv = this.extension((String[])objectArray);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + idealWithUniv));
        }
        List list3 = idealWithUniv.ideal.zeroDimPrimeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim prime decomp = " + list3));
        }
        for (List list4 : list3) {
            serializable = this.permContraction((IdealWithUniv<Quotient<C>>)((Object)list4));
            list2.add((IdealWithUniv<C>)serializable);
        }
        IdealWithUniv<C> idealWithUniv2 = this.permContraction(idealWithUniv);
        list4 = idealWithUniv2.others;
        if (list4.size() == 0) {
            return list2;
        }
        serializable = (GenPolynomial)list4.get(0);
        if (((GenPolynomial)serializable).isONE()) {
            return list2;
        }
        Ideal<C> ideal = this.sum((GenPolynomial<C>)serializable);
        if (ideal.isONE()) {
            logger.info((Object)("1 in ideal for " + serializable));
            return list2;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("prime decomp ext-cont fx = " + serializable));
            logger.info((Object)("recursion prime decomp T = " + ideal));
        }
        List<IdealWithUniv<C>> list5 = ideal.primeDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion prime decomp = " + list5));
        }
        list2.addAll(list5);
        return list2;
    }

    public boolean isDecomposition(List<IdealWithUniv<C>> list) {
        if (list == null || list.size() == 0) {
            return this.isZERO();
        }
        GenPolynomialRing genPolynomialRing = this.list.ring;
        int n = genPolynomialRing.nvar;
        int n2 = list.get((int)0).ideal.list.ring.nvar;
        int n3 = n2 - n;
        Ideal<C> ideal = this;
        if (n3 > 0) {
            GenPolynomialRing genPolynomialRing2 = genPolynomialRing.extendLower(n3);
            ArrayList<GenPolynomial<C>> serializable = new ArrayList<GenPolynomial<C>>(this.list.list.size());
            for (GenPolynomial<C> genPolynomial : this.getList()) {
                GenPolynomial<C> genPolynomial2 = genPolynomial.extendLower(genPolynomialRing2, 0, 0L);
                serializable.add(genPolynomial2);
            }
            ideal = new Ideal<C>(genPolynomialRing2, serializable, this.isGB, this.isTopt);
        }
        for (IdealWithUniv idealWithUniv : list) {
            boolean bl = idealWithUniv.ideal.contains(ideal);
            if (bl) continue;
            System.out.println("not contained " + this + " in " + idealWithUniv.ideal);
            return false;
        }
        return true;
    }

    public List<PrimaryComponent<C>> primaryDecomposition() {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object22;
        int n = this.commonZeroTest();
        List<PrimaryComponent<C>> list = new ArrayList<PrimaryComponent<C>>();
        if (n < 0) {
            return list;
        }
        if (n == 0) {
            list = this.zeroDimPrimaryDecomposition();
            return list;
        }
        if (this.isZERO()) {
            return list;
        }
        Dimension dimension = this.dimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("dimension = " + dimension));
        }
        Set<Set<Integer>> set = dimension.M;
        Set<Integer> set2 = null;
        for (Set<Integer> set3 : set) {
            if (set2 == null) {
                set2 = set3;
                continue;
            }
            if (set3.size() >= set2.size()) continue;
            set2 = set3;
        }
        Object[] objectArray = new String[set2.size()];
        int n2 = 0;
        for (Integer object32 : set2) {
            objectArray[n2++] = dimension.v[object32];
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension for variables = " + Arrays.toString(objectArray)));
        }
        IdealWithUniv<Quotient<C>> idealWithUniv = this.extension((String[])objectArray);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("extension = " + idealWithUniv));
        }
        List list2 = idealWithUniv.ideal.zeroDimPrimaryDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("0-dim primary decomp = " + list2));
        }
        ArrayList arrayList = new ArrayList();
        for (Object object22 : list2) {
            serializable2 = new IdealWithUniv<Quotient<C>>(((PrimaryComponent)object22).primary, arrayList);
            IdealWithUniv<C> n3 = this.permContraction((IdealWithUniv<Quotient<C>>)serializable2);
            serializable = this.permContraction(((PrimaryComponent)object22).prime);
            object = new PrimaryComponent(n3.ideal, serializable);
            list.add((PrimaryComponent<C>)object);
        }
        IdealWithUniv<C> idealWithUniv2 = this.permContraction(idealWithUniv);
        if (this.debug) {
            logger.info((Object)("cont(Ext) = " + idealWithUniv2));
        }
        if ((object22 = idealWithUniv2.others).size() == 0) {
            return list;
        }
        serializable2 = (GenPolynomial)object22.get(0);
        if (((GenPolynomial)serializable2).isONE()) {
            return list;
        }
        int n3 = this.infiniteQuotientExponent((GenPolynomial<C>)serializable2, idealWithUniv2.ideal);
        if (n3 == 0) {
            logger.info((Object)"exponent is 0 ");
            return list;
        }
        if (n3 > 1) {
            serializable2 = (GenPolynomial)Power.positivePower(serializable2, n3);
        }
        if (this.debug) {
            logger.info((Object)("exponent fx = " + n3 + ", fx^s = " + serializable2));
        }
        if (((Ideal)(serializable = this.sum((GenPolynomial<C>)serializable2))).isONE()) {
            logger.info((Object)("1 in ideal for " + serializable2));
            return list;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("primmary decomp ext-cont fx = " + serializable2));
            logger.info((Object)("recursion primary decomp T = " + serializable));
        }
        object = ((Ideal)serializable).primaryDecomposition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursion primary decomp = " + object));
        }
        list.addAll((Collection<PrimaryComponent<C>>)object);
        return list;
    }
}

