/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import java.math.BigInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PolyUfdUtilTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<edu.jas.arith.BigInteger> dfac;
    GenPolynomialRing<edu.jas.arith.BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<edu.jas.arith.BigInteger>> rfac;
    edu.jas.arith.BigInteger ai;
    edu.jas.arith.BigInteger bi;
    edu.jas.arith.BigInteger ci;
    edu.jas.arith.BigInteger di;
    edu.jas.arith.BigInteger ei;
    GenPolynomial<edu.jas.arith.BigInteger> a;
    GenPolynomial<edu.jas.arith.BigInteger> b;
    GenPolynomial<edu.jas.arith.BigInteger> c;
    GenPolynomial<edu.jas.arith.BigInteger> d;
    GenPolynomial<edu.jas.arith.BigInteger> e;
    GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> ar;
    GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> br;
    GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> cr;
    GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> dr;
    GenPolynomial<GenPolynomial<edu.jas.arith.BigInteger>> er;
    int rl = 5;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolyUfdUtilTest.suite());
        ComputerThreads.terminate();
    }

    public PolyUfdUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PolyUfdUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
        ComputerThreads.terminate();
    }

    protected static BigInteger getPrime1() {
        long l = 2L;
        for (int i = 1; i < 60; ++i) {
            l *= 2L;
        }
        return new BigInteger("" + (l -= 93L));
    }

    protected static BigInteger getPrime2() {
        long l = 2L;
        for (int i = 1; i < 30; ++i) {
            l *= 2L;
        }
        return new BigInteger("" + (l -= 35L));
    }

    public void testKroneckerSubstitution() {
        for (int i = 0; i < 10; ++i) {
            this.a = this.dfac.random(this.kl, this.ll * 2, this.el * 5, this.q);
            long l = this.a.degree() + 1L;
            this.b = PolyUfdUtil.substituteKronecker(this.a, l);
            this.c = PolyUfdUtil.backSubstituteKronecker(this.dfac, this.b, l);
            this.e = this.a.subtract((edu.jas.arith.BigInteger)((Object)this.c));
            PolyUfdUtilTest.assertTrue((String)"back(subst(a)) = a", (boolean)this.e.isZERO());
        }
    }

    public void testRecursivePseudoDivisionDense() {
        String[] stringArray = new String[]{"x"};
        String[] stringArray2 = new String[]{"t"};
        this.dfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.to, stringArray);
        this.rfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(this.dfac, this.to, stringArray2);
        QuotientRing<edu.jas.arith.BigInteger> quotientRing = new QuotientRing<edu.jas.arith.BigInteger>(this.dfac);
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = new GenPolynomialRing<edu.jas.arith.BigInteger>(quotientRing, this.rfac);
        this.ar = this.rfac.random(this.kl, 2 * this.ll, this.el + 4, this.q);
        this.br = this.rfac.random(this.kl, 2 * this.ll, this.el + 2, this.q);
        this.dr = PolyUtil.recursivePseudoDivide(this.ar, this.br);
        this.cr = PolyUtil.recursiveDensePseudoRemainder(this.ar, this.br);
        GenPolynomial genPolynomial = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.ar);
        GenPolynomial genPolynomial2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.br);
        GenPolynomial genPolynomial3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.cr);
        GenPolynomial genPolynomial4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.dr);
        GenPolynomial genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial genPolynomial7 = genPolynomial5.multiply(genPolynomial2).sum(genPolynomial6);
        PolyUfdUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUfdUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUfdUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }

    public void testRecursivePseudoDivisionSparse() {
        String[] stringArray = new String[]{"x"};
        String[] stringArray2 = new String[]{"t"};
        this.dfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(new edu.jas.arith.BigInteger(1L), this.to, stringArray);
        this.rfac = new GenPolynomialRing<edu.jas.arith.BigInteger>(this.dfac, this.to, stringArray2);
        QuotientRing<edu.jas.arith.BigInteger> quotientRing = new QuotientRing<edu.jas.arith.BigInteger>(this.dfac);
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = new GenPolynomialRing<edu.jas.arith.BigInteger>(quotientRing, this.rfac);
        this.ar = this.rfac.random(this.kl, 2 * this.ll, this.el + 4, this.q);
        this.br = this.rfac.random(this.kl, 2 * this.ll, this.el + 2, this.q);
        this.dr = PolyUtil.recursivePseudoDivide(this.ar, this.br);
        this.cr = PolyUtil.recursiveSparsePseudoRemainder(this.ar, this.br);
        GenPolynomial genPolynomial = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.ar);
        GenPolynomial genPolynomial2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.br);
        GenPolynomial genPolynomial3 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.cr);
        GenPolynomial genPolynomial4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing, this.dr);
        GenPolynomial genPolynomial5 = genPolynomial.divide(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial.remainder(genPolynomial2);
        GenPolynomial genPolynomial7 = genPolynomial5.multiply(genPolynomial2).sum(genPolynomial6);
        PolyUfdUtilTest.assertEquals((String)"ap = qp bp + rp: ", genPolynomial, genPolynomial7);
        PolyUfdUtilTest.assertEquals((String)"cp = rp: ", genPolynomial6.monic(), genPolynomial3.monic());
        PolyUfdUtilTest.assertEquals((String)"dp = qp: ", genPolynomial5.monic(), genPolynomial4.monic());
    }
}

