/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class ReducerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private final CriticalPairList<C> pairlist;
    private final Terminator fin;
    private final ReductionPar<C> red;
    private static final Logger logger = Logger.getLogger(ReducerSeqPair.class);

    ReducerSeqPair(Terminator terminator, List<GenPolynomial<C>> list, CriticalPairList<C> criticalPairList) {
        this.fin = terminator;
        this.G = list;
        this.pairlist = criticalPairList;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "ReducerSeqPair";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<C>> list;
            GenPolynomial genPolynomial;
            while (!this.pairlist.hasNext()) {
                this.pairlist.update();
                this.fin.beIdle();
                bl = true;
                try {
                    if (++n2 % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown " + this.fin + " after: " + interruptedException));
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.fin.allIdle();
                    logger.info((Object)("shutdown after .isInterrupted(): " + this.fin));
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            if (bl) {
                this.fin.notIdle();
                bl = false;
            }
            CriticalPair<C> criticalPair = this.pairlist.getNext();
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("interrupt after getNext");
            }
            if (criticalPair == null) {
                this.pairlist.update();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pi = " + criticalPair.pi));
                logger.debug((Object)("pj = " + criticalPair.pj));
            }
            if ((genPolynomial = this.red.SPolynomial(criticalPair.pi, criticalPair.pj)).isZERO()) {
                this.pairlist.record(criticalPair, genPolynomial);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(S) = " + genPolynomial.leadingExpVector()));
            }
            GenPolynomial<C> genPolynomial2 = this.red.normalform(this.G, genPolynomial);
            ++n;
            if (genPolynomial2.isZERO()) {
                this.pairlist.record(criticalPair, genPolynomial2);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ht(H) = " + genPolynomial2.leadingExpVector()));
            }
            if ((genPolynomial2 = genPolynomial2.monic()).isONE()) {
                this.pairlist.putOne();
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add(genPolynomial2);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("H = " + genPolynomial2));
            }
            list = this.G;
            synchronized (list) {
                this.G.add(genPolynomial2);
            }
            this.pairlist.update(criticalPair, genPolynomial2);
        }
        logger.info((Object)("terminated, done " + n + " reductions"));
    }
}

