/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class IntGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigInteger> fac;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IntGenPolynomialTest.suite());
    }

    public IntGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(IntGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        IntGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        IntGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        IntGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        IntGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        IntGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        IntGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            IntGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            IntGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            IntGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((BigInteger)((Object)this.b));
        this.d = this.c.subtract((BigInteger)((Object)this.b));
        IntGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigInteger bigInteger = BigInteger.IRAND(this.kl);
        this.b = new GenPolynomial<BigInteger>(this.fac, bigInteger, expVector);
        this.c = this.a.sum((BigInteger)((Object)this.b));
        this.d = this.a.sum(bigInteger, expVector);
        IntGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigInteger)((Object)this.b));
        this.d = this.a.subtract(bigInteger, expVector);
        IntGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigInteger>(this.fac);
        this.b = new GenPolynomial<BigInteger>(this.fac, bigInteger, expVector);
        this.c = this.b.sum((BigInteger)((Object)this.a));
        this.d = this.a.sum(bigInteger, expVector);
        IntGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigInteger)((Object)this.b));
        this.d = this.a.subtract(bigInteger, expVector);
        IntGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        IntGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        IntGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigInteger)((Object)this.a));
        this.d = this.a.multiply((BigInteger)((Object)this.b));
        IntGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        IntGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigInteger)((Object)this.c));
        IntGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        IntGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        IntGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigInteger)((Object)this.b.multiply((BigInteger)((Object)this.c))));
        this.e = this.a.multiply((BigInteger)((Object)this.b)).multiply(this.c);
        IntGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        IntGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigInteger bigInteger = this.b.leadingBaseCoefficient();
        this.e = new GenPolynomial<BigInteger>(this.fac, bigInteger);
        this.c = this.b.multiply((BigInteger)((Object)this.e));
        this.d = this.e.multiply((BigInteger)((Object)this.b));
        IntGenPolynomialTest.assertEquals((String)"b*p(y,u) = p(y,u)*b", this.c, this.d);
    }

    public void testBLAS1() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigInteger bigInteger = BigInteger.IRAND(this.kl);
        this.d = this.a.subtractMultiple(bigInteger, this.b);
        this.e = this.a.subtract((BigInteger)((Object)this.b.multiply(bigInteger)));
        IntGenPolynomialTest.assertEquals((String)"a - (lc) b == a - ((lc) b)", this.d, this.e);
        this.d = this.a.subtractMultiple(bigInteger, expVector, this.b);
        this.e = this.a.subtract((BigInteger)((Object)this.b.multiply(bigInteger, expVector)));
        IntGenPolynomialTest.assertEquals((String)"a - (lc ev) b == a - ((lc ev) b)", this.d, this.e);
        ExpVector expVector2 = ExpVector.EVRAND(this.rl, this.el, this.q);
        BigInteger bigInteger2 = BigInteger.IRAND(this.kl);
        this.d = this.a.scaleSubtractMultiple(bigInteger2, bigInteger, expVector, this.b);
        this.e = this.a.multiply(bigInteger2).subtract((BigInteger)((Object)this.b.multiply(bigInteger, expVector)));
        IntGenPolynomialTest.assertEquals((String)"(tc) a - (lc ev) b == ((tc) a - ((lc ev) b))", this.d, this.e);
        this.d = this.a.scaleSubtractMultiple(bigInteger2, expVector2, bigInteger, expVector, this.b);
        this.e = this.a.multiply(bigInteger2, expVector2).subtract((BigInteger)((Object)this.b.multiply(bigInteger, expVector)));
        IntGenPolynomialTest.assertEquals((String)"(tc fv) a - (lc ev) b == ((tc fv) a - ((lc ev) b))", this.d, this.e);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigInteger)((Object)this.b.sum((BigInteger)((Object)this.c))));
        this.e = this.a.multiply((BigInteger)((Object)this.b)).sum((GenPolynomial<BigInteger>)this.a.multiply((BigInteger)((Object)this.c)));
        IntGenPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }
}

