/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.Overlap;
import edu.jas.poly.OverlapList;
import edu.jas.poly.WordFactory;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.MonoidFactory;
import edu.jas.structure.NotInvertibleException;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Word
implements MonoidElem<Word> {
    public final WordFactory mono;
    final String val;
    protected int hash = 0;

    public Word(WordFactory wordFactory) {
        this(wordFactory, "");
    }

    public Word(WordFactory wordFactory, String string) {
        this(wordFactory, string, true);
    }

    public Word(WordFactory wordFactory, String string, boolean bl) {
        this.mono = wordFactory;
        this.hash = 0;
        if (string == null) {
            throw new IllegalArgumentException("null string not allowed");
        }
        if (bl) {
            if (this.mono.translation != null) {
                String[] stringArray = GenPolynomialTokenizer.variableList(string);
                this.val = this.mono.translate(stringArray);
            } else {
                this.val = WordFactory.cleanSpace(string);
            }
        } else {
            this.val = string;
        }
    }

    @Override
    public MonoidFactory<Word> factory() {
        return this.mono;
    }

    @Override
    public Word copy() {
        return new Word(this.mono, this.val, false);
    }

    String getVal() {
        return this.val;
    }

    public char getVal(int n) {
        return this.val.charAt(n);
    }

    public int length() {
        return this.val.length();
    }

    public String toString() {
        if (this.val.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("\"");
        if (this.mono.translation == null) {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.mono.transVar(this.getVal(i)));
            }
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        if (this.val.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.mono.translation == null) {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(this.mono.transVar(this.getVal(i)));
            }
        }
        stringBuffer.append("");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.mono.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Word)) {
            return false;
        }
        Word word = (Word)object;
        int n = this.compareTo(word);
        return 0 == n;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.val.hashCode();
        }
        return this.hash;
    }

    @Override
    public boolean isONE() {
        return 0 == this.val.length();
    }

    @Override
    public boolean isUnit() {
        return this.isONE();
    }

    @Override
    public Word multiply(Word word) {
        return new Word(this.mono, this.val + word.val, false);
    }

    @Override
    public Word divide(Word word) {
        Word[] wordArray = this.divideWord(word);
        if (!wordArray[0].isONE() && !wordArray[1].isONE()) {
            throw new IllegalArgumentException("not simple dividable: left = " + wordArray[0] + ", right = " + wordArray[1] + ", use divideWord");
        }
        return wordArray[0].multiply(wordArray[1]);
    }

    public Word[] divideWord(Word word) {
        int n = this.val.indexOf(word.val);
        if (n < 0) {
            throw new NotInvertibleException("not dividable: " + this + ", other " + word);
        }
        int n2 = word.val.length();
        String string = this.val.substring(0, n);
        String string2 = this.val.substring(n + n2);
        Word[] wordArray = new Word[]{new Word(this.mono, string, false), new Word(this.mono, string2, false)};
        return wordArray;
    }

    @Override
    public Word remainder(Word word) {
        int n = this.val.indexOf(word.val);
        if (n < 0) {
            throw new NotInvertibleException("not dividable: " + this + ", other " + word);
        }
        return word;
    }

    public Word[] quotientRemainder(Word word) {
        return new Word[]{this.divide(word), this.remainder(word)};
    }

    @Override
    public Word inverse() {
        if (this.val.length() == 0) {
            return this;
        }
        throw new NotInvertibleException("not inversible " + this);
    }

    public int signum() {
        int n = this.val.length();
        if (n > 0) {
            n = 1;
        }
        assert (n >= 0);
        return n;
    }

    public long degree() {
        return this.val.length();
    }

    public SortedMap<String, Integer> dependencyOnVariables() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (int i = 0; i < this.val.length(); ++i) {
            String string = String.valueOf(this.val.charAt(i));
            Integer n = (Integer)treeMap.get(string);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            treeMap.put(string, n);
        }
        return treeMap;
    }

    public ExpVector leadingExpVector() {
        int n;
        int n2;
        long l = 0L;
        int n3 = 32;
        for (n2 = 0; n2 < this.val.length(); ++n2) {
            n = this.val.charAt(n2);
            if (l == 0L) {
                n3 = n;
                ++l;
                continue;
            }
            if (n3 != n) break;
            ++l;
        }
        n2 = this.mono.length();
        if (l == 0L) {
            return ExpVector.create(n2);
        }
        n = n2 - this.mono.indexOf((char)n3) - 1;
        return ExpVector.create(n2, n, l);
    }

    public Word reductum() {
        if (this.isONE()) {
            return this;
        }
        int n = 0;
        char c = ' ';
        for (int i = 0; i < this.val.length(); ++i) {
            char c2 = this.val.charAt(i);
            if (n == 0) {
                c = c2;
                ++n;
                continue;
            }
            if (c != c2) break;
            ++n;
        }
        String string = this.val.substring(n);
        return new Word(this.mono, string, false);
    }

    public boolean multipleOf(Word word) {
        return this.val.contains(word.val);
    }

    public boolean divides(Word word) {
        return word.val.contains(this.val);
    }

    @Override
    public int compareTo(Word word) {
        return this.val.compareTo(word.val);
    }

    public int gradCompareTo(Word word) {
        long l;
        long l2 = this.degree();
        if (l2 < (l = word.degree())) {
            return 1;
        }
        if (l2 > l) {
            return -1;
        }
        return this.compareTo(word);
    }

    public int gradInvlexCompareTo(Word word) {
        long l;
        long l2 = this.degree();
        if (l2 < (l = word.degree())) {
            return 1;
        }
        if (l2 > l) {
            return -1;
        }
        return -this.compareTo(word);
    }

    public boolean isOverlap(Overlap overlap, Word word) {
        return overlap.isOverlap(this, word);
    }

    public OverlapList overlap(Word word) {
        OverlapList overlapList = new OverlapList();
        Word word2 = this.mono.getONE();
        String string = this.val;
        String string2 = word.val;
        int n = string.length();
        int n2 = string2.length();
        int n3 = string2.indexOf(string);
        if (n3 >= 0) {
            while (n3 >= 0) {
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + n);
                Word word3 = new Word(this.mono, string3, false);
                Word word4 = new Word(this.mono, string4, false);
                overlapList.add(new Overlap(word3, word4, word2, word2));
                n3 = string2.indexOf(string, n3 + n);
            }
            return overlapList;
        }
        n3 = string.indexOf(string2);
        if (n3 >= 0) {
            while (n3 >= 0) {
                String string5 = string.substring(0, n3);
                String string6 = string.substring(n3 + n2);
                Word word5 = new Word(this.mono, string5, false);
                Word word6 = new Word(this.mono, string6, false);
                overlapList.add(new Overlap(word2, word2, word5, word6));
                n3 = string.indexOf(string2, n3 + n2);
            }
            return overlapList;
        }
        if (n >= n2) {
            Word word7;
            Word word8;
            String string7;
            String string8;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                string8 = string.substring(0, n4 + 1);
                if (!string8.equals(string7 = string2.substring(n2 - n4 - 1, n2))) continue;
                word8 = new Word(this.mono, string2.substring(0, n2 - n4 - 1), false);
                word7 = new Word(this.mono, string.substring(n4 + 1), false);
                overlapList.add(new Overlap(word8, word2, word2, word7));
                break;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                string8 = string.substring(n - n4 - 1, n);
                if (!string8.equals(string7 = string2.substring(0, n4 + 1))) continue;
                word8 = new Word(this.mono, string2.substring(n4 + 1), false);
                word7 = new Word(this.mono, string.substring(0, n - n4 - 1), false);
                overlapList.add(new Overlap(word2, word8, word7, word2));
                break;
            }
        } else {
            Word word9;
            Word word10;
            String string9;
            String string10;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                string10 = string.substring(n - n5 - 1, n);
                if (!string10.equals(string9 = string2.substring(0, n5 + 1))) continue;
                word10 = new Word(this.mono, string2.substring(n5 + 1), false);
                word9 = new Word(this.mono, string.substring(0, n - n5 - 1), false);
                overlapList.add(new Overlap(word2, word10, word9, word2));
                break;
            }
            for (n5 = 0; n5 < n; ++n5) {
                string10 = string.substring(0, n5 + 1);
                if (!string10.equals(string9 = string2.substring(n2 - n5 - 1, n2))) continue;
                word10 = new Word(this.mono, string2.substring(0, n2 - n5 - 1), false);
                word9 = new Word(this.mono, string.substring(n5 + 1), false);
                overlapList.add(new Overlap(word10, word2, word2, word9));
                break;
            }
        }
        return overlapList;
    }

    public Word lcm(Word word) {
        OverlapList overlapList = this.overlap(word);
        if (overlapList.ols.isEmpty()) {
            return null;
        }
        Overlap overlap = overlapList.ols.get(0);
        Word word2 = overlap.l1.multiply(this).multiply(overlap.r1);
        return word2;
    }
}

