/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.WordReduction;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.Overlap;
import edu.jas.poly.OverlapList;
import edu.jas.poly.Word;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class WordReductionAbstract<C extends RingElem<C>>
implements WordReduction<C> {
    private static final Logger logger = Logger.getLogger(WordReductionAbstract.class);

    @Override
    public List<GenWordPolynomial<C>> SPolynomials(GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>();
        if (genWordPolynomial2 == null || genWordPolynomial2.isZERO()) {
            if (genWordPolynomial == null) {
                arrayList.add(genWordPolynomial2);
                return arrayList;
            }
            arrayList.add((GenWordPolynomial<C>)genWordPolynomial.ring.getZERO());
            return arrayList;
        }
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            arrayList.add((GenWordPolynomial<C>)genWordPolynomial2.ring.getZERO());
            return arrayList;
        }
        Map.Entry<Word, C> entry = genWordPolynomial.leadingMonomial();
        Map.Entry<Word, C> entry2 = genWordPolynomial2.leadingMonomial();
        Word word = entry.getKey();
        Word word2 = entry2.getKey();
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        OverlapList overlapList = word.overlap(word2);
        if (overlapList.ols.isEmpty()) {
            return arrayList;
        }
        for (Overlap overlap : overlapList.ols) {
            GenWordPolynomial<RingElem> genWordPolynomial3 = this.SPolynomial(overlap, ringElem2, genWordPolynomial, ringElem, genWordPolynomial2);
            arrayList.add(genWordPolynomial3);
        }
        return arrayList;
    }

    @Override
    public GenWordPolynomial<C> SPolynomial(C c, Word word, GenWordPolynomial<C> genWordPolynomial, Word word2, C c2, Word word3, GenWordPolynomial<C> genWordPolynomial2, Word word4) {
        RingElem ringElem = (RingElem)genWordPolynomial.ring.coFac.getONE();
        GenWordPolynomial<RingElem> genWordPolynomial3 = genWordPolynomial.multiply((RingElem)c, word, ringElem, word2);
        GenWordPolynomial<RingElem> genWordPolynomial4 = genWordPolynomial2.multiply((RingElem)c2, word3, ringElem, word4);
        GenWordPolynomial<GenWordPolynomial<RingElem>> genWordPolynomial5 = genWordPolynomial3.subtract((RingElem)genWordPolynomial4);
        return genWordPolynomial5;
    }

    public GenWordPolynomial<C> SPolynomial(Overlap overlap, C c, GenWordPolynomial<C> genWordPolynomial, C c2, GenWordPolynomial<C> genWordPolynomial2) {
        RingElem ringElem = (RingElem)genWordPolynomial.ring.coFac.getONE();
        GenWordPolynomial<RingElem> genWordPolynomial3 = genWordPolynomial.multiply((RingElem)c, overlap.l1, ringElem, overlap.r1);
        GenWordPolynomial<RingElem> genWordPolynomial4 = genWordPolynomial2.multiply((RingElem)c2, overlap.l2, ringElem, overlap.r2);
        GenWordPolynomial<GenWordPolynomial<RingElem>> genWordPolynomial5 = genWordPolynomial3.subtract((RingElem)genWordPolynomial4);
        return genWordPolynomial5;
    }

    @Override
    public List<GenWordPolynomial<C>> normalform(List<GenWordPolynomial<C>> list, List<GenWordPolynomial<C>> list2) {
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list2;
        }
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>();
        for (GenWordPolynomial<C> genWordPolynomial : list2) {
            genWordPolynomial = this.normalform(list, genWordPolynomial);
            arrayList.add(genWordPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isTopReducible(List<GenWordPolynomial<C>> list, GenWordPolynomial<C> genWordPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        Word word = genWordPolynomial.leadingWord();
        for (GenWordPolynomial<C> genWordPolynomial2 : list) {
            bl = word.multipleOf(genWordPolynomial2.leadingWord());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReducible(List<GenWordPolynomial<C>> list, GenWordPolynomial<C> genWordPolynomial) {
        return !this.isNormalform(list, genWordPolynomial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNormalform(List<GenWordPolynomial<C>> wordArray, GenWordPolynomial<C> genWordPolynomial) {
        if (wordArray == null || wordArray.isEmpty()) {
            return true;
        }
        if (genWordPolynomial == null || genWordPolynomial.isZERO()) {
            return true;
        }
        Word[] wordArray2 = wordArray;
        synchronized (wordArray) {
            int n;
            int n2 = wordArray.size();
            GenWordPolynomial[] genWordPolynomialArray = new GenWordPolynomial[n2];
            for (int i = 0; i < wordArray.size(); ++i) {
                genWordPolynomialArray[i] = wordArray.get(i);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            wordArray2 = new Word[n2];
            GenWordPolynomial[] genWordPolynomialArray2 = new GenWordPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                genWordPolynomialArray2[n] = genWordPolynomialArray[n];
                Map.Entry entry = genWordPolynomialArray2[n].leadingMonomial();
                if (entry == null) continue;
                genWordPolynomialArray2[n3] = genWordPolynomialArray2[n];
                wordArray2[n3] = entry.getKey();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            for (Word word : genWordPolynomial.getMap().keySet()) {
                for (n = 0; n < n2; ++n) {
                    bl = word.multipleOf(wordArray2[n]);
                    if (!bl) continue;
                    return false;
                }
            }
            return true;
        }
    }

    @Override
    public boolean isNormalform(List<GenWordPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        LinkedList<GenWordPolynomial<C>> linkedList = new LinkedList<GenWordPolynomial<C>>(list);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            GenWordPolynomial genWordPolynomial = (GenWordPolynomial)linkedList.remove(i);
            if (!this.isNormalform(linkedList, genWordPolynomial)) {
                return false;
            }
            linkedList.add(genWordPolynomial);
        }
        return true;
    }

    @Override
    public List<GenWordPolynomial<C>> irreducibleSet(List<GenWordPolynomial<C>> list) {
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>();
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            if (genWordPolynomial.length() == 0) continue;
            if ((genWordPolynomial = genWordPolynomial.monic()).isONE()) {
                arrayList.clear();
                arrayList.add(genWordPolynomial);
                return arrayList;
            }
            arrayList.add(genWordPolynomial);
        }
        int n = arrayList.size();
        if (n <= 1) {
            return arrayList;
        }
        int n2 = 0;
        logger.debug((Object)"irr = ");
        while (n2 != n) {
            GenWordPolynomial<C> genWordPolynomial = arrayList.remove(0);
            Word word = genWordPolynomial.leadingWord();
            genWordPolynomial = this.normalform(arrayList, genWordPolynomial);
            logger.debug((Object)String.valueOf(n2));
            if (genWordPolynomial.length() == 0) {
                if (--n > 1) continue;
                return arrayList;
            }
            Word word2 = genWordPolynomial.leadingWord();
            if (word2.signum() == 0) {
                arrayList = new ArrayList();
                arrayList.add(genWordPolynomial.monic());
                return arrayList;
            }
            if (word.equals(word2)) {
                ++n2;
            } else {
                n2 = 0;
                genWordPolynomial = genWordPolynomial.monic();
            }
            arrayList.add(genWordPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isReductionNF(List<GenWordPolynomial<C>> list, List<GenWordPolynomial<C>> list2, List<GenWordPolynomial<C>> list3, GenWordPolynomial<C> genWordPolynomial, GenWordPolynomial<C> genWordPolynomial2) {
        int n;
        if (list == null && list2 == null && list3 == null) {
            if (genWordPolynomial == null) {
                return genWordPolynomial2 == null;
            }
            return genWordPolynomial.equals(genWordPolynomial2);
        }
        if (list == null || list2 == null || list3 == null) {
            return false;
        }
        if (list.size() != list3.size() || list2.size() != list3.size()) {
            return false;
        }
        GenWordPolynomial<GenWordPolynomial<Object>> genWordPolynomial3 = genWordPolynomial2;
        for (n = 0; n < list3.size(); ++n) {
            GenWordPolynomial<C> genWordPolynomial4 = list.get(n);
            GenWordPolynomial<C> genWordPolynomial5 = list2.get(n);
            GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial6 = list3.get(n);
            if (genWordPolynomial4 == null || genWordPolynomial5 == null || genWordPolynomial6 == null) continue;
            genWordPolynomial3 = genWordPolynomial3 == null ? genWordPolynomial6.multiply(genWordPolynomial4, genWordPolynomial5) : genWordPolynomial3.sum((GenWordPolynomial<Object>)genWordPolynomial6.multiply(genWordPolynomial4, genWordPolynomial5));
        }
        if (genWordPolynomial3 == null) {
            if (genWordPolynomial == null) {
                return true;
            }
            return genWordPolynomial.isZERO();
        }
        GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial7 = genWordPolynomial3.subtract((GenWordPolynomial<Object>)genWordPolynomial);
        n = genWordPolynomial7.isZERO() ? 1 : 0;
        if (n == 0) {
            logger.info((Object)("t = " + genWordPolynomial3));
            logger.info((Object)("a = " + genWordPolynomial));
            logger.info((Object)("t-a = " + genWordPolynomial7));
        }
        return n != 0;
    }
}

