/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class PowerSetIterator<E>
implements Iterator<List<E>> {
    public final List<E> set;
    final List<E> rest;
    final E current;
    private PowerSetIterator<E> recIter;
    Mode mode;

    public PowerSetIterator(List<E> list) {
        this.set = list;
        if (list == null || list.size() == 0) {
            this.current = null;
            this.recIter = null;
            this.rest = null;
            this.mode = Mode.first;
            return;
        }
        this.mode = Mode.copy;
        this.current = this.set.get(0);
        this.rest = new LinkedList<E>(this.set);
        this.rest.remove(0);
        this.recIter = new PowerSetIterator<E>(this.rest);
    }

    @Override
    public boolean hasNext() {
        if (this.mode == Mode.first) {
            return true;
        }
        if (this.recIter == null) {
            return false;
        }
        return this.recIter.hasNext() || this.mode == Mode.copy;
    }

    @Override
    public List<E> next() {
        if (this.mode == Mode.first) {
            this.mode = Mode.done;
            LinkedList linkedList = new LinkedList();
            return linkedList;
        }
        if (this.mode == Mode.extend && this.recIter.hasNext()) {
            LinkedList<E> linkedList = new LinkedList<E>(this.recIter.next());
            linkedList.add(this.current);
            return linkedList;
        }
        if (this.mode == Mode.copy) {
            if (this.recIter.hasNext()) {
                return this.recIter.next();
            }
            this.mode = Mode.extend;
            this.recIter = new PowerSetIterator<E>(this.rest);
            return this.next();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove subsets");
    }

    static enum Mode {
        copy,
        extend,
        first,
        done;

    }
}

