/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimalComplex;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigDecimalComplexTest
extends TestCase {
    BigDecimalComplex a;
    BigDecimalComplex b;
    BigDecimalComplex c;
    BigDecimalComplex d;
    BigDecimalComplex e;
    BigDecimalComplex fac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigDecimalComplexTest.suite());
    }

    public BigDecimalComplexTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigDecimalComplexTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new BigDecimalComplex();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstants() {
        this.a = BigDecimalComplex.ZERO;
        this.b = BigDecimalComplex.ONE;
        this.c = this.b.subtract(this.b);
        BigDecimalComplexTest.assertEquals((String)"1-1 == 0", (Object)this.c, (Object)this.a);
        BigDecimalComplexTest.assertTrue((String)"1-1 == 0", (boolean)this.c.isZERO());
        BigDecimalComplexTest.assertTrue((String)"1 == 1", (boolean)this.b.isONE());
        this.c = this.a.subtract(this.a);
        BigDecimalComplexTest.assertEquals((String)"0-0 == 0", (Object)this.c, (Object)this.a);
    }

    public void testConstructor() {
        this.a = new BigDecimalComplex("6.8");
        this.b = new BigDecimalComplex("3.4");
        this.b = this.b.sum(this.b);
        BigDecimalComplexTest.assertEquals((String)"6.8 == 3.4+3.4", (Object)this.a, (Object)this.b);
        this.a = new BigDecimalComplex("3.4 i 4.5");
        this.b = new BigDecimalComplex("-3.4 i -4.5");
        BigDecimalComplexTest.assertEquals((String)"3.4 + i 4.5 ", (Object)this.a, (Object)this.b.negate());
        String string = "6.1111111111111111111111111111111111111111111";
        this.a = new BigDecimalComplex(string);
        String string2 = this.a.toString();
        BigDecimalComplexTest.assertEquals((String)"stringConstr == toString", (String)string, (String)string2);
        this.a = new BigDecimalComplex(1L);
        this.b = new BigDecimalComplex(-1L);
        this.c = this.b.sum(this.a);
        BigDecimalComplexTest.assertTrue((String)"1 == 1", (boolean)this.a.isONE());
        BigDecimalComplexTest.assertEquals((String)"1+(-1) == 0", (Object)this.c, (Object)BigDecimalComplex.ZERO);
    }

    public void testRandom() {
        this.a = this.fac.random(500);
        this.b = new BigDecimalComplex(this.a.getRe(), this.a.getIm());
        this.c = this.b.subtract(this.a);
        BigDecimalComplexTest.assertEquals((String)"a-b == 0", (Object)this.c, (Object)BigDecimalComplex.ZERO);
        this.d = new BigDecimalComplex(this.b.getRe(), this.b.getIm());
        BigDecimalComplexTest.assertEquals((String)"sign(a-a) == 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = this.fac.random(10);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigDecimalComplexTest.assertEquals((String)"a+a-a == a", (Object)this.c, (Object)this.a);
        BigDecimalComplexTest.assertEquals((String)"a+a-a == a", (int)0, (int)this.c.compareTo(this.a));
        this.b = this.fac.random(5);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        BigDecimalComplexTest.assertEquals((String)("a+b == b+a: " + this.c.subtract(this.d)), (Object)this.c, (Object)this.d);
        this.d = this.a.sum(BigDecimalComplex.ZERO);
        BigDecimalComplexTest.assertEquals((String)"a+0 == a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(BigDecimalComplex.ZERO);
        BigDecimalComplexTest.assertEquals((String)"a-0 == a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        BigDecimalComplexTest.assertEquals((String)"a-a == 0", (Object)this.d, (Object)BigDecimalComplex.ZERO);
    }

    public void testMultiplication() {
        this.a = this.fac.random(5);
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        BigDecimalComplexTest.assertEquals((String)("a*a/a == a: " + this.c.subtract(this.a)), (Object)this.c, (Object)this.a);
        BigDecimalComplexTest.assertEquals((String)("a*a/a == a: " + this.c.subtract(this.a)), (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(BigDecimalComplex.ONE);
        BigDecimalComplexTest.assertEquals((String)"a*1 == a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(BigDecimalComplex.ONE);
        BigDecimalComplexTest.assertEquals((String)"a/1 == a", (Object)this.d, (Object)this.a);
        this.b = this.fac.random(5);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigDecimalComplexTest.assertEquals((String)("a*b == b*a: " + this.c.subtract(this.d)), (Object)this.c, (Object)this.d);
        this.a = this.fac.random(5);
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        BigDecimalComplexTest.assertTrue((String)("a*1/a == 1: " + this.c), (this.c.compareTo(this.fac.getONE()) == 0 ? 1 : 0) != 0);
    }

    public void testDistributive() {
        this.a = this.fac.random(50);
        this.b = this.fac.random(50);
        this.c = this.fac.random(50);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigDecimalComplexTest.assertEquals((String)"a(b+c) == ab+ac", (Object)this.d, (Object)this.e);
    }

    public void testNorm() {
        this.a = this.fac.random(5);
        this.b = this.a.norm();
        this.c = this.a.abs();
        this.d = this.c.multiply(this.c);
        this.e = this.b.subtract(this.d);
        BigDecimalComplexTest.assertTrue((String)("||a|| == |a|*|a|: " + this.e), (this.b.compareTo(this.d) == 0 ? 1 : 0) != 0);
    }
}

