/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.IdealWithUniv;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.ResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.Interval;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealRootTuple;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class RealAlgebraicRing<C extends GcdRingElem<C> & Rational>
implements RingFactory<RealAlgebraicNumber<C>> {
    final IdealWithUniv<C> univs;
    final ResidueRing<C> algebraic;
    RealRootTuple<C> root;
    public final edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<C>> realRing;
    protected C eps;
    public final int PRECISION = 9;
    private static final Logger logger = Logger.getLogger(RealAlgebraicRing.class);

    public RealAlgebraicRing(IdealWithUniv<C> idealWithUniv, ResidueRing<C> residueRing, RealRootTuple<C> realRootTuple) {
        this.univs = idealWithUniv;
        this.algebraic = residueRing;
        this.root = realRootTuple;
        if (this.algebraic.characteristic().signum() > 0) {
            throw new IllegalArgumentException("characteristic not zero");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)idealWithUniv.ideal.list.ring.coFac.fromInteger(10L);
        gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
        gcdRingElem = Power.positivePower(gcdRingElem, 9L);
        this.eps = gcdRingElem;
        ElemFactory elemFactory = this.root.tuple.get(0).factory();
        ElemFactory elemFactory2 = this.root.tuple.get(1).factory();
        GenPolynomial genPolynomial = PolyUtil.selectWithVariable(this.univs.ideal.list.list, 0);
        if (genPolynomial == null) {
            throw new RuntimeException("no polynomial found in 0 of  " + this.univs.ideal);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(elemFactory, genPolynomialRing2);
        GenPolynomial genPolynomial3 = PolyUtilRoot.convertRecursiveToAlgebraicCoefficients(genPolynomialRing3, genPolynomial2);
        Interval interval = ((edu.jas.root.RealAlgebraicRing)elemFactory2).getRoot();
        edu.jas.root.RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber = ((edu.jas.root.RealAlgebraicNumber)((edu.jas.root.RealAlgebraicRing)elemFactory).getZERO()).sum((GcdRingElem)interval.left);
        edu.jas.root.RealAlgebraicNumber<GcdRingElem> realAlgebraicNumber2 = ((edu.jas.root.RealAlgebraicNumber)((edu.jas.root.RealAlgebraicRing)elemFactory).getZERO()).sum((GcdRingElem)interval.right);
        Interval<edu.jas.root.RealAlgebraicNumber<GcdRingElem>> interval2 = new Interval<edu.jas.root.RealAlgebraicNumber<GcdRingElem>>(realAlgebraicNumber, realAlgebraicNumber2);
        edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<GcdRingElem>> realAlgebraicRing = new edu.jas.root.RealAlgebraicRing<edu.jas.root.RealAlgebraicNumber<GcdRingElem>>(genPolynomial3, interval2);
        logger.info((Object)("realRing = " + realAlgebraicRing));
        this.realRing = realAlgebraicRing;
    }

    public RealAlgebraicRing(IdealWithUniv<C> idealWithUniv, RealRootTuple<C> realRootTuple) {
        this(idealWithUniv, new ResidueRing(idealWithUniv.ideal), realRootTuple);
    }

    public RealAlgebraicRing(IdealWithUniv<C> idealWithUniv, RealRootTuple<C> realRootTuple, boolean bl) {
        this(idealWithUniv, new ResidueRing(idealWithUniv.ideal, bl), realRootTuple);
    }

    public synchronized void setRoot(RealRootTuple<C> realRootTuple) {
        this.root = realRootTuple;
    }

    public synchronized RealRootTuple<C> getRoot() {
        return this.root;
    }

    public synchronized C getEps() {
        return this.eps;
    }

    public synchronized void setEps(C c) {
        this.eps = c;
    }

    public synchronized void setEps(BigRational bigRational) {
        edu.jas.root.RealAlgebraicRing realAlgebraicRing = (edu.jas.root.RealAlgebraicRing)this.realRing.algebraic.ring.coFac;
        this.eps = (GcdRingElem)realAlgebraicRing.algebraic.ring.coFac.parse(bigRational.toString());
    }

    @Override
    public boolean isFinite() {
        return this.realRing.isFinite();
    }

    @Override
    public RealAlgebraicNumber<C> copy(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber(this, realAlgebraicNumber.number);
    }

    @Override
    public RealAlgebraicNumber<C> getZERO() {
        return new RealAlgebraicNumber(this, this.realRing.getZERO());
    }

    @Override
    public RealAlgebraicNumber<C> getONE() {
        return new RealAlgebraicNumber(this, this.realRing.getONE());
    }

    @Override
    public List<RealAlgebraicNumber<C>> generators() {
        List<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>> list = this.realRing.generators();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>(list.size());
        for (edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> realAlgebraicNumber : list) {
            arrayList.add(((RealAlgebraicNumber)this.getZERO()).sum(realAlgebraicNumber));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.realRing.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.realRing.isAssociative();
    }

    @Override
    public boolean isField() {
        return this.realRing.isField();
    }

    public void setField(boolean bl) {
        this.realRing.setField(bl);
    }

    @Override
    public BigInteger characteristic() {
        return this.realRing.characteristic();
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(BigInteger bigInteger) {
        return new RealAlgebraicNumber(this, this.realRing.fromInteger(bigInteger));
    }

    @Override
    public RealAlgebraicNumber<C> fromInteger(long l) {
        return new RealAlgebraicNumber(this, this.realRing.fromInteger(l));
    }

    public String toString() {
        return "RealAlgebraicRing[ " + this.realRing.toString() + " in " + this.root + " | isField=" + this.realRing.isField() + ", algebraic.ideal=" + this.algebraic.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RealRecN( " + this.realRing.toScript() + ", " + this.root.toScript() + " )";
    }

    public boolean equals(Object object) {
        if (!(object instanceof RealAlgebraicRing)) {
            return false;
        }
        RealAlgebraicRing realAlgebraicRing = null;
        try {
            realAlgebraicRing = (RealAlgebraicRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (realAlgebraicRing == null) {
            return false;
        }
        return this.realRing.equals(realAlgebraicRing.realRing) && this.root.equals(realAlgebraicRing.root);
    }

    public int hashCode() {
        return 37 * this.realRing.hashCode() + this.root.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> random(int n) {
        return new RealAlgebraicNumber(this, this.realRing.random(n));
    }

    @Override
    public RealAlgebraicNumber<C> random(int n, Random random) {
        return new RealAlgebraicNumber(this, this.realRing.random(n, random));
    }

    @Override
    public RealAlgebraicNumber<C> parse(String string) {
        return new RealAlgebraicNumber(this, this.realRing.parse(string));
    }

    @Override
    public RealAlgebraicNumber<C> parse(Reader reader) {
        return new RealAlgebraicNumber(this, this.realRing.parse(reader));
    }
}

