/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistThreadPool;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import java.io.IOException;
import org.apache.log4j.Logger;

class DistPoolThread
extends Thread {
    final DistThreadPool pool;
    final ExecutableChannels ec;
    final int myId;
    private static final Logger logger = Logger.getLogger(DistPoolThread.class);
    private final boolean debug = logger.isDebugEnabled();
    boolean working = false;

    public DistPoolThread(DistThreadPool distThreadPool, ExecutableChannels executableChannels, int n) {
        this.pool = distThreadPool;
        this.ec = executableChannels;
        this.myId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)("ready, myId = " + this.myId));
        int n = 0;
        long l = 0L;
        boolean bl = true;
        while (bl) {
            try {
                logger.debug((Object)"looking for a job");
                Runnable runnable = this.pool.getJob();
                this.working = true;
                if (this.debug) {
                    logger.info((Object)("working " + this.myId + " on " + runnable));
                }
                long l2 = System.currentTimeMillis();
                try {
                    if (runnable instanceof ShutdownRequest) {
                        this.ec.send(this.myId, "Stop");
                    } else {
                        this.ec.send(this.myId, runnable);
                    }
                    if (this.debug) {
                        logger.info((Object)("send " + this.myId + " at " + this.ec + " send job " + runnable));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    logger.info((Object)("error send " + this.myId + " at " + this.ec + " e = " + iOException));
                    this.working = false;
                }
                Object object = null;
                try {
                    if (this.working) {
                        logger.info((Object)("waiting " + this.myId + " on " + runnable));
                        object = this.ec.receive(this.myId);
                        if (this.debug) {
                            logger.info((Object)("receive " + this.myId + " at " + this.ec + " send job " + runnable + " received " + object));
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.info((Object)("receive exception " + this.myId + " send job " + runnable + ", " + iOException));
                    bl = false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.info((Object)("receive exception " + this.myId + " send job " + runnable + ", " + classNotFoundException));
                    bl = false;
                }
                finally {
                    if (this.debug) {
                        logger.info((Object)("receive finally " + this.myId + " at " + this.ec + " send job " + runnable + " received " + object + " running " + bl));
                    }
                }
                this.working = false;
                l += System.currentTimeMillis() - l2;
                ++n;
                if (!this.debug) continue;
                logger.info((Object)("done " + this.myId + " with " + object));
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                Thread.currentThread().interrupt();
            }
        }
        logger.info((Object)("terminated " + this.myId + " , done " + n + " jobs in " + l + " milliseconds"));
    }
}

