/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SolvableGroebnerBasePseudoSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableGroebnerBasePseudoSeqTest
extends TestCase {
    GenSolvablePolynomial<BigInteger> a;
    GenSolvablePolynomial<BigInteger> b;
    GenSolvablePolynomial<BigInteger> c;
    GenSolvablePolynomial<BigInteger> d;
    GenSolvablePolynomial<BigInteger> e;
    List<GenSolvablePolynomial<BigInteger>> L;
    PolynomialList<BigInteger> F;
    PolynomialList<BigInteger> G;
    GenSolvablePolynomialRing<BigInteger> ring;
    SolvableGroebnerBaseAbstract<BigInteger> sbb;
    BigInteger cfac;
    TermOrder tord;
    RelationTable<BigInteger> table;
    int rl = 4;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableGroebnerBasePseudoSeqTest.suite());
        ComputerThreads.terminate();
    }

    public SolvableGroebnerBasePseudoSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableGroebnerBasePseudoSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigInteger(9L);
        this.tord = new TermOrder();
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.ring = new GenSolvablePolynomialRing<BigInteger>(this.cfac, this.tord, stringArray);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.sbb = new SolvableGroebnerBasePseudoSeq<BigInteger>(this.cfac);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.table = null;
        this.cfac = null;
        this.sbb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testWeylSequentialGBase() {
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testSequentialTSGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testWeylSequentialTSGBase() {
        WeylRelations<BigInteger> weylRelations = new WeylRelations<BigInteger>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigInteger>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }
}

