/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Combinatoric;
import edu.jas.util.KsubSet;
import edu.jas.util.PowerSet;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PowerSetTest
extends TestCase {
    BigInteger ai;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PowerSetTest.suite());
    }

    public PowerSetTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PowerSetTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.ai = null;
    }

    protected void tearDown() {
        this.ai = null;
    }

    public void testIterator() {
        this.ai = new BigInteger();
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(this.ai.random(7));
        }
        PowerSet powerSet = new PowerSet(arrayList);
        long l = 0L;
        for (List list : powerSet) {
            if (l < 0L) {
                System.out.println("subs = " + list);
            }
            if (list == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() >= 0 ? 1 : 0) != 0);
            ++l;
        }
        long l2 = 1L;
        for (int i = 0; i < 10; ++i) {
            l2 *= 2L;
        }
        PowerSetTest.assertEquals((String)"size(ps) == 2**N ", (long)l, (long)l2);
    }

    public void noTestKSubsetIterator() {
        this.ai = new BigInteger();
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(this.ai.random(7));
        }
        System.out.println("list = " + arrayList);
        KsubSet ksubSet = new KsubSet(arrayList, 0);
        long l = 0L;
        for (List list : ksubSet) {
            if (l >= 0L) {
                System.out.println("subs = " + list);
            }
            if (list == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() == 0 ? 1 : 0) != 0);
            ++l;
        }
        long l2 = Combinatoric.binCoeff(10, 0).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + l2 + " "), (long)l, (long)l2);
        ksubSet = new KsubSet(arrayList, 1);
        l = 0L;
        for (List list : ksubSet) {
            if (l >= 0L) {
                System.out.println("subs = " + list);
            }
            if (list == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() == 1 ? 1 : 0) != 0);
            ++l;
        }
        l2 = Combinatoric.binCoeff(10, 1).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + l2 + " "), (long)l, (long)l2);
        ksubSet = new KsubSet(arrayList, 2);
        l = 0L;
        for (List list : ksubSet) {
            if (l >= 0L) {
                System.out.println("subs = " + list);
            }
            if (list == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() == 2 ? 1 : 0) != 0);
            ++l;
        }
        l2 = Combinatoric.binCoeff(10, 2).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + l2 + " "), (long)l, (long)l2);
        ksubSet = new KsubSet(arrayList, 3);
        l = 0L;
        for (List list : ksubSet) {
            if (l >= 0L) {
                System.out.println("subs = " + list);
            }
            if (list == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() == 3 ? 1 : 0) != 0);
            ++l;
        }
        l2 = Combinatoric.binCoeff(10, 3).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + l2 + " "), (long)l, (long)l2);
    }

    public void testAnyKSubsetIterator() {
        int n;
        this.ai = new BigInteger();
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        for (n = 0; n < 10; ++n) {
            arrayList.add(this.ai.random(7));
        }
        for (n = 0; n <= 10; ++n) {
            KsubSet ksubSet = new KsubSet(arrayList, n);
            long l = 0L;
            for (List list : ksubSet) {
                if (l < 0L) {
                    System.out.println("subs = " + list);
                }
                if (list == null) continue;
                PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (list.size() == n ? 1 : 0) != 0);
                ++l;
            }
            long l2 = Combinatoric.binCoeff(10, n).getVal().longValue();
            PowerSetTest.assertEquals((String)("size(ks) == " + l2 + " "), (long)l, (long)l2);
        }
    }
}

