/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.JunitClientHybrid;
import edu.jas.gb.OrderedSyzPairlist;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBaseDistHybridTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bbseq;
    GroebnerBaseDistributedHybrid<BigRational> bbdisthybs;
    GroebnerBaseDistributedHybrid<BigRational> bbdisthyb;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 4;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;
    int threadsPerNode = 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBaseDistHybridTest.suite());
    }

    public GroebnerBaseDistHybridTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseDistHybridTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbdisthybs = null;
        this.bbdisthyb = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbdisthybs.terminate();
        this.bbdisthybs = null;
        this.bbdisthyb.terminate();
        this.bbdisthyb = null;
        ComputerThreads.terminate();
    }

    Thread[] startThreads() {
        Thread[] threadArray = new Thread[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            threadArray[i] = new Thread(new JunitClientHybrid(this.threadsPerNode, this.host, this.port));
            threadArray[i].start();
        }
        return threadArray;
    }

    void stopThreads(Thread[] threadArray) {
        for (int i = 0; i < this.threads; ++i) {
            try {
                while (threadArray[i].isAlive()) {
                    threadArray[i].interrupt();
                    threadArray[i].join(100L);
                }
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void testDistributedHybridGBase() {
        this.bbdisthybs = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, new OrderedSyzPairlist(), this.port);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        Thread[] threadArray = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        threadArray = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        threadArray = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        threadArray = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbseq.isGB(this.L));
        GroebnerBaseDistHybridTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        threadArray = this.startThreads();
        this.L = this.bbdisthyb.GB(this.L);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbseq.isGB(this.L));
    }

    public void testTrinks7GBase() {
        this.bbdisthybs = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, new OrderedSyzPairlist(), this.port);
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistHybridTest.fail((String)("" + iOException));
        }
        Thread[] threadArray = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testTrinks7GBase_t1_p4() {
        this.threads = 1;
        this.threadsPerNode = 4;
        this.bbdisthybs = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, new OrderedSyzPairlist(), this.port);
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistHybridTest.fail((String)("" + iOException));
        }
        Thread[] threadArray = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testTrinks7GBase_t4_p1() {
        this.threads = 4;
        this.threadsPerNode = 1;
        this.bbdisthybs = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, new OrderedSyzPairlist(), this.port);
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistHybridTest.fail((String)("" + iOException));
        }
        Thread[] threadArray = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }

    public void testTrinks7GBase_t2_p2() {
        this.threads = 2;
        this.threadsPerNode = 4;
        this.bbdisthybs = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, this.port);
        this.bbdisthyb = new GroebnerBaseDistributedHybrid(this.threads, this.threadsPerNode, new OrderedSyzPairlist(), this.port);
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (IOException iOException) {
            GroebnerBaseDistHybridTest.fail((String)("" + iOException));
        }
        Thread[] threadArray = this.startThreads();
        this.G = this.bbdisthyb.GB(this.F.list);
        this.stopThreads(threadArray);
        GroebnerBaseDistHybridTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbseq.isGB(this.G));
        GroebnerBaseDistHybridTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

