/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDTimingTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigInteger> ufd_si;
    GreatestCommonDivisorAbstract<BigInteger> ufd_pp;
    GreatestCommonDivisorSubres<BigInteger> ufd_sr;
    GreatestCommonDivisorAbstract<BigInteger> ufd_mosi;
    GreatestCommonDivisorAbstract<BigInteger> ufd_moevsi;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    BigInteger ai;
    BigInteger bi;
    BigInteger ci;
    BigInteger di;
    BigInteger ei;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    GenPolynomial<GenPolynomial<BigInteger>> ar;
    GenPolynomial<GenPolynomial<BigInteger>> br;
    GenPolynomial<GenPolynomial<BigInteger>> cr;
    GenPolynomial<GenPolynomial<BigInteger>> dr;
    GenPolynomial<GenPolynomial<BigInteger>> er;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDTimingTest.suite());
    }

    public GCDTimingTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDTimingTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd_si = new GreatestCommonDivisorSimple<BigInteger>();
        this.ufd_pp = new GreatestCommonDivisorPrimitive<BigInteger>();
        this.ufd_sr = new GreatestCommonDivisorSubres();
        this.ufd_mosi = new GreatestCommonDivisorModular(true);
        this.ufd_moevsi = new GreatestCommonDivisorModular();
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.ufd_si = null;
        this.ufd_pp = null;
        this.ufd_sr = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testDummy() {
        GCDTimingTest.assertTrue((String)"ufd_pp != null", (this.ufd_pp != null ? 1 : 0) != 0);
    }

    public void xtestBaseGcd() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        for (int i = 0; i < 10; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.c.multiply((BigInteger)((Object)this.dfac.univariate(0)));
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDTimingTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            System.out.println("\ndegrees: a = " + this.a.degree() + ", b = " + this.b.degree() + ", c = " + this.c.degree());
            long l = System.currentTimeMillis();
            this.d = this.ufd_pp.baseGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            System.out.println("primitive prs     time = " + l);
            l = System.currentTimeMillis();
            this.d = this.ufd_sr.baseGcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            System.out.println("subsresultant prs time = " + l);
        }
    }

    public void xtestRecursiveGCD() {
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
        for (int i = 0; i < 5; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.cr.multiply((GenPolynomial<BigInteger>)this.rfac.univariate(0));
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDTimingTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigInteger>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigInteger>)this.cr);
            System.out.println("\ndegrees: a = " + this.ar.degree() + ", b = " + this.br.degree() + ", c = " + this.cr.degree());
            long l = System.currentTimeMillis();
            this.dr = this.ufd_si.recursiveUnivariateGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            System.out.println("simple prs        time = " + l);
            l = System.currentTimeMillis();
            this.dr = this.ufd_pp.recursiveUnivariateGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            System.out.println("primitive prs     time = " + l);
            l = System.currentTimeMillis();
            this.dr = this.ufd_sr.recursiveUnivariateGcd(this.ar, this.br);
            l = System.currentTimeMillis() - l;
            this.er = this.ufd_sr.recursivePseudoRemainder(this.dr, this.cr);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
            System.out.println("subresultant prs  time = " + l);
        }
    }

    public void xtestGCD() {
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 3, this.to);
        for (int i = 0; i < 5; ++i) {
            this.a = this.dfac.random(this.kl + i * 30, this.ll + i, 2 * this.el, this.q);
            this.b = this.dfac.random(this.kl + i * 30, this.ll + i, 2 * this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.ufd_pp.primitivePart(this.c).abs();
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDTimingTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigInteger)((Object)this.c));
            this.b = this.b.multiply((BigInteger)((Object)this.c));
            System.out.println("\ndegrees: a = " + this.a.degree() + ", b = " + this.b.degree() + ", c = " + this.c.degree());
            long l = System.currentTimeMillis();
            this.d = this.ufd_sr.gcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            System.out.println("subsresultant prs time = " + l);
            l = System.currentTimeMillis();
            this.d = this.ufd_mosi.gcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            System.out.println("modular simple    time = " + l);
            l = System.currentTimeMillis();
            this.d = this.ufd_moevsi.gcd(this.a, this.b);
            l = System.currentTimeMillis() - l;
            this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
            GCDTimingTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            System.out.println("modular eval      time = " + l);
        }
    }
}

