/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class MultiplicativeSetSquarefree<C extends GcdRingElem<C>>
extends MultiplicativeSet<C> {
    private static final Logger logger = Logger.getLogger(MultiplicativeSetSquarefree.class);
    protected final SquarefreeAbstract<C> engine;

    public MultiplicativeSetSquarefree(GenPolynomialRing<C> genPolynomialRing) {
        super(genPolynomialRing);
        this.engine = SquarefreeFactory.getImplementation(genPolynomialRing.coFac);
    }

    protected MultiplicativeSetSquarefree(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, SquarefreeAbstract<C> squarefreeAbstract) {
        super(genPolynomialRing, list);
        this.engine = squarefreeAbstract;
    }

    @Override
    public String toString() {
        return "MultiplicativeSetSquarefree" + this.mset;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiplicativeSetSquarefree)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public MultiplicativeSetSquarefree<C> add(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return this;
        }
        if (this.ring.coFac.isField()) {
            genPolynomial = genPolynomial.monic();
        }
        if (this.mset.size() == 0) {
            List<GenPolynomial<C>> list = this.engine.coPrimeSquarefree(genPolynomial, this.mset);
            if (this.ring.coFac.isField()) {
                list = PolyUtil.monic(list);
            }
            return new MultiplicativeSetSquarefree<C>(this.ring, list, this.engine);
        }
        GenPolynomial<C> genPolynomial2 = this.removeFactors(genPolynomial);
        if (genPolynomial2.isConstant()) {
            logger.info((Object)("skipped unit or constant = " + genPolynomial2));
            return this;
        }
        logger.info((Object)("added to squarefree mset = " + genPolynomial2));
        List<GenPolynomial<C>> list = this.engine.coPrimeSquarefree(genPolynomial2, this.mset);
        if (this.ring.coFac.isField()) {
            list = PolyUtil.monic(list);
        }
        return new MultiplicativeSetSquarefree<C>(this.ring, list, this.engine);
    }

    @Override
    public MultiplicativeSetSquarefree<C> replace(List<GenPolynomial<C>> list) {
        MultiplicativeSet multiplicativeSet = new MultiplicativeSetSquarefree<C>(this.ring);
        if (list == null || list.size() == 0) {
            return multiplicativeSet;
        }
        for (GenPolynomial<C> genPolynomial : list) {
            multiplicativeSet = multiplicativeSet.add((GenPolynomial)genPolynomial);
        }
        return multiplicativeSet;
    }
}

