/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocal;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.gbmod.SolvableSyzygySeq;
import edu.jas.gbufd.SGBFactory;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableLocalRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableLocal<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableLocal<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocalRing.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableIdeal<C> ideal;
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableSyzygyAbstract<C> engine;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected int isField = -1;

    public SolvableLocalRing(SolvableIdeal<C> solvableIdeal) {
        if (solvableIdeal == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ring = solvableIdeal.getRing();
        this.ideal = solvableIdeal.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            this.isField = 0;
            logger.warn((Object)"ideal not maximal");
        }
        this.engine = new SolvableSyzygySeq(this.ring.coFac);
        this.bb = SGBFactory.getImplementation(this.ring.coFac);
        logger.debug((Object)"solvable local ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableLocal<C> create(GenPolynomial<C> genPolynomial) {
        return new SolvableLocal(this, (GenSolvablePolynomial)genPolynomial);
    }

    @Override
    public SolvableLocal<C> create(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        return new SolvableLocal(this, (GenSolvablePolynomial)genPolynomial, (GenSolvablePolynomial)genPolynomial2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public SolvableLocal<C> copy(SolvableLocal<C> solvableLocal) {
        return new SolvableLocal(solvableLocal.ring, solvableLocal.num, solvableLocal.den, true);
    }

    @Override
    public SolvableLocal<C> getZERO() {
        return new SolvableLocal(this, this.ring.getZERO());
    }

    @Override
    public SolvableLocal<C> getONE() {
        return new SolvableLocal(this, this.ring.getONE());
    }

    @Override
    public List<SolvableLocal<C>> generators() {
        List list = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableLocal<C>> arrayList = new ArrayList<SolvableLocal<C>>(list.size() * 2 - 1);
        GenPolynomial genPolynomial = this.ring.getONE();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            SolvableLocal solvableLocal = new SolvableLocal(this, genSolvablePolynomial);
            arrayList.add(solvableLocal);
            if (genSolvablePolynomial.isONE() || this.ideal.contains(genSolvablePolynomial)) continue;
            solvableLocal = new SolvableLocal(this, genPolynomial, genSolvablePolynomial);
            arrayList.add(solvableLocal);
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableLocal<C>> list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SolvableLocal<C> solvableLocal = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                SolvableLocal<SolvableLocal<C>> solvableLocal2 = list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    SolvableLocal<SolvableLocal<SolvableLocal<C>>> solvableLocal3;
                    SolvableLocal<SolvableLocal<C>> solvableLocal4;
                    SolvableLocal<SolvableLocal<SolvableLocal<C>>> solvableLocal5 = list.get(k);
                    try {
                        solvableLocal4 = solvableLocal5.multiply(solvableLocal2).multiply((SolvableLocal<SolvableLocal<C>>)solvableLocal);
                        solvableLocal3 = solvableLocal5.multiply(solvableLocal2.multiply(solvableLocal));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    if (solvableLocal4.equals(solvableLocal3)) continue;
                    logger.info((Object)("Xk = " + solvableLocal5 + ", Xj = " + solvableLocal2 + ", Xi = " + solvableLocal));
                    logger.info((Object)("p = ( Xk * Xj ) * Xi = " + solvableLocal4));
                    logger.info((Object)("q = Xk * ( Xj * Xi ) = " + solvableLocal3));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableLocal<C> fromInteger(BigInteger bigInteger) {
        return new SolvableLocal(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public SolvableLocal<C> fromInteger(long l) {
        return new SolvableLocal(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "SolvableLocalRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SLC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof SolvableLocalRing)) {
            return false;
        }
        SolvableLocalRing solvableLocalRing = null;
        try {
            solvableLocalRing = (SolvableLocalRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (solvableLocalRing == null) {
            return false;
        }
        if (!this.ring.equals(solvableLocalRing.ring)) {
            return false;
        }
        return this.ideal.equals(solvableLocalRing.ideal);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public SolvableLocal<C> random(int n) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocal<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    public SolvableLocal<C> random(int n, int n2, int n3, float f) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n, n2, n3, f)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocal<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocal<C> random(int n, Random random) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        GenSolvablePolynomial<C> genSolvablePolynomial2 = ((GenSolvablePolynomial)this.ring.random(n, random)).monic();
        genSolvablePolynomial2 = this.ideal.normalform(genSolvablePolynomial2);
        do {
            genSolvablePolynomial = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((genSolvablePolynomial = this.ideal.normalform(genSolvablePolynomial)).isZERO());
        return new SolvableLocal<C>(this, genSolvablePolynomial2, genSolvablePolynomial, false);
    }

    @Override
    public SolvableLocal<C> parse(String string) {
        int n = string.indexOf("{");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf("}")) >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("|")) < 0) {
            GenPolynomial genPolynomial = this.ring.parse(string);
            return new SolvableLocal(this, genPolynomial);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        GenPolynomial genPolynomial = this.ring.parse(string2);
        GenPolynomial genPolynomial2 = this.ring.parse(string3);
        return new SolvableLocal(this, genPolynomial, genPolynomial2);
    }

    @Override
    public SolvableLocal<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '{', '}');
        return this.parse(string);
    }
}

