/*
 * Decompiled with CFR 0.152.
 */
package edu.mas.kern;

import edu.jas.arith.BigRational;
import edu.mas.kern.LIST;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LISTTest
extends TestCase {
    boolean timing = false;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LISTTest.suite());
    }

    public LISTTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(LISTTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testLISTinit() {
        LIST lIST = null;
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(lIST), (int)0);
        lIST = new LIST();
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(lIST), (int)0);
        lIST = new LIST(lIST.list);
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(lIST), (int)0);
    }

    public void testLISTcreate() {
        Integer n = 5;
        LIST<Integer> lIST = null;
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(lIST), (int)0);
        lIST = LIST.LIST1(n);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(lIST), (int)1);
        lIST = LIST.COMP(n, lIST);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        LIST<Integer> lIST2 = LIST.LIST2(n, n);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(lIST2));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        LISTTest.assertTrue((String)"a == b ", (boolean)LIST.EQUAL(lIST, lIST2));
    }

    public void testLISToper() {
        Integer n = 5;
        LIST<Integer> lIST = LIST.LIST1(n);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(lIST), (int)1);
        lIST = LIST.COMP(n, lIST);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        LIST<Integer> lIST2 = LIST.CINV(lIST);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(lIST2));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        LISTTest.assertTrue((String)"a == b ", (boolean)LIST.EQUAL(lIST, lIST2));
        LIST<Integer> lIST3 = LIST.INV(lIST);
        LISTTest.assertFalse((String)"c != () ", (boolean)LIST.isEmpty(lIST3));
        LISTTest.assertEquals((String)"len(c) == 2 ", (int)LIST.LENGTH(lIST3), (int)2);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(lIST, lIST3));
    }

    public void testLISTelems() {
        int n = 100;
        LIST<Integer> lIST = null;
        for (int i = 0; i < n; ++i) {
            Integer n2 = i;
            lIST = LIST.COMP(n2, lIST);
        }
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertEquals((String)("len(a) == " + n + " "), (int)LIST.LENGTH(lIST), (int)n);
        LIST<Integer> lIST2 = LIST.CINV(lIST);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(lIST2));
        LISTTest.assertEquals((String)("len(b) == " + n + " "), (int)LIST.LENGTH(lIST2), (int)n);
        lIST2 = LIST.INV(lIST2);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(lIST2));
        LISTTest.assertEquals((String)("len(b) == " + n + " "), (int)LIST.LENGTH(lIST2), (int)n);
        LISTTest.assertTrue((String)"a == INV(CINV(a)) ", (boolean)LIST.EQUAL(lIST, lIST2));
    }

    public void testLISTdestruct() {
        Integer n = 5;
        LIST<Integer> lIST = LIST.LIST1(n);
        LIST<Integer> lIST2 = LIST.LIST1(n);
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(lIST), (int)1);
        LISTTest.assertEquals((String)"len(b) == 1 ", (int)LIST.LENGTH(lIST2), (int)1);
        LIST.SRED(lIST, lIST2);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(lIST));
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(lIST2));
        LISTTest.assertEquals((String)"len(b) == 1 ", (int)LIST.LENGTH(lIST2), (int)1);
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        n = 7;
        LIST.SFIRST(lIST, n);
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(lIST), (int)2);
        LIST<Integer> lIST3 = LIST.COMP(n, lIST2);
        LISTTest.assertEquals((String)"len(c) == 2 ", (int)LIST.LENGTH(lIST3), (int)2);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(lIST, lIST3));
    }

    public void testLISTrecursive() {
        Integer n = 5;
        LIST<Integer> lIST = LIST.LIST1(n);
        LIST<LIST<Integer>> lIST2 = LIST.LIST2(lIST, lIST);
        LIST<LIST<LIST<Integer>>> lIST3 = LIST.LIST3(lIST2, lIST2, lIST2);
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(lIST), (int)1);
        LISTTest.assertEquals((String)"len(b) == 2 ", (int)LIST.LENGTH(lIST2), (int)2);
        LISTTest.assertEquals((String)"len(c) == 3 ", (int)LIST.LENGTH(lIST3), (int)3);
        LISTTest.assertEquals((String)"EXTENT(a) == 1 ", (int)LIST.EXTENT(lIST), (int)1);
        LISTTest.assertEquals((String)"EXTENT(b) == 2 ", (int)LIST.EXTENT(lIST2), (int)2);
        LISTTest.assertEquals((String)"EXTENT(c) == 6 ", (int)LIST.EXTENT(lIST3), (int)6);
        LISTTest.assertEquals((String)"ORDER(a) == 1 ", (int)LIST.ORDER(lIST), (int)1);
        LISTTest.assertEquals((String)"ORDER(b) == 2 ", (int)LIST.ORDER(lIST2), (int)2);
        LISTTest.assertEquals((String)"ORDER(c) == 3 ", (int)LIST.ORDER(lIST3), (int)3);
    }

    public void testLISTcontent() {
        BigRational bigRational;
        int n = 5000;
        BigRational bigRational2 = new BigRational(2L, 3L);
        LIST<BigRational> lIST = null;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            bigRational = bigRational2.random(5);
            lIST = LIST.COMP(bigRational, lIST);
        }
        long l2 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.comp = " + (l2 - l));
        }
        LISTTest.assertEquals((String)("len(a) == " + n + " "), (int)LIST.LENGTH(lIST), (int)n);
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>();
        LIST<BigRational> lIST2 = lIST;
        l = System.currentTimeMillis();
        while (!LIST.isEmpty(lIST2)) {
            bigRational = LIST.FIRST(lIST2);
            lIST2 = LIST.RED(lIST2);
            arrayList.add(bigRational);
        }
        l2 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.red  = " + (l2 - l));
        }
        LISTTest.assertEquals((String)("size(b) == " + n + " "), (int)arrayList.size(), (int)n);
        arrayList = new ArrayList();
        int n2 = LIST.LENGTH(lIST);
        l = System.currentTimeMillis();
        for (int i = 0; i < n2; ++i) {
            bigRational = LIST.LELT(lIST, i);
            arrayList.add(bigRational);
        }
        l2 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.lelt = " + (l2 - l));
        }
        LIST lIST3 = new LIST(arrayList);
        LISTTest.assertEquals((String)("len(c) == " + n + " "), (int)LIST.LENGTH(lIST3), (int)n);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(lIST, lIST3));
    }
}

