/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExpVectorTest
extends TestCase {
    ExpVector a;
    ExpVector b;
    ExpVector c;
    ExpVector d;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExpVectorTest.suite());
    }

    public ExpVectorTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ExpVectorTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        this.a = ExpVector.create(0);
        this.b = ExpVector.create(0);
        ExpVectorTest.assertEquals((String)"() = ()", (Object)this.a, (Object)this.b);
        ExpVectorTest.assertEquals((String)"length( () ) = 0", (int)this.a.length(), (int)0);
        ExpVectorTest.assertTrue((String)"isZERO( () )", (boolean)this.a.isZERO());
        this.a = ExpVector.create(10);
        this.b = ExpVector.create(10);
        ExpVectorTest.assertEquals((String)"10e = 10e", (Object)this.a, (Object)this.b);
        ExpVectorTest.assertEquals((String)"length( 10e ) = 10", (int)this.a.length(), (int)10);
        ExpVectorTest.assertTrue((String)"isZERO( ( 10e ) )", (boolean)this.a.isZERO());
        String string = "(0,0,0,0,0,0,0,0,0,0)";
        this.a = ExpVector.create(string);
        String string2 = this.a.toString().substring(0, string.length());
        ExpVectorTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        ExpVectorTest.assertTrue((String)"isZERO( ( 10e ) )", (boolean)this.a.isZERO());
    }

    public void testRandom() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        String string = this.a.toString();
        if (string.indexOf(":") >= 0) {
            string = string.substring(0, string.indexOf(":"));
        }
        this.b = ExpVector.create(string);
        ExpVectorTest.assertEquals((String)"a == b", (boolean)true, (boolean)this.a.equals(this.b));
        this.c = ExpVector.EVDIF(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a-b = 0", (boolean)this.c.isZERO());
    }

    public void testAddition() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVSUM(this.a, this.a);
        this.c = ExpVector.EVDIF(this.b, this.a);
        ExpVectorTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ExpVectorTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        boolean bl = ExpVector.EVMT(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a | a+a", (boolean)bl);
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        this.c = ExpVector.EVSUM(this.a, this.b);
        this.d = ExpVector.EVSUM(this.b, this.a);
        ExpVectorTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
    }

    public void testLcm() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        this.c = ExpVector.EVLCM(this.a, this.b);
        this.d = ExpVector.EVLCM(this.b, this.a);
        ExpVectorTest.assertTrue((String)"lcm(a,b) = lcm(b,a)", (boolean)this.c.equals(this.d));
        ExpVectorTest.assertTrue((String)"a | lcm(a,b)", (boolean)ExpVector.EVMT(this.c, this.a));
        ExpVectorTest.assertTrue((String)"b | lcm(a,b)", (boolean)ExpVector.EVMT(this.c, this.b));
        this.d = ExpVector.EVDIF(this.c, this.a);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-a) >= 0", (ExpVector.EVSIGN(this.d) >= 0 ? 1 : 0) != 0);
        this.d = ExpVector.EVDIF(this.c, this.b);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-b) >= 0", (ExpVector.EVSIGN(this.d) >= 0 ? 1 : 0) != 0);
    }

    public void testTdeg() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
    }

    public void testWeightdeg() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) = 0", (ExpVector.EVWDEG(null, this.a) == 0L ? 1 : 0) != 0);
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertEquals((String)"tdeg(a) == wdeg(a)", (long)ExpVector.EVTDEG(this.a), (long)ExpVector.EVWDEG(lArrayArray, this.a));
        ExpVectorTest.assertEquals((String)"tdeg(b) == wdeg(b)", (long)ExpVector.EVTDEG(this.b), (long)ExpVector.EVWDEG(lArrayArray, this.b));
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        lArrayArray = new long[][]{{10L, 1L, 3L, 9L, 100L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        lArrayArray = new long[][]{{10L, 1L, 3L, 9L, 100L}, {1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVSUM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = ExpVector.EVLCM(this.a, this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
    }

    public void testDependency() {
        this.a = ExpVector.create(10, 5, 2L);
        int[] nArray = new int[]{5};
        int[] nArray2 = ExpVector.EVDOV(this.a);
        ExpVectorTest.assertTrue((String)"[5] = [5]", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(10, 3, 9L);
        nArray = new int[]{3};
        nArray2 = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[3] = [3]", (boolean)Arrays.equals(nArray, nArray2));
        this.c = ExpVector.EVSUM(this.a, this.b);
        nArray = new int[]{3, 5};
        nArray2 = ExpVector.EVDOV(this.c);
        ExpVectorTest.assertTrue((String)("[3,5] = [3,5] " + Arrays.toString(nArray) + "," + Arrays.toString(nArray2)), (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(10);
        nArray = new int[]{};
        nArray2 = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(0);
        nArray = new int[]{};
        nArray2 = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(1, 0, 1L);
        nArray = new int[]{0};
        nArray2 = ExpVector.EVDOV(this.b);
        ExpVectorTest.assertTrue((String)"[0] = [0]", (boolean)Arrays.equals(nArray, nArray2));
    }

    public void testRandom2() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.create("" + this.a);
        ExpVectorTest.assertEquals((String)"a == b", (boolean)true, (boolean)this.a.equals(this.b));
        this.c = this.b.subtract(this.a);
        ExpVectorTest.assertTrue((String)"a-b = 0", (boolean)this.c.isZERO());
    }

    public void testAddition2() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        ExpVectorTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        ExpVectorTest.assertTrue((String)"a+a-a = a", (boolean)this.c.equals(this.a));
        boolean bl = this.b.multipleOf(this.a);
        ExpVectorTest.assertTrue((String)"a | a+a", (boolean)bl);
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        ExpVectorTest.assertTrue((String)"a+b = b+a", (boolean)this.c.equals(this.d));
    }

    public void testLcm2() {
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        this.c = this.a.lcm(this.b);
        this.d = this.b.lcm(this.a);
        ExpVectorTest.assertTrue((String)"lcm(a,b) = lcm(b,a)", (boolean)this.c.equals(this.d));
        ExpVectorTest.assertTrue((String)"a | lcm(a,b)", (boolean)this.c.multipleOf(this.a));
        ExpVectorTest.assertTrue((String)"b | lcm(a,b)", (boolean)this.c.multipleOf(this.b));
        this.d = this.c.subtract(this.a);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-a) >= 0", (this.d.signum() >= 0 ? 1 : 0) != 0);
        this.d = this.c.subtract(this.b);
        ExpVectorTest.assertTrue((String)"sign(lcm(a,b)-b) >= 0", (this.d.signum() >= 0 ? 1 : 0) != 0);
    }

    public void testTdeg2() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a+b) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(a)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(lcm(a,b)) >= tdeg(b)", (ExpVector.EVTDEG(this.c) >= ExpVector.EVTDEG(this.b) ? 1 : 0) != 0);
    }

    public void testWeightdeg2() {
        this.a = ExpVector.create(100);
        ExpVectorTest.assertTrue((String)"tdeg(a) = 0", (ExpVector.EVTDEG(this.a) == 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) = 0", (ExpVector.EVWDEG(null, this.a) == 0L ? 1 : 0) != 0);
        float f = 0.2f;
        this.a = ExpVector.EVRAND(5, 10L, f);
        this.b = ExpVector.EVRAND(5, 10L, f);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertEquals((String)"tdeg(a) == wdeg(a)", (long)ExpVector.EVTDEG(this.a), (long)ExpVector.EVWDEG(lArrayArray, this.a));
        ExpVectorTest.assertEquals((String)"tdeg(b) == wdeg(b)", (long)ExpVector.EVTDEG(this.b), (long)ExpVector.EVWDEG(lArrayArray, this.b));
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        lArrayArray = new long[][]{{10L, 1L, 3L, 9L, 100L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        lArrayArray = new long[][]{{10L, 1L, 3L, 9L, 100L}, {1L, 1L, 1L, 1L, 1L}};
        ExpVectorTest.assertTrue((String)"tdeg(a) >= 0", (ExpVector.EVTDEG(this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) >= 0", (ExpVector.EVTDEG(this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a) >= 0", (ExpVector.EVWDEG(lArrayArray, this.a) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(b) >= 0", (ExpVector.EVWDEG(lArrayArray, this.b) >= 0L ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(a) <= wdeg(a)", (ExpVector.EVTDEG(this.a) <= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"tdeg(b) <= wdeg(b)", (ExpVector.EVTDEG(this.b) <= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = this.a.sum(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(a+b) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
        this.c = this.a.lcm(this.b);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(a)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.a) ? 1 : 0) != 0);
        ExpVectorTest.assertTrue((String)"wdeg(lcm(a,b)) >= wdeg(b)", (ExpVector.EVWDEG(lArrayArray, this.c) >= ExpVector.EVWDEG(lArrayArray, this.b) ? 1 : 0) != 0);
    }

    public void testDependency2() {
        this.a = ExpVector.create(10, 5, 2L);
        int[] nArray = new int[]{5};
        int[] nArray2 = this.a.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[5] = [5]", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(10, 3, 9L);
        nArray = new int[]{3};
        nArray2 = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[3] = [3]", (boolean)Arrays.equals(nArray, nArray2));
        this.c = this.a.sum(this.b);
        nArray = new int[]{3, 5};
        nArray2 = this.c.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)("[3,5] = [3,5] " + Arrays.toString(nArray) + "," + Arrays.toString(nArray2)), (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(10);
        nArray = new int[]{};
        nArray2 = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(0);
        nArray = new int[]{};
        nArray2 = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[] = []", (boolean)Arrays.equals(nArray, nArray2));
        this.b = ExpVector.create(1, 0, 1L);
        nArray = new int[]{0};
        nArray2 = this.b.dependencyOnVariables();
        ExpVectorTest.assertTrue((String)"[0] = [0]", (boolean)Arrays.equals(nArray, nArray2));
    }

    public void testEvaluation() {
        float f = 0.2f;
        int n = 5;
        this.a = ExpVector.EVRAND(n, 10L, f);
        this.b = ExpVector.EVRAND(n, 10L, f);
        BigInteger bigInteger = new BigInteger(0L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(this.a.length());
        for (int i = 0; i < this.a.length(); ++i) {
            arrayList.add(bigInteger.random(4));
        }
        BigInteger bigInteger2 = this.a.evaluate(bigInteger, arrayList);
        BigInteger bigInteger3 = this.b.evaluate(bigInteger, arrayList);
        this.c = this.a.sum(this.b);
        BigInteger bigInteger4 = this.c.evaluate(bigInteger, arrayList);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        ExpVectorTest.assertEquals((String)"a(v)*b(v) = (a+b)(v) ", (Object)bigInteger4, (Object)bigInteger5);
        this.c = ExpVector.create(n);
        bigInteger4 = this.c.evaluate(bigInteger, arrayList);
        bigInteger5 = bigInteger.getONE();
        ExpVectorTest.assertEquals((String)"0(v) = 1 ", (Object)bigInteger4, (Object)bigInteger5);
        arrayList.clear();
        for (int i = 0; i < this.a.length(); ++i) {
            arrayList.add(bigInteger.getZERO());
        }
        bigInteger4 = this.c.evaluate(bigInteger, arrayList);
        bigInteger5 = bigInteger.getONE();
        ExpVectorTest.assertEquals((String)"0(0) = 1 ", (Object)bigInteger4, (Object)bigInteger5);
        bigInteger2 = this.a.evaluate(bigInteger, arrayList);
        if (this.a.isZERO()) {
            bigInteger5 = bigInteger.getONE();
            ExpVectorTest.assertEquals((String)"0(0) = 1 ", (Object)bigInteger2, (Object)bigInteger5);
        } else {
            bigInteger5 = bigInteger.getZERO();
            ExpVectorTest.assertEquals((String)"a(0) = 0 ", (Object)bigInteger2, (Object)bigInteger5);
        }
    }
}

