/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufdroot;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FactorRealAlgebraic<C extends GcdRingElem<C> & Rational>
extends FactorAbstract<RealAlgebraicNumber<C>> {
    private static final Logger logger = Logger.getLogger(FactorRealAlgebraic.class);
    public final FactorAbstract<AlgebraicNumber<C>> factorAlgebraic;

    protected FactorRealAlgebraic() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorRealAlgebraic(RealAlgebraicRing<C> realAlgebraicRing) {
        this(realAlgebraicRing, FactorFactory.getImplementation(realAlgebraicRing.algebraic));
    }

    public FactorRealAlgebraic(RealAlgebraicRing<C> realAlgebraicRing, FactorAbstract<AlgebraicNumber<C>> factorAbstract) {
        super(realAlgebraicRing);
        this.factorAlgebraic = factorAbstract;
    }

    @Override
    public List<GenPolynomial<RealAlgebraicNumber<C>>> baseFactorsSquarefree(GenPolynomial<RealAlgebraicNumber<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<RealAlgebraicNumber<C>>> arrayList = new ArrayList<GenPolynomial<RealAlgebraicNumber<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        RealAlgebraicNumber<C> realAlgebraicNumber = genPolynomial.leadingBaseCoefficient();
        if (!realAlgebraicNumber.isONE()) {
            genPolynomial = genPolynomial.monic();
            arrayList.add(((GenPolynomial)genPolynomialRing.getONE()).multiply(realAlgebraicNumber));
        }
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(realAlgebraicRing.algebraic, genPolynomialRing);
        GenPolynomial genPolynomial2 = PolyUtilRoot.algebraicFromRealCoefficients(genPolynomialRing2, genPolynomial);
        List list = this.factorAlgebraic.baseFactorsSquarefree(genPolynomial2);
        for (GenPolynomial genPolynomial3 : list) {
            GenPolynomial genPolynomial4 = PolyUtilRoot.realFromAlgebraicCoefficients(genPolynomialRing, genPolynomial3);
            arrayList.add(genPolynomial4);
        }
        logger.info((Object)("real algebraic factors = " + arrayList));
        return arrayList;
    }
}

