/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Factors;
import java.io.Serializable;
import java.util.List;

public class FactorsList<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> poly;
    public final List<GenPolynomial<C>> factors;
    public final List<Factors<C>> afactors;

    public FactorsList(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        this(genPolynomial, list, null);
    }

    public FactorsList(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list, List<Factors<C>> list2) {
        this.poly = genPolynomial;
        this.factors = list;
        this.afactors = list2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (GenPolynomial<C> comparable : this.factors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n ");
            }
            stringBuffer.append(comparable.toString());
        }
        if (this.afactors == null) {
            return stringBuffer.toString();
        }
        for (Factors factors : this.afactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",\n ");
            }
            stringBuffer.append(factors.toString());
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.poly.toScript());
        stringBuffer.append(" =\n");
        boolean bl = true;
        for (GenPolynomial<C> comparable : this.factors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            stringBuffer.append(comparable.toScript());
        }
        if (this.afactors == null) {
            return stringBuffer.toString();
        }
        for (Factors factors : this.afactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n * ");
            }
            stringBuffer.append(factors.toScript());
        }
        return stringBuffer.toString();
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afactors == null) {
            return null;
        }
        AlgebraicNumberRing<C> algebraicNumberRing = null;
        int n = 0;
        for (Factors<C> factors : this.afactors) {
            int n2;
            AlgebraicNumberRing<C> algebraicNumberRing2 = factors.findExtensionField();
            if (algebraicNumberRing2 == null || (n2 = algebraicNumberRing2.depth()) <= n) continue;
            n = n2;
            algebraicNumberRing = algebraicNumberRing2;
        }
        return algebraicNumberRing;
    }
}

