/*
 * Decompiled with CFR 0.152.
 */
package net.sf.epsgraphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Map;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsDocument;

public class EpsGraphics
extends Graphics2D {
    public static final String VERSION = "1.0.0";
    private Color color;
    private AffineTransform _clipTransform;
    private Color _backgroundColor;
    private Paint _paint;
    private Composite _composite;
    private BasicStroke _stroke;
    private Font _font;
    private Shape _clip;
    private AffineTransform _transform;
    private boolean _accurateTextMode;
    private EpsDocument _document;
    private static FontRenderContext _fontRenderContext = new FontRenderContext(null, false, true);
    private ColorMode colorMode = ColorMode.COLOR_RGB;

    public EpsGraphics(String title, OutputStream outputStream, int minX, int minY, int maxX, int maxY, ColorMode colorMode) throws IOException {
        this._document = new EpsDocument(title, outputStream, minX, minY, maxX, maxY);
        this.colorMode = colorMode;
        this._backgroundColor = Color.white;
        this._clip = null;
        this._transform = new AffineTransform();
        this._clipTransform = new AffineTransform();
        this._accurateTextMode = true;
        this.setColor(Color.black);
        this.setPaint(Color.black);
        this.setComposite(AlphaComposite.getInstance(1));
        this.setFont(Font.decode(null));
        this.setStroke(new BasicStroke());
    }

    public EpsGraphics(EpsDocument doc, ColorMode m) throws IOException {
        new EpsGraphics(doc.getTitle(), doc.getStream(), doc.getMinX(), doc.getMinY(), doc.getMaxX(), doc.getMaxY(), this.colorMode);
    }

    public EpsGraphics(EpsGraphics g) throws IOException {
        EpsDocument doc = g._document;
        new EpsGraphics(doc, g.colorMode);
    }

    private void methodNotSupported() {
        throw new RuntimeException("Method not currently supported by EpsGraphics2D version 1.0.0");
    }

    public void setAccurateTextMode(boolean b) {
        this._accurateTextMode = b;
        if (!this.getAccurateTextMode()) {
            this.setFont(this.getFont());
        }
    }

    public boolean getAccurateTextMode() {
        return this._accurateTextMode;
    }

    public void flush() throws IOException {
        this._document.flush();
    }

    public void close() throws IOException {
        this.flush();
        this._document.close();
    }

    private void append(String line) {
        this._document.append(this, line);
    }

    private Point2D transform(double x, double y) {
        Point2D result = new Point2D.Double(x, y);
        result = this._transform.transform(result, result);
        result.setLocation(result.getX(), -result.getY());
        return result;
    }

    private void draw(Shape s, String action) {
        if (s != null) {
            if (!this._transform.isIdentity()) {
                s = this._transform.createTransformedShape(s);
            }
            this.append("newpath");
            int type = 0;
            double[] coords = new double[6];
            PathIterator it = s.getPathIterator(null);
            double x0 = 0.0;
            double y0 = 0.0;
            int count = 0;
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                double x1 = coords[0];
                double y1 = -coords[1];
                double x2 = coords[2];
                double y2 = -coords[3];
                double x3 = coords[4];
                double y3 = -coords[5];
                if (type == 4) {
                    this.append("closepath");
                    ++count;
                } else if (type == 3) {
                    this.append(String.valueOf(x1) + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3 + " curveto");
                    ++count;
                    x0 = x3;
                    y0 = y3;
                } else if (type == 1) {
                    this.append(String.valueOf(x1) + " " + y1 + " lineto");
                    ++count;
                    x0 = x1;
                    y0 = y1;
                } else if (type == 0) {
                    this.append(String.valueOf(x1) + " " + y1 + " moveto");
                    ++count;
                    x0 = x1;
                    y0 = y1;
                } else if (type == 2) {
                    double _x1 = x0 + 0.6666666865348816 * (x1 - x0);
                    double _y1 = y0 + 0.6666666865348816 * (y1 - y0);
                    double _x2 = x1 + 0.3333333432674408 * (x2 - x1);
                    double _y2 = y1 + 0.3333333432674408 * (y2 - y1);
                    double _x3 = x2;
                    double _y3 = y2;
                    this.append(String.valueOf(_x1) + " " + _y1 + " " + _x2 + " " + _y2 + " " + _x3 + " " + _y3 + " curveto");
                    ++count;
                    x0 = _x3;
                    y0 = _y3;
                } else if (type != 0) {
                    // empty if block
                }
                it.next();
            }
            this.append(action);
            this.append("newpath");
        }
    }

    private String toHexString(int n) {
        String result = Integer.toString(n, 16);
        while (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color originalColor = this.getColor();
        Stroke originalStroke = this.getStroke();
        this.setStroke(new BasicStroke(1.0f));
        if (raised) {
            this.setColor(originalColor.brighter());
        } else {
            this.setColor(originalColor.darker());
        }
        this.drawLine(x, y, x + width, y);
        this.drawLine(x, y, x, y + height);
        if (raised) {
            this.setColor(originalColor.darker());
        } else {
            this.setColor(originalColor.brighter());
        }
        this.drawLine(x + width, y + height, x, y + height);
        this.drawLine(x + width, y + height, x + width, y);
        this.setColor(originalColor);
        this.setStroke(originalStroke);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color originalColor = this.getColor();
        if (raised) {
            this.setColor(originalColor.brighter());
        } else {
            this.setColor(originalColor.darker());
        }
        this.draw(new Rectangle(x, y, width, height), "fill");
        this.setColor(originalColor);
        this.draw3DRect(x, y, width, height, raised);
    }

    public void draw(Shape s) {
        this.draw(s, "stroke");
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform at = this.getTransform();
        this.transform(xform);
        boolean st = this.drawImage(img, 0, 0, obs);
        this.setTransform(at);
        return st;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] names = img.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            properties.put(names[i], img.getProperty(names[i]));
            ++i;
        }
        ColorModel cm = img.getColorModel();
        WritableRaster wr = img.copyData(null);
        BufferedImage img1 = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        AffineTransform at = AffineTransform.getTranslateInstance(img.getMinX(), img.getMinY());
        at.preConcatenate(xform);
        this.drawImage(img1, at, null);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String s, float x, float y) {
        if (s != null && s.length() > 0) {
            AttributedString as = new AttributedString(s);
            as.addAttribute(TextAttribute.FONT, this.getFont());
            this.drawString(as.getIterator(), x, y);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.getAccurateTextMode()) {
            TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
            Shape shape = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
            this.draw(shape, "fill");
        } else {
            this.append("newpath");
            Point2D location = this.transform(x, y);
            this.append(String.valueOf(location.getX()) + " " + location.getY() + " moveto");
            StringBuffer buffer = new StringBuffer();
            char ch = iterator.first();
            while (ch != '\uffff') {
                if (ch == '(' || ch == ')') {
                    buffer.append('\\');
                }
                buffer.append(ch);
                ch = iterator.next();
            }
            this.append("(" + buffer.toString() + ") show");
        }
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        Shape shape = g.getOutline(x, y);
        this.draw(shape, "fill");
    }

    public void fill(Shape s) {
        this.draw(s, "fill");
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return s.intersects(rect);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        int i = 0;
        while (i < gds.length) {
            GraphicsDevice gd = gds[i];
            GraphicsConfiguration[] gcs = gd.getConfigurations();
            if (gcs.length > 0) {
                return gcs[0];
            }
            ++i;
        }
        return gc;
    }

    public void setComposite(Composite comp) {
        this._composite = comp;
    }

    public void setPaint(Paint paint) {
        this._paint = paint;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            this._stroke = (BasicStroke)s;
            this.append(String.valueOf(this._stroke.getLineWidth()) + " setlinewidth");
            double miterLimit = this._stroke.getMiterLimit();
            if (miterLimit < 1.0) {
                miterLimit = 1.0;
            }
            this.append(String.valueOf(miterLimit) + " setmiterlimit");
            this.append(String.valueOf(this._stroke.getLineJoin()) + " setlinejoin");
            this.append(String.valueOf(this._stroke.getEndCap()) + " setlinecap");
            StringBuffer dashes = new StringBuffer();
            dashes.append("[ ");
            float[] dashArray = this._stroke.getDashArray();
            if (dashArray != null) {
                int i = 0;
                while (i < dashArray.length) {
                    dashes.append(String.valueOf(dashArray[i]) + " ");
                    ++i;
                }
            }
            dashes.append("]");
            this.append(String.valueOf(dashes.toString()) + " 0 setdash");
        }
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    public void rotate(double theta) {
        this.rotate(theta, 0.0, 0.0);
    }

    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    public void transform(AffineTransform Tx) {
        this._transform.concatenate(Tx);
        this.setTransform(this.getTransform());
    }

    public void setTransform(AffineTransform Tx) {
        this._transform = Tx == null ? new AffineTransform() : new AffineTransform(Tx);
        this.setStroke(this.getStroke());
        this.setFont(this.getFont());
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    public Paint getPaint() {
        return this._paint;
    }

    public Composite getComposite() {
        return this._composite;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._backgroundColor = color;
    }

    public Color getBackground() {
        return this._backgroundColor;
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void clip(Shape s) {
        if (this._clip == null) {
            this.setClip(s);
        } else {
            Area area = new Area(this._clip);
            area.intersect(new Area(s));
            this.setClip(area);
        }
    }

    public FontRenderContext getFontRenderContext() {
        return _fontRenderContext;
    }

    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.clipRect(0, 0, width, height);
        return g;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.color = color;
        switch (this.colorMode) {
            case BLACK_AND_WHITE: {
                double value = 0.0;
                if ((double)(color.getRed() + color.getGreen() + color.getBlue()) > 381.5) {
                    value = 1.0;
                }
                this.append(String.valueOf(value) + " setgray");
                break;
            }
            case GRAYSCALE: {
                double grayvalue = (float)(color.getRed() + color.getGreen() + color.getBlue()) / 765.0f;
                this.append(String.valueOf(grayvalue) + " setgray");
                break;
            }
            case COLOR_RGB: {
                this.append(String.valueOf((float)color.getRed() / 255.0f) + " " + (float)color.getGreen() / 255.0f + " " + (float)color.getBlue() / 255.0f + " setrgbcolor");
                break;
            }
            case COLOR_CMYK: {
                if (color.equals(Color.BLACK)) {
                    this.append("0.0 0.0 0.0 1.0 setcmykcolor");
                    break;
                }
                double c = 1.0f - (float)color.getRed() / 255.0f;
                double m = 1.0f - (float)color.getGreen() / 255.0f;
                double y = 1.0f - (float)color.getBlue() / 255.0f;
                double k = Math.min(Math.min(c, y), m);
                this.append(String.valueOf((c - k) / (1.0 - k)) + " " + (m - k) / (1.0 - k) + " " + (y - k) / (1.0 - k) + " " + k + " setcmykcolor");
            }
        }
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
        this.methodNotSupported();
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.decode(null);
        }
        this._font = font;
        if (!this.getAccurateTextMode()) {
            this.append("/" + this._font.getPSName() + " findfont " + this._font.getSize() + " scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font f) {
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics g = image.getGraphics();
        return g.getFontMetrics(f);
    }

    public Rectangle getClipBounds() {
        if (this._clip == null) {
            return null;
        }
        Rectangle rect = this.getClip().getBounds();
        return rect;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public Shape getClip() {
        if (this._clip == null) {
            return null;
        }
        try {
            AffineTransform t = this._transform.createInverse();
            t.concatenate(this._clipTransform);
            return t.createTransformedShape(this._clip);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get inverse of matrix: " + this._transform);
        }
    }

    public void setClip(Shape clip) {
        if (clip != null) {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this.append("gsave");
            } else {
                this._document.setClipSet(true);
                this.append("gsave");
            }
            this.draw(clip, "clip");
            this._clip = clip;
            this._clipTransform = (AffineTransform)this._transform.clone();
        } else {
            if (this._document.isClipSet()) {
                this.append("grestore");
                this._document.setClipSet(false);
            }
            this._clip = null;
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.methodNotSupported();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double shape = new Line2D.Double(x1, y1, x2, y2);
        this.draw(shape);
    }

    public void fillRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape, "fill");
    }

    public void drawRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape);
    }

    public void clearRect(int x, int y, int width, int height) {
        Color originalColor = this.getColor();
        this.setColor(this.getBackground());
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape, "fill");
        this.setColor(originalColor);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.draw(shape);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        this.draw(shape, "fill");
    }

    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, width, height);
        this.draw(shape);
    }

    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, width, height);
        this.draw(shape, "fill");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double shape = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(shape);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Double shape = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2);
        this.draw(shape, "fill");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(xPoints[0], yPoints[0]);
            int i = 1;
            while (i < nPoints) {
                path.lineTo(xPoints[i], yPoints[i]);
                ++i;
            }
            this.draw(path);
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon shape = new Polygon(xPoints, yPoints, nPoints);
        this.draw(shape);
    }

    public void drawPolygon(Polygon p) {
        this.draw(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        Polygon shape = new Polygon(xPoints, yPoints, nPoints);
        this.draw(shape, "fill");
    }

    public void fillPolygon(Polygon p) {
        this.draw(p, "fill");
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        String string = new String(data, offset, length);
        this.drawString(string, x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        String string = new String(data, offset, length);
        this.drawString(string, x, y);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, Color.white, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, Color.white, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        return this.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, Color.white, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (dx1 >= dx2) {
            throw new IllegalArgumentException("dx1 >= dx2");
        }
        if (sx1 >= sx2) {
            throw new IllegalArgumentException("sx1 >= sx2");
        }
        if (dy1 >= dy2) {
            throw new IllegalArgumentException("dy1 >= dy2");
        }
        if (sy1 >= sy2) {
            throw new IllegalArgumentException("sy1 >= sy2");
        }
        this.append("gsave");
        int width = sx2 - sx1;
        int height = sy2 - sy1;
        int destWidth = dx2 - dx1;
        int destHeight = dy2 - dy1;
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, sx1, sy1, sx2 - sx1, sy2 - sy1, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        AffineTransform matrix = new AffineTransform(this._transform);
        matrix.translate(dx1, dy1);
        matrix.scale((double)destWidth / (double)width, (double)destHeight / (double)height);
        double[] m = new double[6];
        try {
            matrix = matrix.createInverse();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get inverse of matrix: " + matrix);
        }
        matrix.scale(1.0, -1.0);
        matrix.getMatrix(m);
        String bitsPerSample = "8";
        this.append(String.valueOf(width) + " " + height + " " + bitsPerSample + " [" + m[0] + " " + m[1] + " " + m[2] + " " + m[3] + " " + m[4] + " " + m[5] + "]");
        Color oldColor = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(dx1, dy1, destWidth, destHeight);
        this.setColor(oldColor);
        if (this.colorMode.equals((Object)ColorMode.BLACK_AND_WHITE) || this.colorMode.equals((Object)ColorMode.GRAYSCALE)) {
            this.append("{currentfile " + width + " string readhexstring pop} bind");
            this.append("image");
        } else {
            this.append("{currentfile 3 " + width + " mul string readhexstring pop} bind");
            this.append("false 3 colorimage");
        }
        StringBuffer line = new StringBuffer();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                Color color = new Color(pixels[x + width * y]);
                if (this.colorMode.equals((Object)ColorMode.BLACK_AND_WHITE)) {
                    if ((double)(color.getRed() + color.getGreen() + color.getBlue()) > 381.5) {
                        line.append("ff");
                    } else {
                        line.append("00");
                    }
                } else if (this.colorMode.equals((Object)ColorMode.GRAYSCALE)) {
                    line.append(this.toHexString((color.getRed() + color.getGreen() + color.getBlue()) / 3));
                } else {
                    line.append(String.valueOf(this.toHexString(color.getRed())) + this.toHexString(color.getGreen()) + this.toHexString(color.getBlue()));
                }
                if (line.length() > 64) {
                    this.append(line.toString());
                    line = new StringBuffer();
                }
                ++x;
            }
            ++y;
        }
        if (line.length() > 0) {
            this.append(line.toString());
        }
        this.append("grestore");
        return true;
    }

    public void dispose() {
        this._document = null;
    }

    public void finalize() {
        super.finalize();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this._document.write(writer);
            this._document.flush();
            this._document.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return writer.toString();
    }

    public boolean hitClip(int x, int y, int width, int height) {
        if (this._clip == null) {
            return true;
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        return this.hit(rect, this._clip, true);
    }

    public Rectangle getClipBounds(Rectangle r) {
        if (this._clip == null) {
            return r;
        }
        Rectangle rect = this.getClipBounds();
        r.setLocation((int)rect.getX(), (int)rect.getY());
        r.setSize((int)rect.getWidth(), (int)rect.getHeight());
        return r;
    }

    public Graphics create() {
        try {
            return new EpsGraphics(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create EpsGraphics object.");
        }
    }
}

