/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QuotIntegral<C extends GcdRingElem<C>>
implements Serializable {
    public final Quotient<C> quot;
    public final List<Quotient<C>> rational;
    public final List<LogIntegral<C>> logarithm;

    public QuotIntegral(Integral<C> integral) {
        this(new QuotientRing(integral.den.ring), integral);
    }

    public QuotIntegral(QuotientRing<C> quotientRing, Integral<C> integral) {
        this(new Quotient<C>(quotientRing, integral.num, integral.den), integral.pol, integral.rational, integral.logarithm);
    }

    public QuotIntegral(Quotient<C> quotient, GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        this(quotient, genPolynomial, list, new ArrayList<LogIntegral<C>>());
    }

    public QuotIntegral(Quotient<C> quotient, GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list, List<LogIntegral<C>> list2) {
        this.quot = quotient;
        QuotientRing quotientRing = quotient.ring;
        this.rational = new ArrayList<Quotient<C>>();
        if (!genPolynomial.isZERO()) {
            this.rational.add(new Quotient(quotientRing, genPolynomial));
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial2 = list.get(i++);
            GenPolynomial<C> genPolynomial3 = list.get(i);
            this.rational.add(new Quotient(quotientRing, genPolynomial2, genPolynomial3));
        }
        this.logarithm = list2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("integral( " + this.quot.toString() + " )");
        stringBuffer.append(" =\n");
        boolean bl = true;
        if (this.rational.size() != 0) {
            for (int i = 0; i < this.rational.size(); ++i) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append("(" + this.rational.get(i) + ")");
            }
        }
        if (this.logarithm.size() != 0) {
            if (this.rational.size() != 0) {
                stringBuffer.append(" + ");
            }
            bl = true;
            for (LogIntegral<C> logIntegral : this.logarithm) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" + ");
                }
                stringBuffer.append(logIntegral);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.quot.hashCode();
        n = n * 37 + this.rational.hashCode();
        n = n * 37 + this.logarithm.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        QuotIntegral quotIntegral = null;
        try {
            quotIntegral = (QuotIntegral)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (quotIntegral == null) {
            return false;
        }
        return this.quot.equals(quotIntegral.quot) && this.rational.equals(quotIntegral.rational) && this.logarithm.equals(quotIntegral.logarithm);
    }
}

