/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Quotient;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class QuotientRing<C extends RingElem<C>>
implements RingFactory<Quotient<C>>,
QuotPairFactory<C, Quotient<C>> {
    private static final Logger logger = Logger.getLogger(QuotientRing.class);
    private final boolean debug = logger.isDebugEnabled();
    public final RingFactory<C> ring;

    public QuotientRing(RingFactory<C> ringFactory) {
        this.ring = ringFactory;
    }

    @Override
    public RingFactory<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Quotient<C> create(C c) {
        return new Quotient<C>(this, c);
    }

    @Override
    public Quotient<C> create(C c, C c2) {
        return new Quotient<C>(this, c, c2);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Quotient<C> copy(Quotient<C> quotient) {
        return new Quotient(quotient.ring, quotient.num, quotient.den, true);
    }

    @Override
    public Quotient<C> getZERO() {
        return new Quotient<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Quotient<C> getONE() {
        return new Quotient<RingElem>(this, (RingElem)this.ring.getONE());
    }

    @Override
    public List<Quotient<C>> generators() {
        List list = this.ring.generators();
        ArrayList<Quotient<C>> arrayList = new ArrayList<Quotient<C>>(list.size());
        for (RingElem ringElem : list) {
            arrayList.add(new Quotient<RingElem>(this, ringElem));
        }
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Quotient<C> fromInteger(BigInteger bigInteger) {
        return new Quotient<RingElem>(this, (RingElem)this.ring.fromInteger(bigInteger));
    }

    @Override
    public Quotient<C> fromInteger(long l) {
        return new Quotient<RingElem>(this, (RingElem)this.ring.fromInteger(l));
    }

    public String toString() {
        return "Quotient[ " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "QuotientRing(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QuotientRing)) {
            return false;
        }
        QuotientRing quotientRing = (QuotientRing)object;
        return this.ring.equals(quotientRing.ring);
    }

    public int hashCode() {
        int n = this.ring.hashCode();
        return n;
    }

    @Override
    public Quotient<C> random(int n) {
        RingElem ringElem = (RingElem)this.ring.random(n);
        RingElem ringElem2 = (RingElem)this.ring.random(n);
        while (ringElem2.isZERO()) {
            ringElem2 = (RingElem)this.ring.random(n);
        }
        return new Quotient<RingElem>(this, ringElem, ringElem2, false);
    }

    @Override
    public Quotient<C> random(int n, Random random) {
        RingElem ringElem = (RingElem)this.ring.random(n, random);
        RingElem ringElem2 = (RingElem)this.ring.random(n, random);
        while (ringElem2.isZERO()) {
            ringElem2 = (RingElem)this.ring.random(n, random);
        }
        return new Quotient<RingElem>(this, ringElem, ringElem2, false);
    }

    @Override
    public Quotient<C> parse(String string) {
        RingElem ringElem = (RingElem)this.ring.parse(string);
        return new Quotient<RingElem>(this, ringElem);
    }

    @Override
    public Quotient<C> parse(Reader reader) {
        RingElem ringElem = (RingElem)this.ring.parse(reader);
        if (this.debug) {
            logger.debug((Object)("x = " + ringElem));
        }
        return new Quotient<RingElem>(this, ringElem);
    }
}

