/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public final class BigOctonion
implements StarRingElem<BigOctonion>,
GcdRingElem<BigOctonion>,
RingFactory<BigOctonion> {
    public final BigQuaternion or;
    public final BigQuaternion oi;
    private static final Random random = new Random();
    private static final Logger logger = Logger.getLogger(BigOctonion.class);
    private final boolean debug = logger.isDebugEnabled();
    public static final BigOctonion ZERO = new BigOctonion();
    public static final BigOctonion ONE = new BigOctonion(BigQuaternion.ONE);
    public static final BigOctonion I = new BigOctonion(BigQuaternion.ZERO, BigQuaternion.ONE);

    public BigOctonion(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        this.or = bigQuaternion;
        this.oi = bigQuaternion2;
    }

    public BigOctonion(BigQuaternion bigQuaternion) {
        this(bigQuaternion, BigQuaternion.ZERO);
    }

    public BigOctonion(BigComplex bigComplex) {
        this(new BigQuaternion(bigComplex));
    }

    public BigOctonion(BigRational bigRational) {
        this(new BigQuaternion(bigRational));
    }

    public BigOctonion(long l) {
        this(new BigQuaternion(l));
    }

    public BigOctonion() {
        this(BigQuaternion.ZERO);
    }

    public BigOctonion(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            this.or = BigOctonion.ZERO.or;
            this.oi = BigOctonion.ZERO.oi;
            return;
        }
        int n = (string = string.trim()).indexOf("o");
        if (n == -1) {
            this.or = new BigQuaternion(string);
            this.oi = BigOctonion.ZERO.oi;
            return;
        }
        String string2 = string.substring(0, n - 1);
        String string3 = string.substring(n + 1, string.length());
        this.or = new BigQuaternion(string2.trim());
        this.oi = new BigQuaternion(string3.trim());
    }

    public BigOctonion factory() {
        return this;
    }

    @Override
    public List<BigOctonion> generators() {
        List<BigQuaternion> list = this.or.generators();
        ArrayList<BigOctonion> arrayList = new ArrayList<BigOctonion>(list.size() * 2);
        for (BigQuaternion bigQuaternion : list) {
            arrayList.add(new BigOctonion(bigQuaternion));
        }
        for (BigQuaternion bigQuaternion : list) {
            arrayList.add(new BigOctonion(BigQuaternion.ZERO, bigQuaternion));
        }
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigOctonion copy() {
        return new BigOctonion(this.or, this.oi);
    }

    @Override
    public BigOctonion copy(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return new BigOctonion();
        }
        return new BigOctonion(bigOctonion.or, bigOctonion.oi);
    }

    @Override
    public BigOctonion getZERO() {
        return ZERO;
    }

    @Override
    public BigOctonion getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigOctonion fromInteger(BigInteger bigInteger) {
        return new BigOctonion(BigOctonion.ONE.or.fromInteger(bigInteger));
    }

    @Override
    public BigOctonion fromInteger(long l) {
        return new BigOctonion(BigOctonion.ONE.or.fromInteger(l));
    }

    public BigQuaternion getR() {
        return this.or;
    }

    public BigQuaternion getI() {
        return this.oi;
    }

    public String toString() {
        String string = "" + this.or;
        int n = this.oi.compareTo(BigQuaternion.ZERO);
        if (this.debug) {
            logger.debug((Object)("compareTo " + n + " ? 0 = " + this.oi));
        }
        if (n == 0) {
            return string;
        }
        string = string + "o" + this.oi;
        return string;
    }

    @Override
    public String toScript() {
        String string;
        boolean bl = this.oi.isZERO();
        if (bl && this.or.isZERO()) {
            return "0 ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.or.isZERO()) {
            string = this.or.toScript();
            string = string.replaceAll("Q", "OR");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        if (!bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+ ");
            }
            string = this.oi.toScript();
            string = string.replaceAll("Q", "OI");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "Oct()";
    }

    public static boolean isOZERO(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return false;
        }
        return bigOctonion.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.or.equals(BigQuaternion.ZERO) && this.oi.equals(BigQuaternion.ZERO);
    }

    public static boolean isOONE(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return false;
        }
        return bigOctonion.isONE();
    }

    @Override
    public boolean isONE() {
        return this.or.equals(BigQuaternion.ONE) && this.oi.equals(BigQuaternion.ZERO);
    }

    public boolean isIMAG() {
        return this.or.equals(BigQuaternion.ZERO) && this.oi.equals(BigQuaternion.ONE);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigOctonion)) {
            return false;
        }
        BigOctonion bigOctonion = (BigOctonion)object;
        return this.or.equals(bigOctonion.or) && this.oi.equals(bigOctonion.oi);
    }

    @Override
    public int hashCode() {
        int n = 41 * this.or.hashCode();
        return n += 41 * this.oi.hashCode();
    }

    @Override
    public int compareTo(BigOctonion bigOctonion) {
        int n = this.or.compareTo(bigOctonion.or);
        if (n != 0) {
            return n;
        }
        return this.oi.compareTo(bigOctonion.oi);
    }

    @Override
    public int signum() {
        int n = this.or.signum();
        if (n != 0) {
            return n;
        }
        return this.oi.signum();
    }

    @Override
    public BigOctonion sum(BigOctonion bigOctonion) {
        return new BigOctonion(this.or.sum(bigOctonion.or), this.oi.sum(bigOctonion.oi));
    }

    public static BigOctonion OSUM(BigOctonion bigOctonion, BigOctonion bigOctonion2) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.sum(bigOctonion2);
    }

    public static BigOctonion ODIF(BigOctonion bigOctonion, BigOctonion bigOctonion2) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.subtract(bigOctonion2);
    }

    @Override
    public BigOctonion subtract(BigOctonion bigOctonion) {
        return new BigOctonion(this.or.subtract(bigOctonion.or), this.oi.subtract(bigOctonion.oi));
    }

    public static BigOctonion ONEG(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.negate();
    }

    @Override
    public BigOctonion negate() {
        return new BigOctonion(this.or.negate(), this.oi.negate());
    }

    public static BigOctonion OCON(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.conjugate();
    }

    @Override
    public BigOctonion conjugate() {
        return new BigOctonion(this.or.conjugate(), this.oi.negate());
    }

    @Override
    public BigOctonion norm() {
        BigQuaternion bigQuaternion = this.or.norm();
        bigQuaternion = bigQuaternion.sum(this.oi.norm());
        return new BigOctonion(bigQuaternion);
    }

    @Override
    public BigOctonion abs() {
        BigOctonion bigOctonion = this.norm();
        logger.error((Object)"abs() square root missing");
        return bigOctonion;
    }

    public static BigRational OABS(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.abs().or.re;
    }

    public static BigOctonion OPROD(BigOctonion bigOctonion, BigOctonion bigOctonion2) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.multiply(bigOctonion2);
    }

    @Override
    public BigOctonion multiply(BigOctonion bigOctonion) {
        BigQuaternion bigQuaternion = this.or.multiply(bigOctonion.or);
        bigQuaternion = bigQuaternion.subtract(bigOctonion.oi.multiply(this.oi.conjugate()));
        BigQuaternion bigQuaternion2 = this.or.conjugate().multiply(bigOctonion.oi);
        bigQuaternion2 = bigQuaternion2.sum(bigOctonion.or.multiply(this.oi));
        return new BigOctonion(bigQuaternion, bigQuaternion2);
    }

    public static BigOctonion OINV(BigOctonion bigOctonion) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.inverse();
    }

    @Override
    public BigOctonion inverse() {
        BigRational bigRational = this.norm().or.re;
        return this.conjugate().divide(bigRational);
    }

    @Override
    public BigOctonion remainder(BigOctonion bigOctonion) {
        if (bigOctonion.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigOctonion OQ(BigOctonion bigOctonion, BigOctonion bigOctonion2) {
        if (bigOctonion == null) {
            return null;
        }
        return bigOctonion.divide(bigOctonion2);
    }

    @Override
    public BigOctonion divide(BigOctonion bigOctonion) {
        return this.multiply(bigOctonion.inverse());
    }

    @Override
    public BigOctonion divide(BigRational bigRational) {
        return new BigOctonion(this.or.divide(bigRational), this.oi.divide(bigRational));
    }

    public BigOctonion[] quotientRemainder(BigOctonion bigOctonion) {
        return new BigOctonion[]{this.divide(bigOctonion), ZERO};
    }

    @Override
    public BigOctonion random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigOctonion random(int n, Random random) {
        BigQuaternion bigQuaternion = BigQuaternion.ONE.random(n, random);
        BigQuaternion bigQuaternion2 = BigQuaternion.ONE.random(n, random);
        return new BigOctonion(bigQuaternion, bigQuaternion2);
    }

    public static BigOctonion ORAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigOctonion parse(String string) {
        return new BigOctonion(string);
    }

    @Override
    public BigOctonion parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigOctonion gcd(BigOctonion bigOctonion) {
        if (bigOctonion == null || bigOctonion.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigOctonion;
        }
        return ONE;
    }

    public BigOctonion[] egcd(BigOctonion bigOctonion) {
        BigOctonion[] bigOctonionArray = new BigOctonion[]{null, null, null};
        if (bigOctonion == null || bigOctonion.isZERO()) {
            bigOctonionArray[0] = this;
            return bigOctonionArray;
        }
        if (this.isZERO()) {
            bigOctonionArray[0] = bigOctonion;
            return bigOctonionArray;
        }
        BigOctonion bigOctonion2 = new BigOctonion(new BigRational(1L, 2L));
        bigOctonionArray[0] = ONE;
        bigOctonionArray[1] = this.inverse().multiply(bigOctonion2);
        bigOctonionArray[2] = bigOctonion.inverse().multiply(bigOctonion2);
        return bigOctonionArray;
    }
}

