/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;

public class HenselApprox<MOD extends GcdRingElem<MOD> & Modular>
implements Serializable {
    public final GenPolynomial<BigInteger> A;
    public final GenPolynomial<BigInteger> B;
    public final GenPolynomial<MOD> Am;
    public final GenPolynomial<MOD> Bm;

    public HenselApprox(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<BigInteger> genPolynomial2, GenPolynomial<MOD> genPolynomial3, GenPolynomial<MOD> genPolynomial4) {
        this.A = genPolynomial;
        this.B = genPolynomial2;
        this.Am = genPolynomial3;
        this.Bm = genPolynomial4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.A.toString());
        stringBuffer.append(",");
        stringBuffer.append(this.B.toString());
        stringBuffer.append(",");
        stringBuffer.append(this.Am.toString());
        stringBuffer.append(",");
        stringBuffer.append(this.Bm.toString());
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.A.toScript());
        stringBuffer.append(",");
        stringBuffer.append(this.B.toScript());
        stringBuffer.append(",");
        stringBuffer.append(this.Am.toScript());
        stringBuffer.append(",");
        stringBuffer.append(this.Bm.toScript());
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.A.hashCode();
        n = 37 * n + this.B.hashCode();
        n = 37 * n + this.Am.hashCode();
        n = 37 * n + this.Bm.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof HenselApprox)) {
            return false;
        }
        HenselApprox henselApprox = (HenselApprox)object;
        return this.A.equals(henselApprox.A) && object.equals(henselApprox.B) && this.Am.equals(henselApprox.Am) && this.Bm.equals(henselApprox.Bm);
    }

    public BigInteger approximationSize() {
        ModularRingFactory modularRingFactory = (ModularRingFactory)this.Am.ring.coFac;
        return modularRingFactory.getIntegerModul();
    }
}

