/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.GCDProxy;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class PolyGBUtilTest
extends TestCase {
    TermOrder to = new TermOrder(4);
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.29f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)PolyGBUtilTest.suite());
        ComputerThreads.terminate();
    }

    public PolyGBUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PolyGBUtilTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testResultantModular() {
        PrimeList primeList = new PrimeList();
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(1));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        GreatestCommonDivisorSimple<ModInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<ModInteger>();
        GreatestCommonDivisorSubres<ModInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<ModInteger>();
        GreatestCommonDivisorModEval greatestCommonDivisorModEval = new GreatestCommonDivisorModEval();
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = greatestCommonDivisorSimple.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial4 = greatestCommonDivisorSubres.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModEval).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            boolean bl3 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial5);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,e): " + genPolynomial5), (boolean)bl3);
        }
    }

    public void testResultantInteger() {
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        GreatestCommonDivisorSimple<BigInteger> greatestCommonDivisorSimple = new GreatestCommonDivisorSimple<BigInteger>();
        GreatestCommonDivisorSubres<BigInteger> greatestCommonDivisorSubres = new GreatestCommonDivisorSubres<BigInteger>();
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial3 = greatestCommonDivisorSimple.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial4 = greatestCommonDivisorSubres.resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial5 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorModular).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            boolean bl3 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial5);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,e): " + genPolynomial5), (boolean)bl3);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
        }
    }

    public void testResultantModularParallel() {
        PrimeList primeList = new PrimeList();
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(1));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModEval greatestCommonDivisorModEval = new GreatestCommonDivisorModEval();
        GCDProxy<ModInteger> gCDProxy = new GCDProxy<ModInteger>(greatestCommonDivisorSubres, greatestCommonDivisorSimple);
        GCDProxy gCDProxy2 = new GCDProxy(greatestCommonDivisorModEval, greatestCommonDivisorSubres);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)gCDProxy).resultant(genPolynomial, genPolynomial2);
            GenPolynomial<ModInteger> genPolynomial4 = ((GreatestCommonDivisorAbstract)gCDProxy2).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
        }
    }

    public void testResultantIntegerProxy() {
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        GreatestCommonDivisorSimple greatestCommonDivisorSimple = new GreatestCommonDivisorSimple();
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorModular greatestCommonDivisorModular = new GreatestCommonDivisorModular();
        GCDProxy<BigInteger> gCDProxy = new GCDProxy<BigInteger>(greatestCommonDivisorSubres, greatestCommonDivisorSimple);
        GCDProxy<BigInteger> gCDProxy2 = new GCDProxy<BigInteger>(greatestCommonDivisorModular, greatestCommonDivisorSubres);
        for (int i = 0; i < 1; ++i) {
            GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll + 1, this.el, this.q);
            GenPolynomial<BigInteger> genPolynomial3 = ((GreatestCommonDivisorAbstract)gCDProxy).resultant(genPolynomial, genPolynomial2);
            GenPolynomial<BigInteger> genPolynomial4 = ((GreatestCommonDivisorAbstract)gCDProxy2).resultant(genPolynomial, genPolynomial2);
            boolean bl = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial3);
            boolean bl2 = PolyGBUtil.isResultant(genPolynomial, genPolynomial2, genPolynomial4);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,d): " + genPolynomial4), (boolean)bl2);
            PolyGBUtilTest.assertTrue((String)("isResultant(a,b,c): " + genPolynomial3), (boolean)bl);
        }
    }

    public void testCoefficientBasePseudoRemainder() {
        GenPolynomial genPolynomial;
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x1", "x2"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        GenPolynomialRing<GenPolynomial<BigRational>> genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)genPolynomialRing2.coFac;
        GenPolynomial genPolynomial2 = genPolynomialRing2.random(this.kl, this.ll, this.el, this.q * 1.1f);
        GenPolynomial genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial2, genPolynomial = genPolynomialRing3.random(this.kl, this.ll + 2, this.el * 2, this.q));
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) <= genPolynomial2.degree(0) || genPolynomial2.degree(0) == 0L ? 1 : 0) != 0);
        PolyGBUtilTest.assertTrue((String)"deg(lfcd(c)) < deg(b): ", (genPolynomial3.leadingBaseCoefficient().degree(0) < genPolynomial.degree(0) || genPolynomial.degree(0) == 0L ? 1 : 0) != 0);
        GenPolynomial genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial4, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"c == 0: ", (boolean)genPolynomial3.isZERO());
        long l = genPolynomial2.degree(0);
        GenPolynomial genPolynomial5 = genPolynomialRing2.univariate(0, l + 1L);
        genPolynomial5 = genPolynomial5.multiply(genPolynomial.multiply(genPolynomial));
        genPolynomial5 = genPolynomial5.sum(genPolynomial2);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial5, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) < genPolynomial5.degree(0) ? 1 : 0) != 0);
    }

    public void testCoefficientRecursivePseudoRemainder() {
        GenPolynomial<GenPolynomial<Element>> genPolynomial;
        BigRational bigRational = new BigRational();
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"x1", "x2", "x3"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.to, stringArray);
        GenPolynomialRing<GenPolynomial<BigRational>> genPolynomialRing2 = genPolynomialRing.recursive(2);
        GenPolynomialRing<GenPolynomial<GenPolynomial<BigRational>>> genPolynomialRing3 = genPolynomialRing2.recursive(1);
        GenPolynomialRing genPolynomialRing4 = (GenPolynomialRing)genPolynomialRing3.coFac;
        GenPolynomial genPolynomial2 = genPolynomialRing3.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial2, genPolynomial = genPolynomialRing4.random(this.kl, this.ll + 2, this.el, this.q));
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) <= genPolynomial2.degree(0) || genPolynomial2.degree(0) == 0L ? 1 : 0) != 0);
        PolyGBUtilTest.assertTrue((String)"deg(lfcd(c)) < deg(b): ", (genPolynomial3.leadingBaseCoefficient().degree(0) < genPolynomial.degree(0) || genPolynomial.degree(0) == 0L ? 1 : 0) != 0);
        GenPolynomial genPolynomial4 = genPolynomial2.multiply(genPolynomial);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial4, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"c == 0: ", (boolean)genPolynomial3.isZERO());
        long l = genPolynomial2.degree(0);
        GenPolynomial genPolynomial5 = genPolynomialRing3.univariate(0, l + 1L);
        genPolynomial5 = genPolynomial5.multiply(genPolynomial.multiply((GenPolynomial<Element>)genPolynomialRing4.fromInteger(100L)));
        genPolynomial5 = genPolynomial5.sum(genPolynomial2);
        genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial5, genPolynomial);
        PolyGBUtilTest.assertTrue((String)"deg(c) < deg(a): ", (genPolynomial3.degree(0) < genPolynomial5.degree(0) ? 1 : 0) != 0);
    }
}

