/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.InvalidExpressionException;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.QuotientRing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class RingFactoryTokenizer {
    private static final Logger logger = Logger.getLogger(RingFactoryTokenizer.class);
    private final boolean debug = logger.isDebugEnabled();
    private String[] vars = null;
    private int nvars = 1;
    private TermOrder tord;
    private RelationTable table;
    private final StreamTokenizer tok;
    private final Reader reader;
    private RingFactory fac;
    private coeffType parsedCoeff = coeffType.BigRat;
    private GenPolynomialRing pfac;
    private polyType parsedPoly = polyType.PolBigRat;
    private GenSolvablePolynomialRing spfac;

    public RingFactoryTokenizer() {
        this(new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF8"))));
    }

    public RingFactoryTokenizer(GenPolynomialRing genPolynomialRing, Reader reader) {
        this(reader);
        if (genPolynomialRing == null) {
            return;
        }
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            this.pfac = genPolynomialRing;
            this.spfac = (GenSolvablePolynomialRing)genPolynomialRing;
        } else {
            this.pfac = genPolynomialRing;
            this.spfac = null;
        }
        this.fac = genPolynomialRing.coFac;
        this.vars = genPolynomialRing.getVars();
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = genPolynomialRing.tord;
        this.table = this.spfac != null ? this.spfac.table : null;
    }

    public RingFactoryTokenizer(Reader reader) {
        this.tord = new TermOrder();
        this.fac = new BigRational(1L);
        this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.reader = reader;
        this.tok = new StreamTokenizer(this.reader);
        this.tok.resetSyntax();
        this.tok.eolIsSignificant(false);
        this.tok.wordChars(48, 57);
        this.tok.wordChars(97, 122);
        this.tok.wordChars(65, 90);
        this.tok.wordChars(95, 95);
        this.tok.wordChars(47, 47);
        this.tok.wordChars(46, 46);
        this.tok.wordChars(160, 255);
        this.tok.whitespaceChars(0, 32);
        this.tok.commentChar(35);
        this.tok.quoteChar(34);
        this.tok.quoteChar(39);
    }

    public void initFactory(RingFactory ringFactory, coeffType coeffType2) {
        this.fac = ringFactory;
        this.parsedCoeff = coeffType2;
        switch (coeffType2) {
            case BigRat: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case RatFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolRatFunc;
                break;
            }
            case ModFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModFunc;
                break;
            }
            case IntFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public void initSolvableFactory(RingFactory ringFactory, coeffType coeffType2) {
        this.fac = ringFactory;
        this.parsedCoeff = coeffType2;
        switch (coeffType2) {
            case BigRat: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case RatFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolRatFunc;
                break;
            }
            case ModFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModFunc;
                break;
            }
            case IntFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public String[] nextVariableList() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.tok.nextToken();
        if (n == 40 || n == 123) {
            logger.debug((Object)"variable list");
            n = this.tok.nextToken();
            while (n != -1 && n != 41 && n != 125) {
                if (n == -3) {
                    arrayList.add(this.tok.sval);
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] objectArray = arrayList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public RingFactory nextCoefficientRing() throws IOException {
        RingFactory<BigRational> ringFactory = null;
        coeffType coeffType2 = null;
        int n = this.tok.nextToken();
        if (this.tok.sval != null) {
            if (this.tok.sval.equalsIgnoreCase("Q")) {
                ringFactory = new BigRational(0L);
                coeffType2 = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("Rat")) {
                ringFactory = new BigRational(0L);
                coeffType2 = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("D")) {
                ringFactory = new BigDecimal(0L);
                coeffType2 = coeffType.BigD;
            } else if (this.tok.sval.equalsIgnoreCase("Z")) {
                ringFactory = new BigInteger(0L);
                coeffType2 = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("Int")) {
                ringFactory = new BigInteger(0L);
                coeffType2 = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("C")) {
                ringFactory = new BigComplex(0L);
                coeffType2 = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Complex")) {
                ringFactory = new BigComplex(0L);
                coeffType2 = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Quat")) {
                ringFactory = new BigQuaternion(0L);
                coeffType2 = coeffType.BigQ;
            } else if (this.tok.sval.equalsIgnoreCase("Mod")) {
                n = this.tok.nextToken();
                boolean bl = false;
                if (n == 91) {
                    bl = true;
                    n = this.tok.nextToken();
                }
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (RingFactoryTokenizer.digit(this.tok.sval.charAt(0))) {
                        BigInteger bigInteger = new BigInteger(this.tok.sval);
                        BigInteger bigInteger2 = new BigInteger(ModLongRing.MAX_LONG);
                        ringFactory = bigInteger.compareTo(bigInteger2) < 0 ? new ModLongRing(bigInteger.getVal()) : new ModIntegerRing(bigInteger.getVal());
                        coeffType2 = coeffType.ModInt;
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                if (n == 93 && bl) {
                    n = this.tok.nextToken();
                }
            } else if (this.tok.sval.equalsIgnoreCase("RatFunc")) {
                String[] stringArray = this.nextVariableList();
                int n2 = stringArray.length;
                BigInteger bigInteger = new BigInteger();
                TermOrder termOrder = new TermOrder(2);
                GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, n2, termOrder, stringArray);
                ringFactory = new QuotientRing<BigInteger>(genPolynomialRing);
                coeffType2 = coeffType.RatFunc;
            } else if (this.tok.sval.equalsIgnoreCase("ModFunc")) {
                n = this.tok.nextToken();
                ModIntegerRing modIntegerRing = new ModIntegerRing("19");
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (RingFactoryTokenizer.digit(this.tok.sval.charAt(0))) {
                        modIntegerRing = new ModIntegerRing(this.tok.sval);
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                String[] stringArray = this.nextVariableList();
                int n3 = stringArray.length;
                TermOrder termOrder = new TermOrder(2);
                GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, n3, termOrder, stringArray);
                ringFactory = new QuotientRing<ModInteger>(genPolynomialRing);
                coeffType2 = coeffType.ModFunc;
            } else if (this.tok.sval.equalsIgnoreCase("IntFunc")) {
                String[] stringArray = this.nextVariableList();
                int n4 = stringArray.length;
                BigRational bigRational = new BigRational();
                TermOrder termOrder = new TermOrder(2);
                GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, n4, termOrder, stringArray);
                ringFactory = genPolynomialRing;
                coeffType2 = coeffType.IntFunc;
            } else if (this.tok.sval.equalsIgnoreCase("AN")) {
                n = this.tok.nextToken();
                if (n == 91) {
                    n = this.tok.nextToken();
                    Iterable<ModInteger> iterable = new ModIntegerRing("19");
                    if (this.tok.sval != null && this.tok.sval.length() > 0) {
                        if (RingFactoryTokenizer.digit(this.tok.sval.charAt(0))) {
                            iterable = new ModIntegerRing(this.tok.sval);
                        } else {
                            iterable = new BigRational();
                            this.tok.pushBack();
                        }
                    } else {
                        iterable = new BigRational();
                        this.tok.pushBack();
                    }
                    Object[] objectArray = this.nextVariableList();
                    int n5 = objectArray.length;
                    if (n5 != 1) {
                        throw new InvalidExpressionException("AlgebraicNumber only for univariate polynomials " + Arrays.toString(objectArray));
                    }
                    String[] stringArray = this.vars;
                    this.vars = objectArray;
                    GenPolynomialRing genPolynomialRing = this.pfac;
                    RingFactory ringFactory2 = this.fac;
                    this.fac = iterable;
                    this.pfac = iterable instanceof ModIntegerRing ? new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)iterable), n5, new TermOrder(), (String[])objectArray) : new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)iterable), n5, new TermOrder(), (String[])objectArray);
                    if (this.debug) {
                        logger.debug((Object)("pfac = " + this.pfac));
                    }
                    GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this.pfac, this.reader);
                    GenPolynomial genPolynomial = genPolynomialTokenizer.nextPolynomial();
                    genPolynomialTokenizer = null;
                    if (this.debug) {
                        logger.debug((Object)("mod = " + genPolynomial));
                    }
                    this.pfac = genPolynomialRing;
                    this.fac = ringFactory2;
                    this.vars = stringArray;
                    if (iterable instanceof ModIntegerRing) {
                        GenPolynomial genPolynomial2 = genPolynomial;
                        ringFactory = new AlgebraicNumberRing(genPolynomial2);
                        coeffType2 = coeffType.ANmod;
                    } else {
                        GenPolynomial genPolynomial3 = genPolynomial;
                        ringFactory = new AlgebraicNumberRing(genPolynomial3);
                        coeffType2 = coeffType.ANrat;
                    }
                    if (this.debug) {
                        logger.debug((Object)("coeff = " + ringFactory));
                    }
                    if ((n = this.tok.nextToken()) != 93) {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
            }
        }
        if (ringFactory == null) {
            this.tok.pushBack();
            ringFactory = new BigRational();
            coeffType2 = coeffType.BigRat;
        }
        this.parsedCoeff = coeffType2;
        return ringFactory;
    }

    public long[] nextWeightList() throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long[] lArray = null;
        int n = this.tok.nextToken();
        if (n == 40) {
            logger.debug((Object)"weight list");
            n = this.tok.nextToken();
            while (n != -1 && n != 41) {
                char c;
                if (this.tok.sval != null && RingFactoryTokenizer.digit(c = this.tok.sval.charAt(0))) {
                    long l = Long.parseLong(this.tok.sval);
                    arrayList.add(l);
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] objectArray = arrayList.toArray();
        lArray = new long[objectArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (Long)objectArray[objectArray.length - i - 1];
        }
        return lArray;
    }

    public long[][] nextWeightArray() throws IOException {
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        Object object = null;
        int n = this.tok.nextToken();
        if (n == 40) {
            logger.debug((Object)"weight array");
            n = this.tok.nextToken();
            while (n != -1 && n != 41) {
                char c;
                long[] lArray;
                if (n == 40) {
                    this.tok.pushBack();
                    lArray = this.nextWeightList();
                    arrayList.add(lArray);
                } else if (this.tok.sval != null && RingFactoryTokenizer.digit(c = this.tok.sval.charAt(0))) {
                    this.tok.pushBack();
                    this.tok.pushBack();
                    lArray = this.nextWeightList();
                    arrayList.add(lArray);
                    break;
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] objectArray = arrayList.toArray();
        object = new long[objectArray.length][];
        for (int i = 0; i < ((long[][])object).length; ++i) {
            object[i] = (long[])objectArray[i];
        }
        return object;
    }

    public int nextSplitIndex() throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = this.tok.nextToken();
        if (n3 == 124) {
            if (this.debug) {
                logger.debug((Object)"split index");
            }
            if ((n3 = this.tok.nextToken()) == -1) {
                return n;
            }
            if (this.tok.sval != null) {
                char c = this.tok.sval.charAt(0);
                if (RingFactoryTokenizer.digit(c)) {
                    n = Integer.parseInt(this.tok.sval);
                }
                if ((n3 = this.tok.nextToken()) != 124) {
                    this.tok.pushBack();
                }
            }
        } else if (n3 == 91) {
            if (this.debug) {
                logger.debug((Object)"split index");
            }
            if ((n3 = this.tok.nextToken()) == -1) {
                return n;
            }
            if (this.tok.sval != null) {
                char c = this.tok.sval.charAt(0);
                if (RingFactoryTokenizer.digit(c)) {
                    n2 = Integer.parseInt(this.tok.sval);
                }
                if ((n3 = this.tok.nextToken()) == 44) {
                    n3 = this.tok.nextToken();
                    if (n3 == -1) {
                        return n2;
                    }
                    if (this.tok.sval != null && RingFactoryTokenizer.digit(c = this.tok.sval.charAt(0))) {
                        n = Integer.parseInt(this.tok.sval);
                    }
                    if (n3 != 93) {
                        this.tok.pushBack();
                    }
                }
            }
        } else {
            this.tok.pushBack();
        }
        return n;
    }

    public TermOrder nextTermOrder() throws IOException {
        int n;
        int n2 = 4;
        int n3 = this.tok.nextToken();
        if (n3 != -1) {
            if (n3 == -3) {
                if (this.tok.sval != null) {
                    if (this.tok.sval.equalsIgnoreCase("L")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("IL")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("INVLEX")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("LEX")) {
                        n2 = 1;
                    } else if (this.tok.sval.equalsIgnoreCase("G")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IG")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IGRLEX")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("GRLEX")) {
                        n2 = 3;
                    } else if (this.tok.sval.equalsIgnoreCase("W")) {
                        long[][] lArray = this.nextWeightArray();
                        return new TermOrder(lArray);
                    }
                }
            } else {
                this.tok.pushBack();
            }
        }
        if ((n = this.nextSplitIndex()) <= 0) {
            return new TermOrder(n2);
        }
        return new TermOrder(n2, n2, this.nvars, n);
    }

    public void nextRelationTable() throws IOException {
        Object object;
        if (this.spfac == null) {
            return;
        }
        RelationTable relationTable = this.spfac.table;
        List<GenPolynomial> list = null;
        int n = this.tok.nextToken();
        if (this.debug) {
            logger.debug((Object)("start relation table: " + n));
        }
        if (this.tok.sval != null && this.tok.sval.equalsIgnoreCase("RelationTable")) {
            object = new GenPolynomialTokenizer(this.pfac, this.reader);
            list = ((GenPolynomialTokenizer)object).nextPolynomialList();
            object = null;
        }
        if (list == null) {
            this.tok.pushBack();
            return;
        }
        object = list.iterator();
        while (object.hasNext()) {
            GenPolynomial genPolynomial = (GenPolynomial)object.next();
            ExpVector expVector = genPolynomial.leadingExpVector();
            if (!object.hasNext()) continue;
            genPolynomial = (GenPolynomial)object.next();
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            if (!object.hasNext()) continue;
            genPolynomial = (GenPolynomial)object.next();
            GenSolvablePolynomial genSolvablePolynomial = new GenSolvablePolynomial(this.spfac);
            genSolvablePolynomial.doPutToMap(genPolynomial.getMap());
            relationTable.update(expVector, expVector2, genSolvablePolynomial);
        }
        if (this.debug) {
            logger.info((Object)("table = " + relationTable));
        }
    }

    public GenPolynomialRing nextPolynomialRing() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + ringFactory));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(ringFactory, this.parsedCoeff);
        return this.pfac;
    }

    public GenSolvablePolynomialRing nextSolvablePolynomialRing() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + ringFactory.getClass().getSimpleName()));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(ringFactory, this.parsedCoeff);
        this.initSolvableFactory(ringFactory, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("table = " + this.table + ", tok = " + this.tok));
        }
        return this.spfac;
    }

    static boolean digit(char c) {
        return '0' <= c && c <= '9';
    }

    public void nextComma() throws IOException {
        if (this.tok.ttype == 44) {
            int n = this.tok.nextToken();
            if (this.debug) {
                logger.debug((Object)("after comma: " + n));
            }
        }
    }

    public static String[] variableList(String string) {
        String[] stringArray = null;
        if (string == null) {
            return stringArray;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new String[0];
        }
        if (string2.charAt(0) == '(') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == ')') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2 = string2.replaceAll(",", " ");
        ArrayList<String> arrayList = new ArrayList<String>();
        Scanner scanner = new Scanner(string2);
        while (scanner.hasNext()) {
            String string3 = scanner.next();
            arrayList.add(string3);
        }
        scanner.close();
        stringArray = new String[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string4;
            stringArray[n] = string4 = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    private static enum polyType {
        PolBigRat,
        PolBigInt,
        PolModInt,
        PolBigC,
        PolBigD,
        PolBigQ,
        PolANrat,
        PolANmod,
        PolRatFunc,
        PolModFunc,
        PolIntFunc;

    }

    private static enum coeffType {
        BigRat,
        BigInt,
        ModInt,
        BigC,
        BigQ,
        BigD,
        ANrat,
        ANmod,
        RatFunc,
        ModFunc,
        IntFunc;

    }
}

