/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GroebnerBasePartial;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.util.KsubSet;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class GroebnerBasePartTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bb;
    GroebnerBasePartial<BigRational> bbp;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)GroebnerBasePartTest.suite());
    }

    public GroebnerBasePartTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBasePartTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseSeq<BigRational>();
        this.bbp = new GroebnerBasePartial();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testTrinks7GBasePartRec() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePartTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePartTest.fail((String)("" + iOException));
        }
        OptimizedPolynomialList<GenPolynomial<BigRational>> optimizedPolynomialList = this.bbp.partialGBrec(this.F.list, new String[]{"P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGBrec(optimizedPolynomialList.list));
        OptimizedPolynomialList<BigRational> optimizedPolynomialList2 = this.bbp.partialGB(this.F.list, new String[]{"P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(optimizedPolynomialList2.list));
    }

    public void testTrinks7GBasePart() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePartTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePartTest.fail((String)("" + iOException));
        }
        OptimizedPolynomialList<BigRational> optimizedPolynomialList = this.bbp.partialGB(this.F.list, new String[]{"B", "S", "P", "Z", "T", "W"});
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(optimizedPolynomialList.list));
        try {
            OptimizedPolynomialList<GenPolynomial<BigRational>> optimizedPolynomialList2 = this.bbp.partialGBrec(this.F.list, new String[]{"B", "S", "P", "Z", "T", "W"});
            GroebnerBasePartTest.fail((String)"must throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPartialPermutation() {
        String[] stringArray = new String[]{"B", "S", "T", "Z", "P", "W"};
        String[] stringArray2 = new String[]{"P", "Z", "T", "W"};
        String[] stringArray3 = new String[]{"S", "B"};
        List<Integer> list = GroebnerBasePartial.partialPermutation(stringArray, stringArray2);
        List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, null);
        GroebnerBasePartTest.assertEquals((String)"perm1 == perm2 ", list, list2);
        List<Integer> list3 = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, stringArray3);
        GroebnerBasePartTest.assertFalse((String)"perm1 != perm3 ", (boolean)list.equals(list3));
    }

    public void xtestElimPartialPermutation() {
        String[] stringArray = new String[]{"B", "S", "T", "Z", "P", "W"};
        String[] stringArray2 = new String[]{"P", "Z"};
        String[] stringArray3 = new String[]{"T", "W"};
        String[] stringArray4 = new String[]{"B", "S"};
        List<Integer> list = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, stringArray3, stringArray4);
        System.out.println("perm1 = " + list);
        List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, stringArray3, null);
        System.out.println("perm2 = " + list2);
        GroebnerBasePartTest.assertEquals((String)"perm1 == perm2 ", list, list2);
        stringArray4 = new String[]{"S", "B"};
        List<Integer> list3 = GroebnerBasePartial.partialPermutation(stringArray, stringArray2, stringArray3, stringArray4);
        System.out.println("perm3 = " + list3);
        GroebnerBasePartTest.assertFalse((String)"perm1 != perm3 ", (boolean)list.equals(list3));
    }

    public void testTrinks7GBaseElimPart() {
        String string = "(B,S,T,Z,P,W) G ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePartTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePartTest.fail((String)("" + iOException));
        }
        String[] stringArray = new String[]{"P", "Z"};
        String[] stringArray2 = new String[]{"B", "S", "T", "W"};
        OptimizedPolynomialList<BigRational> optimizedPolynomialList = this.bbp.elimPartialGB(this.F.list, stringArray, stringArray2);
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbp.isGB(optimizedPolynomialList.list));
    }

    public void testGBasePart() {
        String string = "(a,b,c,d,e,f) G ( ( a ), ( b^2 ), ( c^3 ), ( d^4 ), ( e^5 ), ( f^6 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePartTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePartTest.fail((String)("" + iOException));
        }
        String[] stringArray = new String[]{"a", "b"};
        OptimizedPolynomialList<BigRational> optimizedPolynomialList = this.bbp.partialGB(this.F.list, stringArray);
        GroebnerBasePartTest.assertTrue((String)"isGB( GB(G) )", (boolean)this.bbp.isGB(optimizedPolynomialList.list));
    }

    public void testPermGen() {
        String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f"};
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        String string = "(a,b,c,d,e,f) G ( ( a ), ( b^2 ), ( c^3 ), ( d^4 ), ( e^5 ), ( f^6 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePartTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePartTest.fail((String)("" + iOException));
        }
        for (int i = 0; i <= stringArray.length; ++i) {
            KsubSet ksubSet = new KsubSet(arrayList, i);
            for (List list : ksubSet) {
                Object[] objectArray = new String[list.size()];
                for (int j = 0; j < list.size(); ++j) {
                    objectArray[j] = (String)list.get(j);
                }
                String[] stringArray2 = GroebnerBasePartial.remainingVars(stringArray, (String[])objectArray);
                List<Integer> list2 = GroebnerBasePartial.partialPermutation(stringArray, (String[])objectArray);
                List<Integer> list3 = GroebnerBasePartial.getPermutation(stringArray, stringArray2);
                GroebnerBasePartTest.assertEquals((String)("perm1 == perm2 " + Arrays.toString(objectArray)), list2, list3);
                GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.fac.coFac, stringArray);
                GenPolynomialRing genPolynomialRing2 = TermOrderOptimization.permutation(list2, genPolynomialRing);
                GenPolynomialRing genPolynomialRing3 = TermOrderOptimization.permutation(list3, genPolynomialRing);
                GroebnerBasePartTest.assertEquals((String)"pr1 == pr2 ", genPolynomialRing2, genPolynomialRing3);
                List list4 = TermOrderOptimization.permutation(list2, genPolynomialRing2, polynomialList.list);
                List list5 = TermOrderOptimization.permutation(list3, genPolynomialRing3, polynomialList.list);
                GroebnerBasePartTest.assertEquals((String)"pF1 == pF2 ", list4, list5);
            }
        }
    }
}

