/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.RemoteExecutable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class Executor
extends Thread {
    private static final Logger logger = Logger.getLogger(Executor.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final SocketChannel channel;

    Executor(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RemoteExecutable remoteExecutable = null;
        boolean bl = true;
        logger.debug((Object)("executor started " + this));
        while (bl) {
            try {
                Object object = this.channel.receive();
                logger.info((Object)("receive: " + object + " from " + this.channel));
                if (this.isInterrupted()) {
                    bl = false;
                    continue;
                }
                if (this.debug) {
                    logger.debug((Object)("receive: " + object + " from " + this.channel));
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if ("Stop".equals(string)) {
                        bl = false;
                        this.channel.send("Done");
                    } else {
                        logger.warn((Object)("invalid/unknown String: " + string + " from " + this.channel));
                        bl = false;
                        this.channel.send("Done");
                    }
                }
                if (!(object instanceof RemoteExecutable)) continue;
                remoteExecutable = (RemoteExecutable)object;
                if (this.debug) {
                    logger.info((Object)("running " + remoteExecutable));
                }
                try {
                    remoteExecutable.run();
                }
                catch (Exception exception) {
                    logger.info((Object)("Exception on re.run()" + exception));
                    exception.printStackTrace();
                }
                finally {
                    logger.info((Object)("finally re.run() " + remoteExecutable));
                }
                if (this.debug) {
                    logger.info((Object)("finished " + remoteExecutable));
                }
                if (this.isInterrupted()) {
                    bl = false;
                    continue;
                }
                this.channel.send("Done");
                logger.info((Object)"finished send Done");
            }
            catch (IOException iOException) {
                bl = false;
                logger.info((Object)("IOException " + iOException));
                if (!this.debug) continue;
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                logger.info((Object)("ClassNotFoundException " + classNotFoundException));
                classNotFoundException.printStackTrace();
            }
            finally {
                logger.info((Object)("finally " + this));
            }
        }
        logger.info((Object)("executor terminated " + this));
        this.channel.close();
    }
}

