/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Dimension;
import edu.jas.application.SolvableIdeal;
import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableIdealTest
extends TestCase {
    TermOrder to;
    GenSolvablePolynomialRing<BigRational> fac;
    List<GenSolvablePolynomial<BigRational>> L;
    List<GenSolvablePolynomial<BigRational>> M;
    PolynomialList<BigRational> F;
    List<GenSolvablePolynomial<BigRational>> G;
    SolvableGroebnerBase<BigRational> bb;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    int rl = 4;
    int kl = 3;
    int ll = 3;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableIdealTest.suite());
    }

    public SolvableIdealTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableIdealTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder();
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.fac);
        this.bb = new SolvableGroebnerBaseSeq<BigRational>();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        ComputerThreads.terminate();
    }

    public void testIdealSum() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( I )", (!solvableIdeal.isONE() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( I )", (!solvableIdeal.isONE() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        this.L = this.bb.leftGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        this.L = this.bb.leftGB(this.L);
        SolvableIdealTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal;
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"equals( K, I )", (boolean)solvableIdeal3.equals(solvableIdeal));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        SolvableIdealTest.assertTrue((String)"isGB( { c } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"K contains(I)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        SolvableIdealTest.assertTrue((String)"isGB( { d } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"K contains(I)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal3.contains(solvableIdeal2));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        SolvableIdealTest.assertTrue((String)"isGB( { e } )", (boolean)this.bb.isLeftGB(this.L));
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal3;
        solvableIdeal3 = solvableIdeal2.sum(solvableIdeal);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"equals( K, I )", (boolean)solvableIdeal3.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"K contains(J)", (boolean)solvableIdeal3.contains(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"I contains(K)", (boolean)solvableIdeal.contains(solvableIdeal3));
    }

    public void testSolvableIdealProduct() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( I )", (!solvableIdeal.isONE() || this.a.isConstant() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdeal<BigRational> solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, false);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( J )", (!solvableIdeal2.isONE() || this.a.isConstant() || this.b.isConstant() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        SolvableIdeal<BigRational> solvableIdeal4 = solvableIdeal.intersect(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal4));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal2.contains(solvableIdeal4));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal.intersect(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal4));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal2.contains(solvableIdeal4));
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal.intersect(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        SolvableIdealTest.assertTrue((String)"I contains(H)", (boolean)solvableIdeal.contains(solvableIdeal4));
        SolvableIdealTest.assertTrue((String)"J contains(H)", (boolean)solvableIdeal2.contains(solvableIdeal4));
    }

    public void testSolvableIdealQuotient() {
        this.a = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl, this.ll, this.el - 1, this.q);
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        SolvableIdeal<BigRational> solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2.getList().get(0));
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal2 = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( J )", (!solvableIdeal2.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal3 = solvableIdeal.product(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        SolvableIdealTest.assertTrue((String)"J contains(K)", (boolean)solvableIdeal2.contains(solvableIdeal3));
        solvableIdeal4 = solvableIdeal3.quotient(solvableIdeal2);
        SolvableIdealTest.assertTrue((String)"not isZERO( H )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( H )", (boolean)solvableIdeal4.isGB());
    }

    public void testSolvableIdealInfiniteQuotient() {
        this.a = this.fac.random(this.kl, this.ll - 2, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.fac.random(this.kl, this.ll / 2, this.el - 1, this.q / 2.0f);
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        this.G = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.leftGB(this.G);
        SolvableIdeal<BigRational> solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.leftGB(this.G);
        solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal3.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal3.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotient(solvableIdeal3);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
    }

    public void testSolvableIdealInfiniteQuotientRabi() {
        this.fac = new GenSolvablePolynomialRing(this.fac.coFac, this.rl, this.fac.tord, this.fac.getVars());
        this.a = this.fac.random(this.kl - 1, this.ll - 1, this.el - 1, this.q / 2.0f);
        this.b = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.d = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        this.e = this.a;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdeal<BigRational> solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(this.a);
        SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
        this.G = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdealTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.G.add(this.a);
        this.G = this.bb.leftGB(this.G);
        SolvableIdeal<BigRational> solvableIdeal4 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(solvableIdeal4);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
        SolvableIdealTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.G.add(this.e);
        this.G = this.bb.leftGB(this.G);
        solvableIdeal4 = new SolvableIdeal<BigRational>(this.fac, this.G, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( K )", (!solvableIdeal4.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( K )", (boolean)solvableIdeal4.isGB());
        solvableIdeal2 = solvableIdeal.infiniteQuotientRab(solvableIdeal4);
        SolvableIdealTest.assertTrue((String)"equals(J,I)", (boolean)solvableIdeal2.equals(solvableIdeal));
        solvableIdeal3 = solvableIdeal.infiniteQuotient(this.a);
        SolvableIdealTest.assertTrue((String)"equals(J,JJ)", (boolean)solvableIdeal2.equals(solvableIdeal3));
    }

    public void testSolvableIdealRadicalMember() {
        this.fac = new GenSolvablePolynomialRing(this.fac.coFac, this.rl, this.fac.tord, this.fac.getVars());
        this.a = this.fac.random(this.kl - 1, this.ll, this.el - 1, this.q);
        this.b = this.fac.random(this.kl - 1, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl - 1, this.ll - 1, this.el, this.q / 2.0f);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)"a in radical(b)", (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)"b in radical(b)", (boolean)solvableIdeal.isRadicalMember(this.b));
        }
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.b.multiply((BigRational)((Object)this.b)));
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)"a in radical(b*b)", (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)"b in radical(b*b)", (boolean)solvableIdeal.isRadicalMember(this.b));
        }
        this.L.add(this.c);
        this.L = this.bb.leftGB(this.L);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        if (!solvableIdeal.isONE() && !this.a.equals(this.b)) {
            SolvableIdealTest.assertFalse((String)"a in radical(b*b,c)", (boolean)solvableIdeal.isRadicalMember(this.a));
            SolvableIdealTest.assertTrue((String)"b in radical(b*b,c)", (boolean)solvableIdeal.isRadicalMember(this.b));
        }
    }

    public void testSolvableIdealCommonZeros() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)-1);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)0);
        this.L.remove(0);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"commonZeroTest( I )", (int)solvableIdeal.commonZeroTest(), (int)1);
    }

    public void testSolvableIdealDimension() {
        Dimension dimension;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)solvableIdeal.dimension().d);
        this.a = this.fac.getZERO();
        this.L.add(this.a);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)this.rl, (int)solvableIdeal.dimension().d);
        this.b = this.fac.getONE();
        this.L.add(this.b);
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)-1, (int)solvableIdeal.dimension().d);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (!this.a.isZERO() && !this.a.isConstant()) {
            this.L.add(this.a);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertTrue((String)"dimension( I )", (dimension.d >= 1 ? 1 : 0) != 0);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        dimension = solvableIdeal.dimension();
        SolvableIdealTest.assertEquals((String)"dimension( I )", (int)0, (int)dimension.d);
        while (this.L.size() > 0) {
            this.L.remove(0);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertEquals((String)"dimension( I )", (int)(this.rl - this.L.size()), (int)dimension.d);
        }
        this.L = this.fac.univariateList();
        solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        solvableIdeal = solvableIdeal.product(solvableIdeal);
        dimension = solvableIdeal.dimension();
        SolvableIdealTest.assertTrue((String)"dimension( I )", (0 >= dimension.d ? 1 : 0) != 0);
        this.L = solvableIdeal.getList();
        while (this.L.size() > 0) {
            this.L.remove(0);
            solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
            dimension = solvableIdeal.dimension();
            SolvableIdealTest.assertTrue((String)"dimension( I )", (dimension.d > 0 ? 1 : 0) != 0);
        }
    }

    public void testElimSolvableIdeal() {
        int n;
        String[] stringArray = this.fac.getVars();
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.univariate(0, 3L);
        this.b = this.fac.univariate(1, 2L);
        this.c = this.fac.univariate(0, 1L);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L);
        solvableIdeal.doGB();
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"not isONE( I )", (!solvableIdeal.isONE() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 2; n <= stringArray.length; n += 2) {
            KsubSet ksubSet = new KsubSet(arrayList, n);
            Iterator iterator = ksubSet.iterator();
            if (!iterator.hasNext()) continue;
            List list = iterator.next();
            String[] stringArray2 = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray2[i] = (String)list.get(i);
            }
            GenSolvablePolynomialRing genSolvablePolynomialRing = new GenSolvablePolynomialRing(this.fac.coFac, stringArray2.length, this.fac.tord, stringArray2);
            WeylRelations weylRelations = new WeylRelations();
            weylRelations.generate(genSolvablePolynomialRing);
            SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.eliminate(genSolvablePolynomialRing);
            SolvableIdealTest.assertTrue((String)"isGB( J )", (boolean)solvableIdeal2.isGB());
            SolvableIdealTest.assertTrue((String)"size( J ) <=  |ev|", (solvableIdeal2.getList().size() <= list.size() ? 1 : 0) != 0);
        }
    }

    public void testUnivPoly() {
        BigRational bigRational = new BigRational(17L, 1L);
        this.to = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.fac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.rl, this.to, stringArray);
        stringArray = this.fac.getVars();
        SolvableIdealTest.assertTrue((String)"vars.length == 4 ", (stringArray.length == 4 ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.a = this.fac.parse("( x^3 + 34/55 x^2 + 1/9 x + 99 )");
        this.b = this.fac.parse("( y^4 - x )");
        this.c = this.fac.parse("( z^3 - x y )");
        this.d = this.fac.parse("( w^2 + 3 )");
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        this.L.add(this.d);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L);
        SolvableIdealTest.assertTrue((String)"not isZERO( I )", (!solvableIdeal.isZERO() ? 1 : 0) != 0);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        for (int i = 0; i < this.rl; ++i) {
            GenSolvablePolynomial<BigRational> genSolvablePolynomial = solvableIdeal.constructUnivariate(this.rl - 1 - i);
            GenPolynomial genPolynomial = this.fac.parse(genSolvablePolynomial.toString());
            SolvableIdealTest.assertTrue((String)"I.contains(U) ", (boolean)solvableIdeal.contains((GenSolvablePolynomial<BigRational>)genPolynomial));
        }
        List<GenSolvablePolynomial<BigRational>> list = solvableIdeal.constructUnivariate();
        for (GenSolvablePolynomial genSolvablePolynomial : list) {
            GenPolynomial genPolynomial = this.fac.parse(genSolvablePolynomial.toString());
            SolvableIdealTest.assertTrue((String)"I.contains(U) ", (boolean)solvableIdeal.contains((GenSolvablePolynomial<BigRational>)genPolynomial));
        }
    }

    public void testAnnihilator() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.a.isConstant());
        this.b = this.fac.univariate(1);
        this.c = this.fac.univariate(this.rl - 1);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L.add(this.b);
        this.L = this.bb.leftGB(this.L);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.fac, this.L, true);
        SolvableIdealTest.assertTrue((String)"isGB( I )", (boolean)solvableIdeal.isGB());
        SolvableIdeal<BigRational> solvableIdeal2 = solvableIdeal.annihilator(this.c);
        solvableIdeal2.doGB();
        SolvableIdealTest.assertTrue((String)"isAnnihilator(c,J)", (boolean)solvableIdeal.isAnnihilator(this.c, solvableIdeal2));
        this.d = this.fac.univariate(this.rl - 2);
        this.M = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.M.add(this.c);
        this.M.add(this.d);
        SolvableIdeal<BigRational> solvableIdeal3 = new SolvableIdeal<BigRational>(this.fac, this.M);
        solvableIdeal2 = solvableIdeal.annihilator(solvableIdeal3);
        solvableIdeal2.doGB();
        SolvableIdealTest.assertTrue((String)"isAnnihilator(M,J)", (boolean)solvableIdeal.isAnnihilator(solvableIdeal3, solvableIdeal2));
    }
}

