/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import org.apache.log4j.Logger;

class ReducerServerEC<C extends RingElem<C>>
implements Runnable {
    private final Terminator pool;
    private final ChannelFactory cf;
    private SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private static final Logger logger = Logger.getLogger(ReducerServerEC.class);

    ReducerServerEC(Terminator terminator, ChannelFactory channelFactory, DistHashTable<Integer, GenPolynomial<C>> distHashTable, PairList<C> pairList) {
        this.pool = terminator;
        this.cf = channelFactory;
        this.theList = distHashTable;
        this.pairlist = pairList;
    }

    @Override
    public void run() {
        block30: {
            logger.info((Object)("reducer server running with " + this.cf));
            try {
                this.pairChannel = this.cf.getChannel();
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)"get pair channel interrupted");
                interruptedException.printStackTrace();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pairChannel = " + this.pairChannel));
            }
            GenPolynomial genPolynomial = null;
            boolean bl = false;
            boolean bl2 = true;
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (bl2) {
                logger.info((Object)"receive request");
                Object object = null;
                try {
                    object = this.pairChannel.receive();
                }
                catch (IOException iOException) {
                    bl2 = false;
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = false;
                    classNotFoundException.printStackTrace();
                }
                if (object == null) {
                    bl2 = false;
                    break;
                }
                if (!(object instanceof GBTransportMessReq)) {
                    bl2 = false;
                    break;
                }
                logger.debug((Object)"find pair");
                while (!this.pairlist.hasNext()) {
                    if (!bl) {
                        this.pool.beIdle();
                        bl = true;
                    }
                    if (!this.pool.hasJobs() && !this.pairlist.hasNext()) {
                        bl2 = false;
                        break;
                    }
                    try {
                        if (++n3 % 10 == 0) {
                            logger.info((Object)("reducer is sleeping, pool = " + this.pool));
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = false;
                        break;
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    bl2 = false;
                    break;
                }
                if (!this.pairlist.hasNext() && !this.pool.hasJobs()) {
                    bl2 = false;
                    break;
                }
                if (bl) {
                    bl = false;
                    this.pool.notIdle();
                }
                Pair<C> pair = this.pairlist.removeNext();
                logger.debug((Object)("send pair = " + pair));
                GBTransportMess gBTransportMess = null;
                gBTransportMess = pair != null ? new GBTransportMessPairIndex(pair) : new GBTransportMess();
                try {
                    this.pairChannel.send(gBTransportMess);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl2 = false;
                    break;
                }
                logger.debug((Object)("#distributed list = " + this.theList.size()));
                Object object2 = null;
                try {
                    object2 = this.pairChannel.receive();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl2 = false;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    bl2 = false;
                    break;
                }
                if (object2 == null) {
                    if (pair == null) continue;
                    pair.setZero();
                    continue;
                }
                if (!(object2 instanceof GBTransportMessPoly)) continue;
                ++n2;
                genPolynomial = ((GBTransportMessPoly)object2).pol;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("H = " + genPolynomial));
                }
                if (genPolynomial == null) {
                    if (pair == null) continue;
                    pair.setZero();
                    continue;
                }
                if (genPolynomial.isZERO()) {
                    pair.setZero();
                    continue;
                }
                if (genPolynomial.isONE()) {
                    n = this.pairlist.putOne();
                    this.theList.putWait(n, genPolynomial);
                    bl2 = false;
                    break;
                }
                n = this.pairlist.put(genPolynomial);
                this.theList.putWait(n, genPolynomial);
            }
            logger.info((Object)("terminated, done " + n2 + " reductions"));
            logger.debug((Object)"send end");
            try {
                this.pairChannel.send(new GBTransportMessEnd());
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block30;
                iOException.printStackTrace();
            }
        }
        this.pool.beIdle();
        this.pairChannel.close();
    }
}

