/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeqPairParallel;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableGroebnerBaseSeqPairParTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    List<GenSolvablePolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    GenSolvablePolynomialRing<BigRational> ring;
    SolvableGroebnerBase<BigRational> psbb;
    BigRational cfac;
    TermOrder tord;
    RelationTable<BigRational> table;
    int rl = 4;
    int kl = 10;
    int ll = 4;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableGroebnerBaseSeqPairParTest.suite());
    }

    public SolvableGroebnerBaseSeqPairParTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableGroebnerBaseSeqPairParTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(9L);
        this.tord = new TermOrder();
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.psbb = new SolvableGroebnerBaseSeqPairParallel<BigRational>();
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.table = null;
        this.cfac = null;
        ((SolvableGroebnerBaseSeqPairParallel)this.psbb).terminate();
        this.psbb = null;
    }

    public void testParallelGBase() {
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.psbb.isLeftGB(this.L));
    }

    public void testWeylParallelGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.psbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.psbb.leftGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.psbb.isLeftGB(this.L));
    }

    public void testParallelTSGBase() {
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.psbb.isTwosidedGB(this.L));
    }

    public void testWeylParallelTSGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.psbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.psbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqPairParTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.psbb.isTwosidedGB(this.L));
    }
}

