/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class GBProxy<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GBProxy.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<C> e1;
    public final GroebnerBaseAbstract<C> e2;
    protected transient ExecutorService pool;

    public GBProxy(GroebnerBaseAbstract<C> groebnerBaseAbstract, GroebnerBaseAbstract<C> groebnerBaseAbstract2) {
        this.e1 = groebnerBaseAbstract;
        this.e2 = groebnerBaseAbstract2;
        this.pool = ComputerThreads.getPool();
    }

    @Override
    public String toString() {
        return "GBProxy[ " + this.e1.toString() + ", " + this.e2.toString() + " ]";
    }

    @Override
    public void terminate() {
        this.e1.terminate();
        this.e2.terminate();
    }

    @Override
    public int cancel() {
        int n = this.e1.cancel();
        return n += this.e2.cancel();
    }

    @Override
    public List<GenPolynomial<C>> GB(final int n, final List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List list2 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<List<GenPolynomial<C>>>(){

            @Override
            public List<GenPolynomial<C>> call() {
                try {
                    List list2 = GBProxy.this.e1.GB(n, list);
                    if (GBProxy.this.debug) {
                        logger.info((Object)("GBProxy done e1 " + GBProxy.this.e1.getClass().getName()));
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GBProxy e1 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info((Object)("GBProxy e1 " + exception));
                    logger.info((Object)("Exception GBProxy F = " + list));
                    throw new RuntimeException("GBProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<List<GenPolynomial<C>>>(){

            @Override
            public List<GenPolynomial<C>> call() {
                try {
                    List list2 = GBProxy.this.e2.GB(n, list);
                    if (GBProxy.this.debug) {
                        logger.info((Object)("GBProxy done e2 " + GBProxy.this.e2.getClass().getName()));
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("GBProxy e2 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info((Object)("GBProxy e2 " + exception));
                    logger.info((Object)("Exception GBProxy F = " + list));
                    throw new RuntimeException("GBProxy e2 " + exception);
                }
            }
        });
        try {
            list2 = (List)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info((Object)("InterruptedException " + interruptedException));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info((Object)("ExecutionException " + executionException));
            Thread.currentThread().interrupt();
        }
        return list2;
    }
}

