/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.SquarefreeAbstract;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeFieldChar0<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeFieldChar0.class);
    protected final RingFactory<C> coFac;

    public SquarefreeFieldChar0(RingFactory<C> ringFactory) {
        super(GCDFactory.getProxy(ringFactory));
        if (!ringFactory.isField()) {
            throw new IllegalArgumentException("fac must be a field");
        }
        if (ringFactory.characteristic().signum() != 0) {
            throw new IllegalArgumentException("characterisic(fac) must be zero");
        }
        this.coFac = ringFactory;
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (genPolynomial2.isConstant()) {
            return genPolynomial2;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        genPolynomial3 = genPolynomial3.monic();
        GenPolynomial<C> genPolynomial4 = this.engine.baseGcd(genPolynomial2, genPolynomial3);
        genPolynomial4 = genPolynomial4.monic();
        GenPolynomial<C> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial4);
        genPolynomial5 = genPolynomial5.monic();
        return genPolynomial5;
    }

    public boolean isBaseSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (genPolynomial2.isConstant()) {
            return true;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        genPolynomial3 = genPolynomial3.monic();
        GenPolynomial<C> genPolynomial4 = this.engine.baseGcd(genPolynomial2, genPolynomial3);
        genPolynomial4 = genPolynomial4.monic();
        return genPolynomial4.isONE();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> genPolynomial) {
        GenPolynomial<Object> genPolynomial2;
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isConstant()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        if (!gcdRingElem.isONE()) {
            genPolynomial = genPolynomial.divide(gcdRingElem);
            genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap.put(genPolynomial2, 1L);
            gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.getONE();
        }
        genPolynomial2 = genPolynomial;
        GenPolynomial<Object> genPolynomial3 = null;
        GenPolynomial<Object> genPolynomial4 = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (genPolynomial2.isConstant() || genPolynomial2.isZERO()) break;
                GenPolynomial<Object> genPolynomial5 = PolyUtil.baseDeriviative(genPolynomial2);
                genPolynomial3 = this.engine.baseGcd(genPolynomial2, genPolynomial5);
                genPolynomial3 = genPolynomial3.monic();
                genPolynomial4 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial3);
                l = 0L;
                bl = false;
            }
            if (genPolynomial4.isConstant()) break;
            ++l;
            GenPolynomial genPolynomial6 = this.engine.baseGcd(genPolynomial3, genPolynomial4);
            genPolynomial6 = genPolynomial6.monic();
            GenPolynomial genPolynomial7 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial6);
            genPolynomial4 = genPolynomial6;
            genPolynomial3 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial4);
            if (genPolynomial7.degree(0) <= 0L) continue;
            if (gcdRingElem.isONE() && !((GcdRingElem)genPolynomial7.leadingBaseCoefficient()).isONE()) {
                genPolynomial7 = genPolynomial7.monic();
                logger.info((Object)("z,monic = " + genPolynomial7));
            }
            treeMap.put(genPolynomial7, l);
        }
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = genPolynomial;
        GenPolynomial<C> genPolynomial3 = this.engine.recursiveContent(genPolynomial);
        if (!(genPolynomial3 = genPolynomial3.monic()).isONE()) {
            genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2.leadingExpVector().getVal(0) < 1L) {
            return genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = PolyUtil.recursiveDeriviative(genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial4);
        genPolynomial5 = PolyUtil.monic(genPolynomial5);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial6 = PolyUtil.recursivePseudoDivide(genPolynomial2, genPolynomial5);
        genPolynomial6 = PolyUtil.monic(genPolynomial6);
        return genPolynomial6.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
    }

    public boolean isRecursiveUnivariateSquarefree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomial;
        GenPolynomial<C> genPolynomial3 = this.engine.recursiveContent(genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursiveContent = " + genPolynomial3));
        }
        if (!this.isSquarefree(genPolynomial3)) {
            return false;
        }
        if (!(genPolynomial3 = genPolynomial3.monic()).isONE()) {
            genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2.leadingExpVector().getVal(0) <= 1L) {
            return true;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = PolyUtil.recursiveDeriviative(genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial4);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("gcd = " + genPolynomial5));
        }
        genPolynomial5 = PolyUtil.monic(genPolynomial5);
        return genPolynomial5.isONE();
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        GenPolynomial genPolynomial2;
        GenPolynomial genPolynomial3;
        GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>> genPolynomial4;
        Object object;
        GenPolynomial genPolynomial5;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GcdRingElem gcdRingElem = (GcdRingElem)((Object)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient());
        if (!gcdRingElem.isONE()) {
            genPolynomial5 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(gcdRingElem);
            object = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial5);
            treeMap.put((GenPolynomial<GenPolynomial<C>>)object, 1L);
            genPolynomial4 = (GcdRingElem)gcdRingElem.inverse();
            genPolynomial = genPolynomial.multiply((GenPolynomial<GenPolynomial<GcdRingElem>>)((GenPolynomial)genPolynomialRing2.getONE()).multiply(genPolynomial4));
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient();
        }
        genPolynomial5 = this.engine.recursiveContent(genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("recursiveContent = " + genPolynomial5));
        }
        if (!(genPolynomial5 = genPolynomial5.monic()).isONE()) {
            genPolynomial = PolyUtil.coefficientPseudoDivide(genPolynomial, genPolynomial5);
        }
        object = this.squarefreeFactors((C)genPolynomial5);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("squarefreeFactors = " + object));
        }
        for (Map.Entry object2 : object.entrySet()) {
            genPolynomial3 = (GenPolynomial)object2.getKey();
            if (genPolynomial3.isONE()) continue;
            genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial3);
            Long l = (Long)object2.getValue();
            treeMap.put(genPolynomial2, l);
        }
        genPolynomial4 = genPolynomial;
        genPolynomial3 = null;
        genPolynomial2 = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (genPolynomial4.isConstant() || genPolynomial4.isZERO()) break;
                GenPolynomial genPolynomial6 = PolyUtil.recursiveDeriviative(genPolynomial4);
                genPolynomial3 = this.engine.recursiveUnivariateGcd(genPolynomial4, genPolynomial6);
                genPolynomial3 = PolyUtil.monic(genPolynomial3);
                genPolynomial2 = PolyUtil.recursivePseudoDivide(genPolynomial4, genPolynomial3);
                l = 0L;
                bl = false;
            }
            if (genPolynomial2.isConstant()) break;
            ++l;
            GenPolynomial genPolynomial7 = this.engine.recursiveUnivariateGcd(genPolynomial3, genPolynomial2);
            genPolynomial7 = PolyUtil.monic(genPolynomial7);
            GenPolynomial genPolynomial8 = PolyUtil.recursivePseudoDivide(genPolynomial2, genPolynomial7);
            genPolynomial2 = genPolynomial7;
            genPolynomial3 = PolyUtil.recursivePseudoDivide(genPolynomial3, genPolynomial2);
            if (genPolynomial8.isONE() || genPolynomial8.isZERO()) continue;
            if (gcdRingElem.isONE()) {
                genPolynomial8 = PolyUtil.monic(genPolynomial8);
                logger.info((Object)("z,monic = " + genPolynomial8));
            }
            treeMap.put(genPolynomial8, l);
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreePart(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial3 = this.engine.recursiveContent(genPolynomial2);
        genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        GenPolynomial genPolynomial4 = this.squarefreePart(genPolynomial3);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("content = " + genPolynomial3 + ", squarefreePart = " + genPolynomial4));
        }
        GenPolynomial genPolynomial5 = this.recursiveUnivariateSquarefreePart(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial5.multiply(genPolynomial4);
        GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("univRec = " + genPolynomial2 + ", squarefreePart = " + genPolynomial5));
        }
        return genPolynomial7;
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.isBaseSquarefree(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        return this.isRecursiveUnivariateSquarefree(genPolynomial2);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.normalizeFactorization(this.baseSquarefreeFactors(genPolynomial));
        }
        TreeMap treeMap = new TreeMap();
        if (genPolynomial.isZERO()) {
            return this.normalizeFactorization(treeMap);
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return this.normalizeFactorization(treeMap);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
        SortedMap sortedMap = this.recursiveUnivariateSquarefreeFactors(genPolynomial2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            Long l = entry.getValue();
            GenPolynomial genPolynomial3 = entry.getKey();
            GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("squarefreeFactors(" + genPolynomial + ") = " + treeMap));
        }
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C c) {
        throw new UnsupportedOperationException("method not implemented");
    }
}

