/*
 * Decompiled with CFR 0.152.
 */
package net.sf.epsgraphics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import net.sf.epsgraphics.EpsGraphics;

final class EpsDocument {
    private OutputStream stream;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private boolean _isClipSet = false;
    private String title;
    private BufferedWriter bufferedWriter = null;
    private EpsGraphics _lastG = null;

    EpsDocument(String title, OutputStream outputStream, int minX, int minY, int maxX, int maxY) throws IOException {
        this.title = title;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.stream = outputStream;
        this.write(this.bufferedWriter);
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void append(EpsGraphics g, String line) {
        if (this._lastG == null) {
            this._lastG = g;
        } else if (g != this._lastG) {
            EpsGraphics lastG = this._lastG;
            this._lastG = g;
            if (g.getClip() != lastG.getClip()) {
                g.setClip(g.getClip());
            }
            if (!g.getColor().equals(lastG.getColor())) {
                g.setColor(g.getColor());
            }
            if (!g.getBackground().equals(lastG.getBackground())) {
                g.setBackground(g.getBackground());
            }
            if (!g.getPaint().equals(lastG.getPaint())) {
                g.setPaint(g.getPaint());
            }
            if (!g.getComposite().equals(lastG.getComposite())) {
                g.setComposite(g.getComposite());
            }
            if (!g.getComposite().equals(lastG.getComposite())) {
                g.setComposite(g.getComposite());
            }
            if (!g.getFont().equals(lastG.getFont())) {
                g.setFont(g.getFont());
            }
            if (!g.getStroke().equals(lastG.getStroke())) {
                g.setStroke(g.getStroke());
            }
        }
        this._lastG = g;
        try {
            this.bufferedWriter.write(String.valueOf(line) + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write to the output file: " + e);
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        float offsetX = -this.minX;
        float offsetY = -this.minY;
        writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        writer.write("%%Creator: EpsGraphics 1.0.0 by Thomas Abeel, http://www.sourceforge.net/epsgraphics/\n");
        writer.write("%%Title: " + this.title + "\n");
        writer.write("%%CreationDate: " + new Date() + "\n");
        writer.write("%%BoundingBox: 0 0 " + (int)Math.ceil((float)this.maxX + offsetX) + " " + (int)Math.ceil((float)this.maxY + offsetY) + "\n");
        writer.write("%%DocumentData: Clean7Bit\n");
        writer.write("%%LanguageLevel: 2\n");
        writer.write("%%DocumentProcessColors: Black\n");
        writer.write("%%ColorUsage: Color\n");
        writer.write("%%Origin: 0 0\n");
        writer.write("%%Pages: 1\n");
        writer.write("%%Page: 1 1\n");
        writer.write("%%EndComments\n\n");
        writer.write("gsave\n");
        writer.write(String.valueOf(offsetX) + " " + ((float)this.maxY + offsetY) + " translate\n");
        writer.flush();
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("grestore\n");
        if (this.isClipSet()) {
            writer.write("grestore\n");
        }
        writer.write("showpage\n");
        writer.write("\n");
        writer.write("%%EOF");
        writer.flush();
    }

    public synchronized void flush() throws IOException {
        this.bufferedWriter.flush();
    }

    public synchronized void close() throws IOException {
        this.writeFooter(this.bufferedWriter);
        this.bufferedWriter.flush();
        this.bufferedWriter.close();
    }

    public boolean isClipSet() {
        return this._isClipSet;
    }

    public void setClipSet(boolean isClipSet) {
        this._isClipSet = isClipSet;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public OutputStream getStream() {
        return this.stream;
    }
}

