/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToComplex<C extends GcdRingElem<C> & Rational>
implements UnaryFunctor<C, ComplexAlgebraicNumber<C>> {
    protected final ComplexAlgebraicRing<C> cfac;
    protected final AlgebraicNumber<Complex<C>> zero;
    protected final ComplexRing<C> cr;

    public CoeffToComplex(ComplexAlgebraicRing<C> complexAlgebraicRing) {
        if (complexAlgebraicRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = complexAlgebraicRing;
        AlgebraicNumberRing algebraicNumberRing = this.cfac.algebraic;
        this.zero = algebraicNumberRing.getZERO();
        this.cr = (ComplexRing)algebraicNumberRing.ring.coFac;
    }

    @Override
    public ComplexAlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.cfac.getZERO();
        }
        return new ComplexAlgebraicNumber<C>(this.cfac, this.zero.sum(new Complex<C>(this.cr, c)));
    }
}

